/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.enterprise;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IServerFailoverPolicy;
import com.wily.introscope.agent.connection.failover.RoundRobinServerFailoverPolicy;
import com.wily.introscope.agent.server.property.ServerHostProperty;
import com.wily.introscope.agent.server.property.ServerPortProperty;
import com.wily.introscope.agent.server.property.ServerSocketFactoryProperty;
import com.wily.introscope.agent.server.property.ServerUrlCompositeProperty;
import com.wily.introscope.agent.server.property.ServerUrlProperty;
import com.wily.introscope.agent.util.AgentConnectionOrderParser;
import com.wily.introscope.extensions.agent.socketfactory.SocketFactoryAdministrator;
import com.wily.isengard.IsengardException;
import com.wily.isengard.api.ServerInstanceLocator;
import com.wily.isengard.api.ServerInstanceLocatorPropertiesParser;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.EnvironmentPropertiesHandler;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.MultiPropertyKeyAdapter;
import com.wily.util.resource.IResource;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

class FailoverPolicyFactory {
    private static final int kPauseBetweenEMConnectionCyclesInMillis = 10000;
    private static final String kListSeparator = ",";
    private IndexedProperties fProperties;
    private IndexedProperties fIsengardProperties;
    private IStringLocalizer fLocalizer;
    private IModuleFeedbackChannel fFeedback;
    private Module fIsengardModule;
    private List fSocketFactoryClasses = new ArrayList();
    private static final String fSSLStorePath = "introscope.ssl.storepath";

    public FailoverPolicyFactory(IAgent agent) {
        this(agent.IAgent_getIndexedProperties(), agent.IAgent_getStringLocalizer(), agent.IAgent_getModuleFeedback(), agent);
    }

    public FailoverPolicyFactory(IndexedProperties properties, IStringLocalizer localizer, IModuleFeedbackChannel feedback) {
        this.fProperties = properties;
        this.fFeedback = feedback;
        this.fIsengardModule = new Module("Isengard");
        this.fIsengardProperties = this.translateToIsengardProperties(properties);
        this.fLocalizer = localizer;
    }

    public FailoverPolicyFactory(IndexedProperties properties, IStringLocalizer localizer, IModuleFeedbackChannel feedback, IAgent agent) {
        this.fProperties = properties;
        this.addAgentHomeProperty(properties, agent);
        this.fIsengardModule = new Module("Isengard");
        this.fFeedback = feedback;
        SocketFactoryAdministrator socketFactoryAdministrator = new SocketFactoryAdministrator(agent);
        this.fSocketFactoryClasses = socketFactoryAdministrator.getSocketFactoryClasses();
        this.fIsengardProperties = this.translateToIsengardProperties(properties);
        this.fLocalizer = localizer;
    }

    private void addAgentHomeProperty(IndexedProperties properties, IAgent agent) {
        ExtendedFile sslStore = null;
        IResource resource = agent.IAgent_getConfigurationResource();
        Assertion.wilyAssert(false);
        if (resource != null && resource.IResource_isFileResource()) {
            sslStore = new ExtendedFile(new File(resource.IResource_getLocation()).getParent());
            String sslStorePath = null;
            try {
                sslStorePath = sslStore.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            agent.IAgent_getIndexedProperties().addIndexedProperty(fSSLStorePath, sslStorePath);
        }
    }

    public IServerFailoverPolicy getIsengardFailoverPolicy() throws Exception {
        String connectionOrder = this.getIsengardProperties().getProperty("introscope.agent.enterprisemanager.connectionorder");
        if (connectionOrder == null) {
            this.getFeedbackChannel().info(this.fIsengardModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Connection_No_Connection_Order_Message", "introscope.agent.enterprisemanager.connectionorder", "IntroscopeAgent.profile"));
            return this.getDefaultTCPServerFailoverPolicy();
        }
        String[] connectionList = StringUtils.parseAndTrimList(connectionOrder, kListSeparator);
        ArrayList serverLocatorList = new ArrayList(connectionList.length);
        for (int i = 0; i < connectionList.length; ++i) {
            String emIdentifier = connectionList[i];
            this.addNextFailoverServerLocator(emIdentifier, serverLocatorList);
        }
        IServerFailoverPolicy policyToReturn = null;
        if (serverLocatorList.isEmpty()) {
            this.getFeedbackChannel().warn(this.fIsengardModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Connection_Invalid_Connection_Order_Message", "introscope.agent.enterprisemanager.connectionorder", "IntroscopeAgent.profile"));
            policyToReturn = this.getDefaultTCPServerFailoverPolicy();
        } else {
            ServerInstanceLocator[] serverLocatorArray = serverLocatorList.toArray(new ServerInstanceLocator[serverLocatorList.size()]);
            int agentFailbackRetryIntervalInSeconds = 0;
            if (serverLocatorArray.length >= 1) {
                agentFailbackRetryIntervalInSeconds = this.getFailbackRetryIntervalInSecondsFromProperties();
            }
            policyToReturn = new RoundRobinServerFailoverPolicy(serverLocatorArray, 10000L, this.getReconnectDelayInSecondsProperties(this.fIsengardModule), agentFailbackRetryIntervalInSeconds);
        }
        return policyToReturn;
    }

    private IServerFailoverPolicy getDefaultTCPServerFailoverPolicy() throws IsengardException {
        ServerInstanceLocatorPropertiesParser serverLocatorParser = new ServerInstanceLocatorPropertiesParser(this.getIsengardProperties(), true, null, this.getFeedbackChannel());
        ServerInstanceLocator serverLocator = serverLocatorParser.getServerInstanceLocator();
        if (serverLocator.getLocalPort() == 0) {
            if (!serverLocator.getLocalHostName().equals("localhost")) {
                this.getFeedbackChannel().warn(this.fIsengardModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Connection_Invalid_Local_Host_Port_Message", ""));
            }
            this.getFeedbackChannel().info(this.fIsengardModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Connection_Parameters_Message", "FIXME", serverLocator.getHostName(), Integer.toString(serverLocator.getPort()), Integer.toString(serverLocator.getSocketReceiveBufferSize()), Integer.toString(serverLocator.getSocketSendBufferSize())));
        } else {
            this.getFeedbackChannel().info(this.fIsengardModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Connection_Parameters_Message2", "FIXME", serverLocator.getHostName(), Integer.toString(serverLocator.getPort()), Integer.toString(serverLocator.getLocalPort()), serverLocator.getLocalHostName(), Integer.toString(serverLocator.getSocketReceiveBufferSize()), Integer.toString(serverLocator.getSocketSendBufferSize())));
        }
        return new RoundRobinServerFailoverPolicy(new ServerInstanceLocator[]{serverLocator}, 10000L, this.getReconnectDelayInSecondsProperties(this.fIsengardModule), 0);
    }

    private int getReconnectDelayInSecondsProperties(Module module) {
        int delay = this.getProperties().safeGetIntProperty("introscope.agent.reconnectDelayInSeconds", 15, this.getFeedbackChannel(), this.getStringLocalizer());
        this.getFeedbackChannel().info(module, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Reconnect_Delay_Default_Changed", Integer.toString(delay)));
        return delay;
    }

    private int getFailbackRetryIntervalInSecondsFromProperties() {
        int retryInterval = this.getProperties().safeGetIntProperty("introscope.agent.enterprisemanager.failbackRetryIntervalInSeconds", 0, this.getFeedbackChannel(), this.getStringLocalizer());
        if (retryInterval < 0) {
            this.getFeedbackChannel().warn(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Enterprise_Manager_Failback_Interval_Error_Message"));
            retryInterval = 0;
        } else if (retryInterval == 0) {
            this.getFeedbackChannel().info(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Enterprise_Manager_Failback_Disabled_Message"));
        } else {
            this.getFeedbackChannel().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Failback_Enabled_Message", Integer.toString(retryInterval)));
        }
        return retryInterval;
    }

    private int getSocketReadTimeoutFromProperties(Module module) {
        int timeOutInMillis = 1000 * this.getProperties().safeGetIntProperty("introscope.agent.enterprisemanager.transport.tcp.socketReadTimeoutInSeconds", 60, this.getFeedbackChannel(), this.getStringLocalizer());
        if (timeOutInMillis < 0) {
            this.getFeedbackChannel().warn(module, this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_JIP_Protocol_TCP_Socket_Read_Timeout_Invalid_Message"));
            timeOutInMillis = 60000;
        } else if (timeOutInMillis == 0) {
            this.getFeedbackChannel().warn(module, this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_JIP_Protocol_TCP_Socket_Read_Timeout_Disabled_Message"));
        } else {
            this.getFeedbackChannel().info(module, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_JIP_Protocol_TCP_Socket_Read_Timeout_Enabled_Message", Integer.toString(timeOutInMillis / 1000)));
        }
        return timeOutInMillis;
    }

    private void addNextFailoverServerLocator(String emIdentifier, List serverLocatorList) {
        try {
            ServerInstanceLocatorPropertiesParser serverLocatorParser = new ServerInstanceLocatorPropertiesParser(this.getIsengardProperties(), true, emIdentifier, this.fSocketFactoryClasses, this.getFeedbackChannel());
            ServerInstanceLocator serverLocator = serverLocatorParser.getServerInstanceLocator();
            serverLocatorList.add(serverLocator);
        }
        catch (IsengardException e) {
            this.getFeedbackChannel().warn(this.fIsengardModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Enterprise_Manager_Config_Error_Message", emIdentifier, e.getMessage()));
        }
    }

    private IndexedProperties translateToIsengardProperties(IndexedProperties properties) {
        IndexedProperties translatedProps = null;
        boolean ignoreNewProperties = false;
        String connectionOrder = this.buildAgentConnectionOrder(properties);
        if (connectionOrder == null) {
            ignoreNewProperties = true;
            connectionOrder = properties.getProperty("introscope.agent.enterprisemanager.connectionorder");
        } else {
            this.getFeedbackChannel().info(this.fIsengardModule, "Found new short EM connection properties in agent profile file. Will Override all old property values with new values");
        }
        if (connectionOrder == null) {
            MultiPropertyKeyAdapter adapter = new MultiPropertyKeyAdapter(properties);
            if (!ignoreNewProperties) {
                this.translateAgentConnShortKeys(null, adapter, this.getFeedbackChannel());
            }
            this.translateKeys(null, adapter);
            translatedProps = new IndexedProperties(adapter.getAdaptedProperties());
            translatedProps.setProperty("client.enabled.channel", "default");
        } else {
            String emIdentifier;
            int i;
            String[] connectionList = StringUtils.parseAndTrimList(connectionOrder, kListSeparator);
            MultiPropertyKeyAdapter adapter = new MultiPropertyKeyAdapter(properties);
            for (i = 0; i < connectionList.length; ++i) {
                emIdentifier = connectionList[i];
                if (!ignoreNewProperties) {
                    this.translateAgentConnShortKeys(emIdentifier, adapter, this.getFeedbackChannel());
                }
                this.translateKeys(emIdentifier, adapter);
            }
            translatedProps = new IndexedProperties((Map)adapter.getAdaptedProperties());
            for (i = 0; i < connectionList.length; ++i) {
                emIdentifier = connectionList[i];
                translatedProps.setProperty("client.enabled.channel." + emIdentifier, "default");
            }
        }
        return translatedProps;
    }

    private String buildAgentConnectionOrder(IndexedProperties properties) {
        String connectionOrder = null;
        ArrayList<String> urls = new ArrayList<String>();
        this.getIndexedUrlProperties(urls, "agentManager.url", properties);
        this.getIndexedUrlProperties(urls, "agentManager.url", System.getProperties());
        EnvironmentPropertiesHandler instance = EnvironmentPropertiesHandler.getInstance();
        if (instance != null && instance.hasData()) {
            this.getIndexedUrlPropertiesFromEnvProperties(urls, "agentManager.url".toLowerCase(), instance.getAllKeys());
        }
        try {
            connectionOrder = AgentConnectionOrderParser.buildConnectionOrder(urls);
        }
        catch (Exception e) {
            this.fFeedback.debug(this.fIsengardModule, "Exception seen when building Connection Order from new agentManager keys" + e.getMessage());
        }
        if (connectionOrder != null) {
            this.fFeedback.info(this.fIsengardModule, "Connection Order '" + connectionOrder + "' determined from agentManager URL's , will be used by agent");
            properties.setProperty("introscope.agent.enterprisemanager.connectionorder", connectionOrder);
        }
        return connectionOrder;
    }

    private List<String> getIndexedUrlProperties(List<String> urlKeys, String key, Properties properties) {
        String url;
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String nextKey = (String)keys.nextElement();
            if (!nextKey.startsWith(key) || urlKeys.contains(nextKey)) continue;
            urlKeys.add(nextKey);
        }
        String agentManager = properties.getProperty("agentManager");
        if (agentManager != null && agentManager.length() > 0 && !urlKeys.contains(url = "agentManager.url.1")) {
            urlKeys.add(url);
        }
        return urlKeys;
    }

    private List<String> getIndexedUrlPropertiesFromEnvProperties(List<String> urlKeys, String key, Set<String> keys) {
        if (keys != null) {
            String agentManagerLowercase = "agentManager".toLowerCase();
            for (String nextKey : keys) {
                String url;
                if (nextKey.startsWith(key)) {
                    String rightCaseKey = nextKey.replace(agentManagerLowercase, "agentManager");
                    if (urlKeys.contains(rightCaseKey)) continue;
                    urlKeys.add(rightCaseKey);
                    continue;
                }
                if (!nextKey.equals(agentManagerLowercase) || urlKeys.contains(url = "agentManager.url.1")) continue;
                urlKeys.add(url);
            }
        }
        return urlKeys;
    }

    private void translateKeys(String emIdentifier, MultiPropertyKeyAdapter adapter) {
        String suffix = null;
        if (emIdentifier != null) {
            suffix = "." + emIdentifier;
        }
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.tcp.host" + suffix, "transport.tcp.host" + suffix);
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.tcp.port" + suffix, "transport.tcp.port" + suffix);
        if (suffix == null) {
            adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.tcp.socketfactory", "client.socketfactory.default");
        } else {
            adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.tcp.socketfactory" + suffix, "client.socketfactory." + emIdentifier + ".default");
        }
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.tcp.local.ipaddress" + suffix, "transport.tcp.local.ipaddress" + suffix);
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.tcp.local.port" + suffix, "transport.tcp.local.port" + suffix);
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.tcp.readBufferSize" + suffix, "transport.tcp.readBufferSize" + suffix);
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.tcp.writeBufferSize" + suffix, "transport.tcp.writeBufferSize" + suffix);
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.tcp.ciphersuites" + suffix, "transport.tcp.ciphersuites" + suffix);
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.tcp.truststore" + suffix, "transport.tcp.truststore" + suffix);
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.tcp.trustpassword" + suffix, "transport.tcp.trustpassword" + suffix);
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.tcp.keystore" + suffix, "transport.tcp.keystore" + suffix);
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.tcp.keypassword" + suffix, "transport.tcp.keypassword" + suffix);
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.tcp.tls.validateHostname" + suffix, "transport.tcp.tls.validateHostname" + suffix);
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.http.proxy.host", "transport.http.proxy.host");
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.http.proxy.port", "transport.http.proxy.port");
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.http.proxy.username", "transport.http.proxy.username");
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.http.proxy.password", "transport.http.proxy.password");
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.http.proxy.realm", "transport.http.proxy.realm");
        adapter.setKeyMapping("introscope.agent.enterprisemanager.transport.http.tryIPAddr", "transport.http.tryIPAddr");
    }

    private void translateAgentConnShortKeys(String emIdentifier, MultiPropertyKeyAdapter adapter, IModuleFeedbackChannel feedbackChannel) {
        ServerUrlCompositeProperty compositeProp;
        String suffix = null;
        if (emIdentifier != null) {
            suffix = "." + emIdentifier;
        }
        if ((compositeProp = this.getServerUrlCompositeProperty(suffix, adapter, feedbackChannel)).hasValue()) {
            adapter.setKeyMapping(new ServerHostProperty("agentManager.host" + suffix, compositeProp), "transport.tcp.host" + suffix);
            adapter.setKeyMapping(new ServerPortProperty("agentManager.port" + suffix, compositeProp), "transport.tcp.port" + suffix);
            if (suffix == null) {
                adapter.setKeyMapping(new ServerSocketFactoryProperty("introscope.agent.enterprisemanager.transport.tcp.socketfactory", compositeProp), "client.socketfactory.default");
            } else {
                adapter.setKeyMapping(new ServerSocketFactoryProperty("agentManager.socketfactory" + suffix, compositeProp), "client.socketfactory." + emIdentifier + ".default");
            }
        } else {
            this.fFeedback.info(this.fIsengardModule, "Unable to dertermine valid EM connection properties from agentManager url :" + compositeProp.getPropertyName() + ".Agent will nowcheck for older properties having same suffix " + suffix);
        }
        adapter.setKeyMapping("agentManager.localIpaddress" + suffix, "transport.tcp.local.ipaddress" + suffix);
        adapter.setKeyMapping("agentManager.localPort" + suffix, "transport.tcp.local.port" + suffix);
        adapter.setKeyMapping("agentManager.readBufferSize" + suffix, "transport.tcp.readBufferSize" + suffix);
        adapter.setKeyMapping("agentManager.writeBufferSize" + suffix, "transport.tcp.writeBufferSize" + suffix);
        adapter.setKeyMapping("agentManager.cipherSuites" + suffix, "transport.tcp.ciphersuites" + suffix);
        adapter.setKeyMapping("agentManager.trustStore" + suffix, "transport.tcp.truststore" + suffix);
        adapter.setKeyMapping("agentManager.trustStorePassword" + suffix, "transport.tcp.trustpassword" + suffix);
        adapter.setKeyMapping("agentManager.keyStore" + suffix, "transport.tcp.keystore" + suffix);
        adapter.setKeyMapping("agentManager.keyStorePassword" + suffix, "transport.tcp.keypassword" + suffix);
        adapter.setKeyMapping("agentManager.tls.validateHostname", "transport.tcp.tls.validateHostname");
        adapter.setKeyMapping("agentManager.httpProxy.host", "transport.http.proxy.host");
        adapter.setKeyMapping("agentManager.httpProxy.port", "transport.http.proxy.port");
        adapter.setKeyMapping("agentManager.httpProxy.username", "transport.http.proxy.username");
        adapter.setKeyMapping("agentManager.httpProxy.password", "transport.http.proxy.password");
        adapter.setKeyMapping("agentManager.httpProxy.realm", "transport.http.proxy.realm");
        adapter.setKeyMapping("agentManager.http.tryIPAddr", "transport.http.tryIPAddr");
    }

    private ServerUrlCompositeProperty getServerUrlCompositeProperty(String suffix, MultiPropertyKeyAdapter adapter, IModuleFeedbackChannel feedbackChannel) {
        String value = null;
        String urlKey = "agentManager.url" + suffix;
        if (suffix.endsWith(".1")) {
            adapter.setKeyMapping(urlKey, urlKey);
            adapter.setKeyMapping("agentManager", urlKey);
            value = adapter.getMappedPropertyValue(urlKey);
        }
        if (value == null) {
            value = this.fProperties.getTrimmedProperty(urlKey);
        }
        return new ServerUrlProperty(urlKey, value, feedbackChannel);
    }

    private IndexedProperties getProperties() {
        return this.fProperties;
    }

    private IndexedProperties getIsengardProperties() {
        return this.fIsengardProperties;
    }

    private IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    private IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }

    IndexedProperties getIsengardProperties_UseOnlyForUT() {
        IndexedProperties properties = new IndexedProperties();
        properties.putAll((Map<?, ?>)this.fIsengardProperties);
        return properties;
    }
}

