/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io.clamp;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.io.clamp.ASocketClampManager;
import com.wily.introscope.agent.trace.io.clamp.TracedSockets;
import com.wily.introscope.agent.trace.nio.DatagramChannelMap;
import com.wily.util.properties.AttributeListing;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public class DatagramReceiveMethodClampManager
extends ASocketClampManager {
    public DatagramReceiveMethodClampManager(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected void decideOnClamp(InvocationData data) {
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Object result = data.getInvocationReturnValueAsObject();
        Object invocationObject = data.getInvocationObject();
        try {
            if (result instanceof InetSocketAddress && invocationObject instanceof DatagramChannel && !this.isClientSideAndNotClamped((InetSocketAddress)result, (DatagramChannel)invocationObject)) {
                DatagramChannel channel = (DatagramChannel)data.getInvocationObject();
                int port = channel.socket().getLocalPort();
                boolean traced = TracedSockets.isTraced(port);
                if (!traced) {
                    traced = TracedSockets.add(port);
                }
                if (!traced) {
                    data.setSocketClamp(!traced);
                }
            }
        }
        catch (Exception e) {
            this.getModuleFeedback().error(e);
        }
    }

    private boolean isClientSideAndNotClamped(InetSocketAddress remoteAddress, DatagramChannel channel) {
        InetSocketAddress address = DatagramChannelMap.getAddress(channel, remoteAddress);
        return address != null;
    }
}

