/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.appmap.remotehttp;

import com.wily.introscope.spec.server.appmap.remotehttp.RemoteHttpCall;
import com.wily.introscope.spec.server.appmap.remotehttp.RemoteHttpCallService;
import com.wily.introscope.spec.server.appmap.remotehttp.RemoteHttpCallback;
import com.wily.introscope.spec.server.appmap.remotehttp.RemoteHttpCallbackHandler;
import com.wily.introscope.spec.server.appmap.remotehttp.RemoteHttpResponse;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.service.MessageServiceFactory;
import com.wily.isengard.messageprimitives.service.ServiceException;
import com.wily.isengard.postoffice.PostOffice;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RemoteHttpCallClient
implements RemoteHttpCall {
    public static final int MAX_NOT_CHUNKED_PAYLOAD_SIZE_DEFAULT = 786432;
    public static final int CHUNK_SIZE_DEFAULT = 786432;
    private static final int DEFAULT_AWAIT_TIMEOUT = 180;
    private static final Pattern REQUESTID_PATTERN = Pattern.compile("\"requestId\"[^:]*:[^\"]*\"([^\"]*)\"");
    private final int awaitTimeout;
    private final RemoteHttpCallService remoteHttpCallService;
    private final PostOffice postOffice;
    private final int notChunkedLimit;
    private final int chunkSize;

    public RemoteHttpCallClient(PostOffice postOffice, int awaitTimeout) throws ConnectionException, ServiceException {
        this(postOffice, awaitTimeout, 786432, 786432);
    }

    public RemoteHttpCallClient(PostOffice postOffice, int awaitTimeout, int notChunkedLimit, int chunkSize) throws ConnectionException, ServiceException {
        this.postOffice = postOffice;
        this.awaitTimeout = awaitTimeout;
        this.notChunkedLimit = notChunkedLimit;
        this.chunkSize = chunkSize;
        this.remoteHttpCallService = this.getRemoteHttpCallService();
    }

    protected RemoteHttpCallService getRemoteHttpCallService() throws ConnectionException, ServiceException {
        return MessageServiceFactory.getService(this.postOffice, RemoteHttpCallService.class);
    }

    public RemoteHttpCallClient(PostOffice po) throws ConnectionException, ServiceException {
        this(po, 180);
    }

    @Override
    public RemoteHttpResponse doHead(final String requestPath, final Map<String, String> additionalHeaders) throws ConnectionException {
        RemoteHttpResponseWrapper wrapper = new RemoteHttpResponseWrapper(this){

            @Override
            protected void doCall(RemoteHttpCallback callback) throws ConnectionException {
                remoteHttpCallService.doHead(requestPath, additionalHeaders, callback);
            }
        };
        return wrapper.call();
    }

    @Override
    public RemoteHttpResponse doGet(final String requestPath, final Map<String, String> additionalHeaders) throws ConnectionException {
        RemoteHttpResponseWrapper wrapper = new RemoteHttpResponseWrapper(this){

            @Override
            protected void doCall(RemoteHttpCallback callback) throws ConnectionException {
                remoteHttpCallService.doGet(requestPath, additionalHeaders, callback);
            }
        };
        return wrapper.call();
    }

    public RemoteHttpResponse doPost(String requestPath, String payload, Map<String, String> additionalHeaders) throws ConnectionException, UnsupportedEncodingException {
        return this.doPost(requestPath, payload.getBytes("UTF-8"), additionalHeaders);
    }

    @Override
    public RemoteHttpResponse doPost(final String requestPath, final byte[] payload, final Map<String, String> additionalHeaders) throws ConnectionException {
        if (payload.length > this.notChunkedLimit) {
            return this.doChunkedCall("POST", requestPath, payload, additionalHeaders);
        }
        RemoteHttpResponseWrapper wrapper = new RemoteHttpResponseWrapper(this){

            @Override
            protected void doCall(RemoteHttpCallback callback) throws ConnectionException {
                remoteHttpCallService.doPost(requestPath, payload, additionalHeaders, callback);
            }
        };
        return wrapper.call();
    }

    public RemoteHttpResponse doPut(String requestPath, String payload, Map<String, String> additionalHeaders) throws ConnectionException, UnsupportedEncodingException {
        return this.doPut(requestPath, payload.getBytes("UTF-8"), additionalHeaders);
    }

    @Override
    public RemoteHttpResponse doPut(final String requestPath, final byte[] payload, final Map<String, String> additionalHeaders) throws ConnectionException {
        if (payload.length > this.notChunkedLimit) {
            return this.doChunkedCall("PUT", requestPath, payload, additionalHeaders);
        }
        RemoteHttpResponseWrapper wrapper = new RemoteHttpResponseWrapper(this){

            @Override
            protected void doCall(RemoteHttpCallback callback) throws ConnectionException {
                remoteHttpCallService.doPut(requestPath, payload, additionalHeaders, callback);
            }
        };
        return wrapper.call();
    }

    public RemoteHttpResponse doPatch(String requestPath, String payload, Map<String, String> additionalHeaders) throws ConnectionException, UnsupportedEncodingException {
        return this.doPatch(requestPath, payload.getBytes("UTF-8"), additionalHeaders);
    }

    @Override
    public RemoteHttpResponse doPatch(final String requestPath, final byte[] payload, final Map<String, String> additionalHeaders) throws ConnectionException {
        if (payload.length > this.notChunkedLimit) {
            return this.doChunkedCall("PATCH", requestPath, payload, additionalHeaders);
        }
        RemoteHttpResponseWrapper wrapper = new RemoteHttpResponseWrapper(this){

            @Override
            protected void doCall(RemoteHttpCallback callback) throws ConnectionException {
                remoteHttpCallService.doPatch(requestPath, payload, additionalHeaders, callback);
            }
        };
        return wrapper.call();
    }

    @Override
    public RemoteHttpResponse doDelete(final String requestPath, final Map<String, String> additionalHeaders) throws ConnectionException {
        RemoteHttpResponseWrapper wrapper = new RemoteHttpResponseWrapper(this){

            @Override
            protected void doCall(RemoteHttpCallback callback) throws ConnectionException {
                remoteHttpCallService.doDelete(requestPath, additionalHeaders, callback);
            }
        };
        return wrapper.call();
    }

    @Override
    public RemoteHttpResponse prepareChunkedRequest(final String method, final String requestPath, final Map<String, String> additionalHeaders) throws ConnectionException {
        RemoteHttpResponseWrapper wrapper = new RemoteHttpResponseWrapper(this){

            @Override
            protected void doCall(RemoteHttpCallback callback) throws ConnectionException {
                remoteHttpCallService.prepareChunkedRequest(method, requestPath, additionalHeaders, callback);
            }
        };
        return wrapper.call();
    }

    @Override
    public RemoteHttpResponse addPayloadChunk(final String requestId, final int chunkNo, final boolean isLastChunk, final byte[] chunk) throws ConnectionException {
        RemoteHttpResponseWrapper wrapper = new RemoteHttpResponseWrapper(this){

            @Override
            protected void doCall(RemoteHttpCallback callback) throws ConnectionException {
                remoteHttpCallService.addPayloadChunk(requestId, chunkNo, isLastChunk, chunk, callback);
            }
        };
        return wrapper.call();
    }

    private RemoteHttpResponse doChunkedCall(String method, String requestPath, byte[] payload, Map<String, String> additionalHeaders) throws ConnectionException {
        RemoteHttpResponse response = this.prepareChunkedRequest(method, requestPath, additionalHeaders);
        if (response == null || response.getHttpCode() != 200) {
            return response;
        }
        Matcher matcher = REQUESTID_PATTERN.matcher(new String(response.getResponseBody()));
        if (!matcher.find()) {
            throw new ConnectionException("Server returned unexpected response, cannot extract requestId");
        }
        String requestId = matcher.group(1);
        int numOfChunks = payload.length / this.chunkSize;
        if (payload.length % this.chunkSize > 0) {
            ++numOfChunks;
        }
        int i = 0;
        while (i < numOfChunks) {
            byte[] chunk;
            boolean isLastChunk = i + 1 >= numOfChunks;
            response = this.addPayloadChunk(requestId, i, isLastChunk, chunk = RemoteHttpCallClient.getSubRange(payload, i * this.chunkSize, Math.min((i + 1) * this.chunkSize, payload.length)));
            if (response == null || response.getHttpCode() != 202) {
                return response;
            }
            ++i;
        }
        return response;
    }

    private static byte[] getSubRange(byte[] original, int from, int to) {
        int newLength = to - from;
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    private abstract class RemoteHttpResponseWrapper {
        final CountDownLatch callbackLatch = new CountDownLatch(1);
        final AtomicReference<RemoteHttpResponse> returnValue = new AtomicReference();
        final AtomicReference<Exception> exceptionValue = new AtomicReference();
        RemoteHttpCallback tpCallback;

        private RemoteHttpResponseWrapper() {
            this.tpCallback = new RemoteHttpCallback(RemoteHttpCallClient.this.postOffice, new RemoteHttpCallbackHandler(){

                @Override
                public void closing() throws ConnectionException {
                    RemoteHttpResponseWrapper.this.callbackLatch.countDown();
                }

                @Override
                public void handleResponse(RemoteHttpResponse response) throws ConnectionException {
                    RemoteHttpResponseWrapper.this.returnValue.set(response);
                    RemoteHttpResponseWrapper.this.callbackLatch.countDown();
                }

                @Override
                public void handleException(Exception exception) throws ConnectionException {
                    RemoteHttpResponseWrapper.this.exceptionValue.set(exception);
                    RemoteHttpResponseWrapper.this.callbackLatch.countDown();
                }
            });
        }

        public RemoteHttpResponse call() throws ConnectionException {
            try {
                this.doCall(this.tpCallback);
                try {
                    if (!this.callbackLatch.await(RemoteHttpCallClient.this.awaitTimeout, TimeUnit.SECONDS)) {
                        throw new ConnectionException("Callback timed out in " + RemoteHttpCallClient.this.awaitTimeout);
                    }
                }
                catch (InterruptedException e) {
                    throw new ConnectionException("Callback interrupted" + e.getMessage(), e);
                }
            }
            finally {
                this.tpCallback.close();
            }
            Exception e = this.exceptionValue.get();
            if (e != null) {
                throw new ConnectionException(e.getMessage(), e);
            }
            return this.doReturn();
        }

        protected abstract void doCall(RemoteHttpCallback var1) throws ConnectionException;

        protected RemoteHttpResponse doReturn() throws ConnectionException {
            RemoteHttpResponse remoteHttpResponse = this.returnValue.get();
            if (remoteHttpResponse == null) {
                throw new ConnectionException("Callback closed before returned result");
            }
            return remoteHttpResponse;
        }
    }
}

