/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.api;

import com.wily.isengard.IsengardException;
import com.wily.isengard.api.ServerInstanceLocator;
import com.wily.isengard.api.ServerInstanceLocatorPropertiesParser;
import com.wily.isengard.api.TransportConfiguration;
import com.wily.isengard.api.TransportConfigurationPropertiesParser;
import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;

public class ClientPropertiesParser {
    private IModuleFeedbackChannel fFeedbackChannel;
    private TransportConfiguration fTransportConfiguration;
    private ServerInstanceLocator fServerInstanceLocator;

    public ClientPropertiesParser(IndexedProperties properties, IModuleFeedbackChannel feedback) throws IsengardException {
        CheckParameter.notNull("Client Properties", properties);
        CheckParameter.notNull("Feedback Channel", feedback);
        IndexedProperties copy = this.getDefensiveCopy(properties);
        this.fFeedbackChannel = feedback;
        this.fTransportConfiguration = this.initializeTransportConfiguration(copy);
        this.fServerInstanceLocator = this.initializeServerInstanceLocator(copy);
    }

    public TransportConfiguration getTransportConfiguration() {
        return this.fTransportConfiguration;
    }

    public ServerInstanceLocator getServerInstanceLocator() {
        return this.fServerInstanceLocator;
    }

    private ServerInstanceLocator initializeServerInstanceLocator(IndexedProperties properties) throws IsengardException {
        ServerInstanceLocatorPropertiesParser serverLocatorParser = new ServerInstanceLocatorPropertiesParser(properties, false, null, this.fFeedbackChannel);
        return serverLocatorParser.getServerInstanceLocator();
    }

    private TransportConfiguration initializeTransportConfiguration(IndexedProperties properties) throws IsengardException {
        TransportConfigurationPropertiesParser transportConfigParser = new TransportConfigurationPropertiesParser(properties, true);
        TransportConfigurationPropertiesParser.removeAllTransportConfigurationProperties(properties);
        return transportConfigParser.getTransportConfiguration();
    }

    private IndexedProperties getDefensiveCopy(IndexedProperties properties) {
        return IndexedProperties.newInstance(properties);
    }
}

