/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.service;

import com.wily.isengard.message.AMessage;
import com.wily.isengard.message.MessageUndeliverableException;
import com.wily.isengard.messageprimitives.service.IllegalServiceAccessException;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.Mailbox;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.util.feedback.Module;

public abstract class AAsyncMessageServiceClient
extends Mailbox {
    private static Module sModule = new Module("AAsyncMessageServiceClient");
    private short fSequenceNumber = 0;
    private Address fServiceAddress;

    public AAsyncMessageServiceClient(PostOffice po, Address serviceAddress) throws IllegalServiceAccessException {
        super(po);
        this.setServiceAddress(serviceAddress);
    }

    public void setServiceAddress(Address address) throws IllegalServiceAccessException {
        if (address != null) {
            this.closeOnPODisconnect(address.getPostOffice());
            this.fServiceAddress = address;
        }
        this.checkPermissions();
    }

    private void checkPermissions() throws IllegalServiceAccessException {
        String hubName = this.getPostOffice().getPostOfficeHub().getHubName();
        if (hubName.startsWith("Server")) {
            return;
        }
        String[] groups = this.fServiceAddress.getGroupAccess();
        if (groups != null) {
            if (groups[0].equals("*")) {
                return;
            }
            String[] stringArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                String group = stringArray[n2];
                if (hubName.startsWith(group)) {
                    return;
                }
                ++n2;
            }
        }
        this.getFeedbackChannel().warn(sModule, "Illegal Service Access attempted to remote service at address " + this.fServiceAddress);
        throw new IllegalServiceAccessException("Illegal Service Access");
    }

    public Address getServiceAddress() {
        return this.fServiceAddress;
    }

    public short sendRequestAsync(AMessage message) throws MessageUndeliverableException {
        message.setSequenceNumber(this.fSequenceNumber);
        message.setLowLatency();
        this.sendMessage(message, this.fServiceAddress);
        short s = this.fSequenceNumber;
        this.fSequenceNumber = (short)(s + 1);
        return s;
    }

    @Override
    public void receiveMessage(AMessage message) {
        this.receiveReply(message);
    }

    protected abstract void receiveReply(AMessage var1);
}

