/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.stream;

import com.wily.isengard.message.AMessage;
import com.wily.isengard.message.MessageUndeliverableException;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InterfaceUtilities;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.MethodCallMessage;
import com.wily.isengard.messageprimitives.service.MessageService;
import com.wily.isengard.messageprimitives.service.MessageServiceFactory;
import com.wily.isengard.messageprimitives.stream.IMessageStreamPublisherService;
import com.wily.isengard.messageprimitives.stream.IRawStreamPublisher;
import com.wily.isengard.messageprimitives.stream.StreamCloseMessage;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.IPostOfficeNotification;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.postoffice.PostOfficeSpecifier;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;

public class MessageStreamPublisher<T>
extends MessageService<IMessageStreamPublisherService>
implements IMessageStreamPublisherService,
InvocationHandler,
IPostOfficeNotification {
    private volatile ArrayList<Address> fSubscribers = new ArrayList();
    private Class<T> fInterface;
    private int fInterfaceVersion;
    private T fPublisher;

    public MessageStreamPublisher(PostOffice po, Class<T> publishInterface) throws InvalidIsengardInterface {
        super(po);
        this.initialize(IMessageStreamPublisherService.class, this);
        this.fInterface = publishInterface;
        this.fInterfaceVersion = InterfaceUtilities.getInterfaceVersion(publishInterface);
        this.fPublisher = this.fInterface.cast(Proxy.newProxyInstance(publishInterface.getClassLoader(), new Class[]{publishInterface}, (InvocationHandler)this));
        this.receivePostOfficeNotification(this);
    }

    public T getPublisher() {
        return this.fPublisher;
    }

    public IRawStreamPublisher getRawPublisher() {
        return (IRawStreamPublisher)Proxy.newProxyInstance(IRawStreamPublisher.class.getClassLoader(), new Class[]{IRawStreamPublisher.class}, (InvocationHandler)this);
    }

    @Override
    public void close() {
        if (!this.fSubscribers.isEmpty()) {
            this.sendMessage(new StreamCloseMessage());
        }
        this.cancelPostOfficeNotification(this);
        super.close();
    }

    @Override
    public String getInterfaceName() {
        return this.fInterface.getName();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.sendData(method, args);
        return null;
    }

    private synchronized void subscribeToStreamInternal(Address address) throws ConnectionException {
        ArrayList<Address> newSubscribers = new ArrayList<Address>(this.fSubscribers);
        newSubscribers.add(address);
        this.fSubscribers = newSubscribers;
        if (this.fSubscribers.size() == 1) {
            this.startPublishing();
        }
    }

    private synchronized void unsubscribeToStreamInternal(Address address) {
        ArrayList<Address> newSubscribers = new ArrayList<Address>(this.fSubscribers);
        newSubscribers.remove(address);
        this.fSubscribers = newSubscribers;
        if (this.fSubscribers.isEmpty()) {
            this.stopPublishing();
        }
    }

    private void sendMessage(AMessage message) {
        ArrayList<Address> subscribers = this.fSubscribers;
        if (!subscribers.isEmpty()) {
            int i = 0;
            while (i < subscribers.size()) {
                Address destination = subscribers.get(i);
                try {
                    this.sendMessage(message, destination);
                }
                catch (MessageUndeliverableException messageUndeliverableException) {
                    subscribers.remove(i);
                    --i;
                }
                ++i;
            }
        }
    }

    protected void sendData(Method method, Object[] params) {
        MethodCallMessage message = new MethodCallMessage(method, this.fInterfaceVersion, params);
        this.sendMessage(message);
    }

    @Override
    public void SubscriptionsFinished() {
    }

    public boolean shouldPublish() {
        return !this.fSubscribers.isEmpty();
    }

    protected Object replyToSubscription() {
        return null;
    }

    @Override
    public Object subscribeToStream(Address address) throws ConnectionException {
        this.subscribeToStreamInternal(address);
        return this.replyToSubscription();
    }

    @Override
    public void unsubscribeToStream(Address address) {
        this.unsubscribeToStreamInternal(address);
    }

    protected void startPublishing() {
    }

    protected void stopPublishing() {
    }

    public static IMessageStreamPublisherService getInterface(PostOffice po, Address address) {
        return MessageServiceFactory.getService(po, IMessageStreamPublisherService.class, address);
    }

    @Override
    public void postOfficeAdded(PostOfficeSpecifier postOffice) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postOfficeRemoved(PostOfficeSpecifier postOffice) {
        Address[] subscribers;
        ArrayList<Address> arrayList = this.fSubscribers;
        synchronized (arrayList) {
            subscribers = this.fSubscribers.toArray(new Address[this.fSubscribers.size()]);
        }
        Address[] addressArray = subscribers;
        int n = subscribers.length;
        int n2 = 0;
        while (n2 < n) {
            Address subscriber = addressArray[n2];
            if (subscriber.getPostOffice().equals(postOffice)) {
                this.unsubscribeToStreamInternal(subscriber);
            }
            ++n2;
        }
    }
}

