/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties.hot;

import com.wily.util.IConfigurationListener;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.BasicPropertyGroupChangeHelper;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationPropertySet;
import com.wily.util.properties.hot.PropertyGroupChangeHelper;
import com.wily.util.properties.hot.PropertyGroupListner;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ConfigurationManager
implements PropertyGroupChangeHelper,
IConfigurationListener {
    private final IModuleFeedbackChannel feedback;
    private final IStringLocalizer localizer;
    private final Map<String, ConfigurationProperty> configurationProperties = new HashMap<String, ConfigurationProperty>();
    private final Set<ConfigurationPropertySet> configurationPropertySets = new HashSet<ConfigurationPropertySet>();
    private IndexedProperties activeProperties;
    private final PropertyGroupChangeHelper propertyGroupHandler;
    private static final Comparator<IndexedValue> INDEXED_VALUE_COMPARATOR = new Comparator<IndexedValue>(){

        @Override
        public int compare(IndexedValue arg0, IndexedValue arg1) {
            return arg0.index - arg1.index;
        }
    };

    public ConfigurationManager(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IndexedProperties initialProps) {
        if (feedback == null || localizer == null) {
            throw new NullPointerException();
        }
        this.feedback = feedback;
        this.localizer = localizer;
        this.activeProperties = initialProps;
        this.propertyGroupHandler = new BasicPropertyGroupChangeHelper(initialProps);
    }

    public final void add(ConfigurationProperty cp) {
        this.add(cp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void add(ConfigurationProperty cp, boolean initialize) {
        if (cp == null) {
            return;
        }
        String name = cp.getName();
        boolean initializeValue = false;
        boolean valueIsFixed = this.activeProperties.getPropertySourceType((String)name).fixed;
        ConfigurationManager configurationManager = this;
        synchronized (configurationManager) {
            if (this.configurationProperties.containsKey(name)) {
                if (!cp.equals(this.configurationProperties.get(name))) {
                    Assertion.wilyAssert("Attempt to add duplicate ConfigurationProperty for '" + name + "'");
                }
            } else {
                this.configurationProperties.put(name, cp);
            }
            if (initialize) {
                if (valueIsFixed) {
                    boolean fixedValueIsValid;
                    block20: {
                        fixedValueIsValid = false;
                        String fixedValue = this.activeProperties.getProperty(name);
                        Object cv = null;
                        try {
                            cv = cp.convert(fixedValue);
                            if (cp.validateValue(cv, "Hot_Property_Invalid_Fixed_Message", false)) {
                                if (!cp.isSilent()) {
                                    cp.feedback.info(cp.module, cp.formatLocalizedMessage("Hot_Property_Fixed_Set_Message", null, cp.toString(cv)));
                                }
                                fixedValueIsValid = true;
                            }
                        }
                        catch (IllegalArgumentException e) {
                            if (!cp.isSilent()) {
                                cp.feedback.error(cp.module, cp.formatLocalizedMessage("Hot_Property_Invalid_Fixed_Message", e.getMessage(), cp.toString(fixedValue)));
                            }
                        }
                        catch (NullPointerException e) {
                            if (cp.isSilent()) break block20;
                            cp.feedback.error(cp.module, cp.formatLocalizedMessage("Hot_Property_Invalid_Fixed_Message", e.getMessage(), cp.toString(fixedValue)));
                        }
                    }
                    if (!fixedValueIsValid) {
                        cp.setNewValueToDefault();
                        cp.setValueAndLog();
                        return;
                    }
                }
                if (this.processProperty(cp, true)) {
                    initializeValue = true;
                }
            }
        }
        if (initializeValue) {
            if (valueIsFixed) {
                cp.setValueNoLog();
            } else {
                cp.setValueAndLog();
            }
        }
    }

    final synchronized boolean isFixed(String name) {
        return this.activeProperties.getPropertySourceType((String)name).fixed;
    }

    public final synchronized void add(ConfigurationPropertySet cps, boolean initialize) {
        if (cps == null) {
            return;
        }
        if (this.configurationPropertySets.contains(cps)) {
            return;
        }
        this.configurationPropertySets.add(cps);
        Iterator<ConfigurationProperty> i = cps.iterator();
        while (i.hasNext()) {
            this.add(i.next(), false);
        }
        if (initialize) {
            this.processConfiguration(true);
        }
    }

    public final synchronized void remove(ConfigurationProperty cp) {
        if (cp == null) {
            return;
        }
        String name = cp.getName();
        this.configurationProperties.remove(name);
    }

    public final synchronized void remove(ConfigurationPropertySet cps, boolean removeConfigurationProperties) {
        if (cps == null) {
            return;
        }
        this.configurationPropertySets.remove(cps);
        if (removeConfigurationProperties) {
            Iterator<ConfigurationProperty> i = cps.iterator();
            while (i.hasNext()) {
                this.remove(i.next());
            }
        }
    }

    public final synchronized void setDefaultValue(String name, Object newDefaultValue) {
        ConfigurationProperty cp = this.configurationProperties.get(name);
        if (cp != null) {
            cp.setDefaultValue(newDefaultValue, this);
        } else {
            Assertion.wilyAssert("setDefaultValue ignored: property '" + name + "' not found");
        }
    }

    @Override
    public final synchronized void onChange(IndexedProperties newProps) {
        this.activeProperties = newProps;
        this.processConfiguration(false);
        this.propertyGroupHandler.onChange(newProps);
    }

    private final void processConfiguration(boolean initialize) {
        HashMap<String, ConfigurationProperty> candidateProperties = new HashMap<String, ConfigurationProperty>(this.configurationProperties);
        HashSet<ConfigurationPropertySet> candidatePropertySets = new HashSet<ConfigurationPropertySet>(this.configurationPropertySets);
        Map<String, ConfigurationProperty> rejectedProperties = this.processProperties(candidateProperties);
        this.processPropertySets(candidatePropertySets, candidateProperties, rejectedProperties);
        this.setProperties(candidateProperties);
        if (initialize) {
            this.setPropertiesToDefault(rejectedProperties);
        }
        this.setPropertySets(candidatePropertySets);
    }

    private final Map<String, ConfigurationProperty> processProperties(Map<String, ConfigurationProperty> candidateProperties) {
        Iterator<ConfigurationProperty> i = candidateProperties.values().iterator();
        HashMap<String, ConfigurationProperty> rejected = new HashMap<String, ConfigurationProperty>();
        while (i.hasNext()) {
            ConfigurationProperty cp = i.next();
            if (this.processProperty(cp, false)) continue;
            i.remove();
            rejected.put(cp.getName(), cp);
        }
        return rejected;
    }

    private final boolean processProperty(ConfigurationProperty cp, boolean useDefaultOnError) {
        return cp.isIndexed() ? this.processIndexedProperty(cp, useDefaultOnError) : this.processSimpleProperty(cp, useDefaultOnError);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean processSimpleProperty(ConfigurationProperty cp, boolean useDefaultOnError) {
        String name = cp.getName();
        String value = this.activeProperties.getProperty(name);
        boolean setToDefault = false;
        if (value != null) {
            Object newValue;
            block6: {
                newValue = cp.convert(value);
                if (newValue == null && !cp.isNullValid()) {
                    if (cp.isSilent()) return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
                    this.log(SeverityLevel.WARN, cp, "Hot_Property_Invalid_Message", null, cp.toString(value));
                    return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
                }
                if (!cp.isInitialized() || !cp.valueEquals(newValue)) break block6;
                return true;
            }
            try {
                if (cp.isInitialized() && !this.isChangeAllowed(cp, newValue)) return true;
                cp.setInitValue(newValue);
                if (!this.isPropertyChangeValid(cp, newValue)) return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
                cp.setNewValue(newValue);
                return true;
            }
            catch (IllegalArgumentException e) {
                if (cp.isSilent()) return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
                this.log(SeverityLevel.WARN, cp, "Hot_Property_Invalid_Message", e.getMessage(), cp.toString(value));
                return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
            }
            catch (NullPointerException e) {
                if (cp.isSilent()) return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
                this.log(SeverityLevel.WARN, cp, "Hot_Property_Invalid_Message", e.getMessage(), cp.toString(value));
                return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
            }
        }
        setToDefault = this.shouldSetToDefault(cp);
        return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
    }

    private final boolean processIndexedProperty(ConfigurationProperty cp, boolean useDefaultOnError) {
        String namePrefix = String.valueOf(cp.getName()) + '.';
        int namePrefixLength = namePrefix.length();
        boolean propertyOK = true;
        boolean propertyValuesFound = false;
        boolean setToDefault = false;
        ArrayList<IndexedValue> indexedValues = new ArrayList<IndexedValue>();
        for (String propName : this.activeProperties.getAllKeys()) {
            int index;
            if (!propName.startsWith(namePrefix)) continue;
            String value = this.activeProperties.getProperty(propName);
            try {
                index = Integer.parseInt(propName.substring(namePrefixLength));
            }
            catch (NumberFormatException numberFormatException) {
                propertyOK = false;
                if (cp.isSilent()) break;
                String msg = this.localizer.IStringLocalizer_getFormattedLocalizedString("Hot_Property_Invalid_Indexed_Property_Name_Message", propName, value);
                this.feedback.log(SeverityLevel.WARN, msg);
                break;
            }
            propertyValuesFound = true;
            try {
                Object newValue = cp.convert(value);
                if (newValue == null && !cp.isNullValid()) {
                    propertyOK = false;
                    if (cp.isSilent()) break;
                    this.log(SeverityLevel.WARN, cp, propName, "Hot_Property_Invalid_Message", null, cp.toString(value));
                    break;
                }
                indexedValues.add(new IndexedValue(index, newValue));
            }
            catch (NumberFormatException e) {
                propertyOK = false;
                if (cp.isSilent()) continue;
                this.log(SeverityLevel.WARN, cp, propName, "Hot_Property_Invalid_Message", e.getMessage(), cp.toString(value));
            }
            catch (IllegalArgumentException e) {
                propertyOK = false;
                if (cp.isSilent()) continue;
                this.log(SeverityLevel.WARN, cp, propName, "Hot_Property_Invalid_Message", e.getMessage(), cp.toString(value));
            }
            catch (NullPointerException e) {
                propertyOK = false;
                if (cp.isSilent()) continue;
                this.log(SeverityLevel.WARN, cp, propName, "Hot_Property_Invalid_Message", e.getMessage(), cp.toString(value));
            }
        }
        if (propertyOK) {
            Collections.sort(indexedValues, INDEXED_VALUE_COMPARATOR);
            ArrayList<Object> newValues = new ArrayList<Object>(indexedValues.size());
            for (IndexedValue v : indexedValues) {
                newValues.add(v.value);
            }
            if ((!cp.isInitialized() || this.isChangeAllowed(cp, newValues)) && this.isPropertyChangeValid(cp, newValues)) {
                cp.setNewValue(newValues);
                return true;
            }
        }
        if (!propertyValuesFound) {
            setToDefault = this.shouldSetToDefault(cp);
        }
        return this.setNewValueToDefault(cp, useDefaultOnError, setToDefault);
    }

    private final boolean shouldSetToDefault(ConfigurationProperty cp) {
        return !cp.isInitialized() || !cp.valueEquals(cp.getDefaultValue()) && this.isChangeAllowed(cp, cp.getDefaultValue());
    }

    private final boolean setNewValueToDefault(ConfigurationProperty cp, boolean useDefaultOnError, boolean setToDefault) {
        Object defaultValue = cp.getDefaultValue();
        if (cp.isInitialized() && cp.valueEquals(defaultValue)) {
            return true;
        }
        if ((!cp.isInitialized() && useDefaultOnError || setToDefault) && this.isPropertyChangeValid(cp, defaultValue)) {
            cp.setNewValueToDefault();
            return true;
        }
        return false;
    }

    private final boolean isPropertyChangeValid(ConfigurationProperty cp, Object newValue) {
        boolean changeValid = false;
        if (this.isChangeAllowed(cp, newValue)) {
            String detail = null;
            try {
                changeValid = cp.validate(newValue);
            }
            catch (IllegalArgumentException e) {
                detail = e.getMessage();
            }
            catch (NullPointerException e) {
                detail = e.getMessage();
            }
            if (!changeValid && !cp.isSilent()) {
                this.log(SeverityLevel.WARN, cp, "Hot_Property_Invalid_Message", detail == null ? "" : detail, cp.toString(newValue));
            }
        }
        return changeValid;
    }

    private final boolean isChangeAllowed(ConfigurationProperty cp, Object newValue) {
        if (!cp.isInitialized()) {
            return true;
        }
        if (this.activeProperties.getPropertySourceType((String)cp.getName()).fixed) {
            if (!cp.isSilent()) {
                this.log(SeverityLevel.WARN, cp, "Hot_Property_Fixed_Change_Attempt_Message", null, cp.toString(newValue));
            }
            return false;
        }
        if (!cp.isHot()) {
            if (!cp.isSilent() && !cp.isInitValue(newValue)) {
                this.log(SeverityLevel.WARN, cp, "Not_Hot_Property_Change_Attempt_Message", null, cp.toString(newValue));
            }
            return false;
        }
        return true;
    }

    private final void processPropertySets(Set<ConfigurationPropertySet> candidatePropertySets, Map<String, ConfigurationProperty> candidateProperties, Map<String, ConfigurationProperty> rejectedProperties) {
        Iterator<ConfigurationPropertySet> i = candidatePropertySets.iterator();
        while (i.hasNext()) {
            ConfigurationPropertySet cps = i.next();
            boolean setOK = true;
            boolean setAffected = false;
            Iterator<ConfigurationProperty> cpi = cps.iterator();
            while (cpi.hasNext() && setOK) {
                ConfigurationProperty cp = cpi.next();
                String propName = cp.getName();
                if (rejectedProperties.containsKey(propName)) {
                    if (!cps.rejectValidPropertyChangesWhenSetRejected()) continue;
                    i.remove();
                    this.rejectSet(cps, SeverityLevel.WARN, "Hot_Property_Prop_Failed_Reject_Others", propName, candidateProperties, rejectedProperties);
                    setOK = false;
                    continue;
                }
                if (!candidateProperties.containsKey(propName)) continue;
                setAffected = true;
            }
            if (!setOK) continue;
            if (setAffected) {
                boolean setValid = false;
                String detail = null;
                try {
                    setValid = cps.validate();
                }
                catch (IllegalArgumentException e) {
                    detail = e.getMessage();
                }
                if (setValid) continue;
                i.remove();
                String msgKey = StringUtils.isEmpty(detail) ? "Hot_Property_Set_Validate_Failed_No_Detail_Message" : "Hot_Property_Set_Validate_Failed_With_Detail_Message";
                this.rejectSet(cps, SeverityLevel.WARN, msgKey, detail, candidateProperties, rejectedProperties);
                continue;
            }
            i.remove();
        }
    }

    private final void rejectSet(ConfigurationPropertySet cps, SeverityLevel severity, String errMsg, String reason, Map<String, ConfigurationProperty> candidateProperties, Map<String, ConfigurationProperty> rejectedProperties) {
        Iterator<ConfigurationProperty> cpi = cps.iterator();
        StringBuilder ignoredNames = new StringBuilder();
        String sep = "";
        int nIgnored = 0;
        while (cpi.hasNext()) {
            ConfigurationProperty cp = cpi.next();
            String name = cp.getName();
            if (candidateProperties.remove(name) != null) {
                ++nIgnored;
                ignoredNames.append(sep);
                sep = ",";
                ignoredNames.append(name);
            }
            rejectedProperties.put(cp.getName(), cp);
        }
        this.log(severity, errMsg, reason, nIgnored == 1 ? "Hot_Property_Singular" : "Hot_Property_Plural", ignoredNames.toString());
    }

    private final void setProperties(Map<String, ConfigurationProperty> candidateProperties) {
        for (ConfigurationProperty cp : candidateProperties.values()) {
            if (cp.isInitialized() && cp.valueEquals(cp.getNewValue())) continue;
            cp.setValueAndLog();
        }
    }

    private final void setPropertiesToDefault(Map<String, ConfigurationProperty> candidateProperties) {
        for (ConfigurationProperty cp : candidateProperties.values()) {
            cp.setNewValueToDefault();
            cp.setValueAndLog();
        }
    }

    private final void setPropertySets(Set<ConfigurationPropertySet> candidatePropertySets) {
        for (ConfigurationPropertySet cps : candidatePropertySets) {
            cps.set();
        }
    }

    private final void log(SeverityLevel level, ConfigurationProperty cp, String messageKey, String reason, String value) {
        String msg = cp.formatLocalizedMessage(messageKey, StringUtils.isEmpty(reason) ? "" : reason, value);
        this.feedback.log(level, msg);
    }

    private final void log(SeverityLevel level, ConfigurationProperty cp, String propName, String messageKey, String reason, String value) {
        String msg = cp.formatLocalizedMessage(propName, messageKey, StringUtils.isEmpty(reason) ? "" : reason, value);
        this.feedback.log(level, msg);
    }

    private final void log(SeverityLevel level, String messageKey, String reason, String propsKey, String propNames) {
        String props = this.localizer.IStringLocalizer_getLocalizedString(propsKey);
        String msg = this.localizer.IStringLocalizer_getFormattedLocalizedString(messageKey, StringUtils.isEmpty(reason) ? "" : reason, props, propNames);
        this.feedback.log(level, msg);
    }

    public String getProperty(String propName) {
        return this.activeProperties.getProperty(propName);
    }

    @Override
    public boolean registerListener(PropertyGroupListner listener) {
        return this.propertyGroupHandler.registerListener(listener);
    }

    @Override
    public boolean removeListener(PropertyGroupListner listener) {
        return this.propertyGroupHandler.removeListener(listener);
    }

    private static class IndexedValue {
        public final int index;
        public final Object value;

        private IndexedValue(int index, Object value) {
            this.index = index;
            this.value = value;
        }
    }
}

