/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.webappsupport;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.util.heartbeat.WaitAndExecuteBehavior;
import java.util.Map;

public abstract class AWebAppSupportReflectionDelegatingService
implements IAgentService {
    private final String fDelegateServiceName;
    private final String fDelegateClassName;
    private final ClassLoader fDelegateClassLoader;
    private final ClassLoader fContextClassLoader;

    protected AWebAppSupportReflectionDelegatingService(String delegateName, String delegateClassName, ClassLoader delegateClassLoader) {
        this(delegateName, delegateClassName, delegateClassLoader, null);
    }

    protected AWebAppSupportReflectionDelegatingService(String delegateName, String delegateClassName, ClassLoader delegateClassLoader, ClassLoader contextClassLoader) {
        this.fDelegateServiceName = delegateName;
        this.fDelegateClassName = delegateClassName;
        this.fDelegateClassLoader = delegateClassLoader;
        this.fContextClassLoader = contextClassLoader;
    }

    private final String getDelegateServiceName() {
        return this.fDelegateServiceName;
    }

    private final String getDelegateServiceClassName() {
        return this.fDelegateClassName;
    }

    private final ClassLoader getDelegateServiceClassLoader() {
        return this.fDelegateClassLoader;
    }

    public final int IAgentService_getServiceVersion() {
        return 2;
    }

    public final void IAgentService_startService(IAgent agent, Map parameters) throws Exception {
        long startDelayInSeconds = agent.IAgent_getIndexedProperties().getLongProperty("introscope.agent.webappsupport.startDelayInSeconds", 5L);
        if (startDelayInSeconds < 5L) {
            startDelayInSeconds = 5L;
        }
        agent.IAgent_getModuleFeedback().info("Will start " + this.getDelegateServiceName() + " WebAppSupport in " + startDelayInSeconds + " seconds");
        if (this.environmentProbeAllowsDelegateLoad(agent)) {
            final IAgent agnt = agent;
            final Map params = parameters;
            new WaitAndExecuteBehavior(agent.IAgent_getCommonHeartbeat(), startDelayInSeconds * 1000L, "Start WebAppSupport " + this.getDelegateServiceName()){

                protected boolean execute() {
                    try {
                        if (AWebAppSupportReflectionDelegatingService.this.fContextClassLoader != null) {
                            Thread.currentThread().setContextClassLoader(AWebAppSupportReflectionDelegatingService.this.fContextClassLoader);
                        }
                        agnt.IAgent_getModuleFeedback().info("Starting " + AWebAppSupportReflectionDelegatingService.this.getDelegateServiceName() + " WebAppSupport with parameters: " + params);
                        agnt.IAgent_getServiceAdministrator().registerServiceSync(agnt, AWebAppSupportReflectionDelegatingService.this.getDelegateServiceName(), AWebAppSupportReflectionDelegatingService.this.getDelegateServiceClassName(), AWebAppSupportReflectionDelegatingService.this.getDelegateServiceClassLoader(), params);
                        Thread.currentThread().setContextClassLoader(null);
                    }
                    catch (Throwable t) {
                        AWebAppSupportReflectionDelegatingService.this.handleInvocationException(agnt, t);
                    }
                    return true;
                }
            };
        }
    }

    private final boolean environmentProbeAllowsDelegateLoad(IAgent agent) {
        return this.doShouldAttemptDelegateLoad(agent);
    }

    private final void handleInvocationException(IAgent agent, Throwable t) {
        this.doHandleDelegateLoadException(agent, t);
    }

    protected abstract boolean doShouldAttemptDelegateLoad(IAgent var1);

    protected abstract void doHandleDelegateLoadException(IAgent var1, Throwable var2);
}

