/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.wldf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IStringEveryEventDataAccumulator;
import com.wily.introscope.agent.wldf.AWLDFDataView;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class StringWLDFDataView
extends AWLDFDataView {
    private IStringEveryEventDataAccumulator fAccumulator;
    private String fullMetricName;

    public StringWLDFDataView(IAgent agent, ObjectName on, MBeanServer server, String attributeName, String fullIntroscopeMetricName) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        super(agent, on, server, attributeName);
        this.fAccumulator = this.getAgent().IAgent_getDataAccumulatorFactory().createStringEveryEventDataAccumulator(fullIntroscopeMetricName);
        this.fullMetricName = fullIntroscopeMetricName;
    }

    @Override
    protected void doUpdate(Object currentValue) {
        StringBuilder buf = new StringBuilder();
        if (currentValue instanceof Object[]) {
            Object[] array = (Object[])currentValue;
            buf.append('{');
            if (array.length != 0) {
                buf.append(array[0].toString());
            }
            for (int i = 1; i < array.length; ++i) {
                buf.append(", ");
                buf.append(array[i].toString());
                if (buf.length() > 21845) break;
            }
            buf.append('}');
        } else {
            buf.append(currentValue.toString());
        }
        this.fAccumulator.IStringEveryEventDataAccumulator_addString(buf.toString());
    }

    @Override
    protected IDataAccumulator getAccumulator() {
        return this.fAccumulator;
    }

    @Override
    protected void doDestroy() {
        try {
            if (this.fAccumulator != null) {
                this.getAgent().IAgent_getDataAccumulatorFactory().removeDataAccumulator((IDataAccumulator)this.fAccumulator);
            }
        }
        finally {
            this.fAccumulator = null;
        }
    }

    @Override
    public String getFullMetricName() {
        return this.fullMetricName;
    }
}

