/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties;

import com.wily.util.Base64;
import com.wily.util.obfuscation.SimpleDecryptor;
import com.wily.util.obfuscation.SimpleEncryptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;

public class PropertiesUtils {
    public static final boolean kIgnoreComments = true;
    public static final boolean kIncludeComments = false;
    private static final String DECRYPTION_PREFIX = "ENC(";
    public static final String[] kNoStringArrayProperties = new String[0];
    public static final String kDefaultDelimiter = ",";
    private static final int kSharedSecret = 4122013;
    private static final String kSharedPrefix = "Wp:";
    private static final int kSeed = 1074047;

    private PropertiesUtils() {
    }

    public static void renumberIndexedPropertiesInFile(File inFile, File outFile, boolean ignoreComments) throws IOException {
        String line;
        FileInputStream inStream = new FileInputStream(inFile);
        LineNumberReader in = new LineNumberReader(new InputStreamReader(inStream));
        FileOutputStream outStream = new FileOutputStream(outFile);
        PrintStream out = new PrintStream(outStream);
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        while ((line = in.readLine()) != null) {
            if (!ignoreComments || line.charAt(0) != '#') {
                int equalsIndex = line.indexOf(61);
                if (equalsIndex != -1) {
                    String key = line.substring(0, equalsIndex);
                    int lastDotIndex = key.lastIndexOf(46);
                    if (lastDotIndex != -1) {
                        String lastSegment = key.substring(lastDotIndex + 1);
                        try {
                            Integer.parseInt(lastSegment);
                            String linePrefix = key.substring(0, lastDotIndex);
                            String lineSuffix = line.substring(equalsIndex);
                            String keyPrefix = linePrefix.substring(linePrefix.lastIndexOf(35) + 1);
                            Integer lastIndex = (Integer)keyMap.remove(keyPrefix);
                            int nextIndex = 0;
                            if (lastIndex != null) {
                                nextIndex = lastIndex + 1;
                            }
                            keyMap.put(keyPrefix, nextIndex);
                            out.println(String.valueOf(linePrefix) + "." + nextIndex + lineSuffix);
                        }
                        catch (NumberFormatException numberFormatException) {
                            out.println(line);
                        }
                        continue;
                    }
                    out.println(line);
                    continue;
                }
                out.println(line);
                continue;
            }
            out.println(line);
        }
        inStream.close();
        outStream.close();
    }

    public static String getProperty(Map properties, String propertyKey) {
        return (String)properties.get(propertyKey);
    }

    public static String getProperty(Map properties, String propertyKey, String defaultValue) {
        String value = PropertiesUtils.getProperty(properties, propertyKey);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static String[] getStringArray(String propertyValue, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(propertyValue, delimiter);
        ArrayList<String> elements = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            String element = (String)tokenizer.nextElement();
            elements.add(element.trim());
        }
        return elements.toArray(kNoStringArrayProperties);
    }

    public static HashSet getStringHashSet(String propertyValue, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(propertyValue, delimiter);
        HashSet<String> elements = new HashSet<String>(0);
        while (tokenizer.hasMoreElements()) {
            String element = (String)tokenizer.nextElement();
            elements.add(element.trim());
        }
        return elements;
    }

    public static void checkEntryTypes(Map properties) throws Exception {
        for (Map.Entry entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw new Exception("Entry key is not a string: " + entry.getKey());
            }
            if (entry.getValue() instanceof String) continue;
            throw new Exception("Entry value is not a string: " + entry.getValue());
        }
    }

    private static byte simpleOneByteChecksum(String clear) {
        byte ck = 0;
        if (clear == null) {
            return 0;
        }
        byte[] bytes = clear.getBytes();
        int i = 0;
        while (i < bytes.length) {
            byte cfr_ignored_0 = bytes[i];
            byte t = (byte)(ck ^ bytes[i]);
            ck = (byte)(t << 1);
            ++i;
        }
        return ck;
    }

    public static String encryptPassword(String clear) {
        return PropertiesUtils.encryptPassword(clear, 1074047);
    }

    public static String encryptPasswordWithPrefix(String clear) {
        if (clear != null && clear.startsWith(DECRYPTION_PREFIX)) {
            return clear;
        }
        return DECRYPTION_PREFIX + PropertiesUtils.encryptPassword(clear, 1074047);
    }

    public static String decryptPasswordWithPrefix(String value) {
        if (value != null && value.startsWith(DECRYPTION_PREFIX)) {
            return PropertiesUtils.decryptPassword(value.substring(4), 1074047);
        }
        return value;
    }

    public static String decryptPassword(String value) {
        return PropertiesUtils.decryptPassword(value, 1074047);
    }

    public static String encryptPassword(String clear, int seed) {
        StringBuilder b = new StringBuilder(kSharedPrefix);
        b.append(clear);
        byte checksum = PropertiesUtils.simpleOneByteChecksum(b.toString());
        byte[] buf = new byte[b.length() + 1];
        buf[0] = checksum;
        System.arraycopy(b.toString().getBytes(), 0, buf, 1, b.length());
        SimpleEncryptor encryptor = new SimpleEncryptor(0x3EE59D | seed);
        encryptor.transformInPlace(buf);
        String result = Base64.encodeBytes(buf);
        return result;
    }

    public static String decryptPassword(String value, int seed) {
        SimpleDecryptor decryptor = new SimpleDecryptor(0x3EE59D | seed);
        if (value == null || value.length() < 4) {
            return value;
        }
        try {
            byte[] buf = Base64.decode(value);
            decryptor.transformInPlace(buf);
            byte checksum = buf[0];
            String clear = new String(buf, 1, buf.length - 1);
            if (clear.startsWith(kSharedPrefix) && checksum == PropertiesUtils.simpleOneByteChecksum(clear)) {
                return clear.substring(kSharedPrefix.length());
            }
        }
        catch (Exception exception) {}
        return value;
    }

    public static String generatePassword(int len) {
        Random r = new Random(System.currentTimeMillis());
        StringBuilder rStr = new StringBuilder();
        int i = 0;
        while (i < len) {
            char c = (char)(r.nextInt(74) + 48);
            if (!Character.isLetterOrDigit(c)) continue;
            rStr.append(c);
            ++i;
        }
        return rStr.toString();
    }

    public static void printUsage() {
        System.out.println("Usage: PropertiesUtil encrypt <password>");
        System.out.println("           (to encrypt a password for agent profile entry)");
        System.out.println("   or  PropertiesUtil genpwd <length>");
        System.out.println("           (to generate a random password)");
        System.out.println("   or  PropertiesUtil apmiaencrypt <password>");
        System.out.println("           (to encrypt a password for apmia agent profile entry with prefix)");
        System.out.println("Note:: By default newline characters in the passwords are trimmed during processing. \n     This works well for all known scenarios. To skip truncating the newline characters \n     use  \"--skipCRLFTruncate\" e.g. \"PropertiesUtil apmiaencrypt <password> --skipCRLFTruncate\".");
    }

    public static void main(String[] args) {
        if (args.length >= 2) {
            if (args[0].equals("genpwd")) {
                try {
                    int len = Integer.parseInt(args[1]);
                    if (len < 1 || len > 512) {
                        System.out.println("Error: Invalid password length. It must an integer between 1 and 512");
                        return;
                    }
                    System.out.println(PropertiesUtils.generatePassword(len));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Error: Invalid password length. It must an integer between 1 and 512");
                }
            } else if (args[0].equals("encrypt")) {
                if (args.length == 3 && args[2].equalsIgnoreCase("--skipCRLFTruncate")) {
                    System.out.println(PropertiesUtils.encryptPassword(args[1]));
                } else {
                    System.out.println(PropertiesUtils.encryptPassword(PropertiesUtils.handleNewlineChar(args[1])));
                }
            } else if (args[0].equals("apmiaencrypt")) {
                if (args.length == 3 && args[2].equalsIgnoreCase("--skipCRLFTruncate")) {
                    System.out.println(PropertiesUtils.encryptPasswordWithPrefix(args[1]));
                } else {
                    System.out.println(PropertiesUtils.encryptPasswordWithPrefix(PropertiesUtils.handleNewlineChar(args[1])));
                }
            } else {
                PropertiesUtils.printUsage();
            }
        } else {
            PropertiesUtils.printUsage();
        }
    }

    public static String handleNewlineChar(String original) {
        String doubleSlashNRegex = "\\\\\\\\n";
        String slashNRegex = "\\\\n";
        String newLineChar = "\n";
        return original.replaceAll(doubleSlashNRegex, newLineChar).replaceAll(slashNRegex, newLineChar);
    }
}

