/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.external.biz.util;

import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class HeaderExtractor {
    public static Map<String, String> extractHeaderFields(String header) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        String identifyingHeader = null;
        if (header != null) {
            int index = header.indexOf("$");
            if (index > 0) {
                identifyingHeader = header.substring(index + 1);
                valueMap.put("bt-name", identifyingHeader);
                header = header.substring(0, index) + ";" + identifyingHeader;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(header, ";");
            while (stringTokenizer.hasMoreElements()) {
                String parameters = (String)stringTokenizer.nextElement();
                int positionEqual = parameters.indexOf("=");
                if (positionEqual <= 0) continue;
                valueMap.put(parameters.substring(0, positionEqual), parameters.substring(positionEqual + 1));
            }
        }
        return valueMap;
    }

    public static Map<String, String> extractCookieFields(String cookieValue) {
        if (cookieValue == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(cookieValue, "&");
        HashMap<String, String> valueMap = new HashMap<String, String>();
        while (stringTokenizer.hasMoreElements()) {
            String parameters = (String)stringTokenizer.nextElement();
            int positionEqual = parameters.indexOf("=");
            if (positionEqual <= 0) continue;
            valueMap.put(parameters.substring(0, positionEqual), parameters.substring(positionEqual + 1));
        }
        return valueMap;
    }

    public static Map<String, String> extractCookieFields(Map<String, String> cookieMap) {
        String browserVersion;
        HashMap<String, String> result = new HashMap<String, String>(2);
        String browserType = cookieMap.get("x-apm-brtm-bt-p");
        if (!(browserType != null && browserType.trim().equals("-1") || browserType == null)) {
            result.put("x-apm-brtm-bt-p", browserType);
        }
        if ((browserVersion = cookieMap.get("x-apm-brtm-bt-pv")) == null || !browserVersion.trim().equals("-1")) {
            result.put("x-apm-brtm-bt-pv", browserVersion);
        }
        String url = cookieMap.get("url");
        if (url != null) {
            BTThreadLocalAdministrator.getInstance().insert("url", (Object)url.trim());
        } else {
            BTThreadLocalAdministrator.getInstance().insert("url", (Object)"\\");
        }
        return result;
    }
}

