/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.api;

import com.ca.apm.agent.jmxclient.Utils;
import com.ca.apm.agent.jmxclient.api.TaskExecutor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TaskTimeoutThreadPool
extends ThreadPoolExecutor {
    private final long timeout;
    private final TimeUnit unit;
    private final TaskExecutor timeoutExecutor;
    private final Map<Runnable, ScheduledFuture<?>> tasks = new ConcurrentHashMap();

    public TaskTimeoutThreadPool(TaskExecutor scheduledExecutor) {
        this(5L, TimeUnit.SECONDS, scheduledExecutor);
    }

    public TaskTimeoutThreadPool(long timeout, TimeUnit unit, TaskExecutor scheduledExecutor) {
        super(0, Integer.MAX_VALUE, 300L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Utils.createNewThreadFactoryInstance("worker thread"));
        this.timeout = timeout;
        this.unit = unit;
        this.timeoutExecutor = scheduledExecutor;
    }

    @Override
    public void shutdown() {
        this.tasks.clear();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.tasks.clear();
        return super.shutdownNow();
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        ScheduledFuture<?> future = this.timeoutExecutor.schedule(new TimeoutTask(t), this.timeout, this.unit);
        this.tasks.put(r, future);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        ScheduledFuture<?> future = this.tasks.remove(r);
        if (future != null) {
            future.cancel(false);
        }
    }

    static class TimeoutTask
    implements Runnable {
        Thread trackedThread;

        TimeoutTask(Thread trackedThread) {
            this.trackedThread = trackedThread;
        }

        @Override
        public void run() {
            if (!this.trackedThread.isInterrupted()) {
                this.trackedThread.interrupt();
            }
        }
    }
}

