/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.correlation.WSCorrelationTracer;
import com.wily.util.properties.AttributeListing;

public class Axis2ServerHTTPCorrelationTracer
extends WSCorrelationTracer {
    public Axis2ServerHTTPCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
    }

    @Override
    public void ITracer_startTrace(int index, InvocationData data) {
        boolean isHTTPReadEnabled = WSMUtils.correlationHTTPReadEnabled();
        try {
            Object context = data.getInvocationParameterAsObject(0);
            this.getCorrelationInfoFromHttpHeaders(context, isHTTPReadEnabled);
        }
        catch (Throwable t) {
            WSMUtils.handleException(this.getAgent(), "Axis2ServerHTTPCorrelationTracer ITracer_startTrace exception ", t);
        }
    }

    protected void getCorrelationInfoFromHttpHeaders(Object context, boolean isHTTPReadEnabled) throws Exception {
        if (isHTTPReadEnabled) {
            Object header;
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Axis2ServerHTTPCorrelationTracer getCorrelationInfoFromHttpHeaders data.getInvocationObject() " + context.getClass());
            }
            if ((header = WSMUtils.invokeMethodOnObject(context, "getHeader", new Class[]{String.class}, new Object[]{"CorID"})) == null || header.equals("")) {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("Axis2ServerHTTPCorrelationTracer ITracer_startTrace no header");
                }
                if (!WSMUtils.correlationSOAPReadEnabled()) {
                    CorrelationId correlationId = new CorrelationId();
                }
            } else {
                CorrelationId correlationIdTmp = new CorrelationId(header.toString());
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("Axis2ServerHTTPCorrelationTracer ITracer_startTrace header=" + header.toString());
                }
            }
        }
    }
}

