/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.scoring;

import com.wily.introscope.probebuilder.intelligent.instrumentation.MethodScoringConfigManager;
import com.wily.introscope.probebuilder.intelligent.instrumentation.parser.Token;
import com.wily.introscope.probebuilder.scoring.MethodScoreCalculator;
import java.util.StringTokenizer;

public class MethodScorer {
    private MethodScoreCalculator calculator = new MethodScoreCalculator();
    private int methodFactor = 1;

    public void add(Token token) {
        int value = this.getTokenScore(token) * this.methodFactor;
        this.calculator.increment(value);
    }

    private int getTokenScore(Token token) {
        int scoreValue = 0;
        int kind = token.kind;
        switch (kind) {
            case 16: 
            case 17: {
                int factor = MethodScoringConfigManager.getFactor(kind);
                scoreValue = factor * Integer.parseInt(token.image);
                break;
            }
            case 7: 
            case 15: {
                scoreValue = MethodScoringConfigManager.getScore(kind);
                break;
            }
            default: {
                scoreValue = MethodScoringConfigManager.getScore(kind);
            }
        }
        return scoreValue;
    }

    public void handleFwdIf(Token token) {
        String image = token.image;
        StringTokenizer tokenizer = new StringTokenizer(image, "$");
        int lineNumber = Integer.parseInt(tokenizer.nextToken());
        int jumpTarget = Integer.parseInt(tokenizer.nextToken());
        this.calculator.handleIfBlockStart(lineNumber, jumpTarget);
    }

    public void handleBwdIf(Token token) {
        String image = token.image;
        StringTokenizer tokenizer = new StringTokenizer(image, "$");
        int lineNumber = Integer.parseInt(tokenizer.nextToken());
        int jumpTarget = Integer.parseInt(tokenizer.nextToken());
        this.calculator.handleBckJumpIf(lineNumber, jumpTarget, MethodScoringConfigManager.getFactor(token.kind));
    }

    public void handleFwdGoto(Token token) {
        String image = token.image;
        StringTokenizer tokenizer = new StringTokenizer(image, "$");
        int lineNumber = Integer.parseInt(tokenizer.nextToken());
        int jumpTarget = Integer.parseInt(tokenizer.nextToken());
        this.calculator.handleGotoBlockStart(lineNumber, jumpTarget);
    }

    public void handleBwdGoto(Token token) {
        String image = token.image;
        StringTokenizer tokenizer = new StringTokenizer(image, "$");
        int lineNumber = Integer.parseInt(tokenizer.nextToken());
        int jumpTarget = Integer.parseInt(tokenizer.nextToken());
        this.calculator.handleBckGoto(lineNumber, jumpTarget, MethodScoringConfigManager.getFactor(token.kind));
    }

    public int getCurrentScore() {
        return this.calculator.getCurrentSum();
    }

    public void captureMethodFactor(Token token) {
        this.methodFactor *= MethodScoringConfigManager.getFactor(token.kind);
    }

    public void handleSynBlockStart(Token token) {
        this.calculator.handleSynStart();
    }

    public void handleSynBlockEnd(Token token) {
        this.calculator.handleSyncEnd(MethodScoringConfigManager.getFactor(token.kind));
    }
}

