/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.launch.core;

import com.wily.introscope.agent.launch.core.BootstrapAgentLogger;
import com.wily.introscope.agent.launch.core.IAgentParamValidator;
import com.wily.introscope.agent.launch.core.Logger;
import com.wily.introscope.agent.launch.util.BootstrapAgentConstants;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AgentArgsValidator
implements BootstrapAgentConstants {
    private static final Logger LOGGER = BootstrapAgentLogger.getLogger();
    private static Map<String, IAgentParamValidator> validatorsRegistry = new HashMap<String, IAgentParamValidator>();

    public static void validateArgs(Map<String, String> params) {
        Collection<IAgentParamValidator> values = validatorsRegistry.values();
        if (values != null) {
            for (IAgentParamValidator validator : values) {
                validator.validate(params);
            }
        }
    }

    public static void registerValidationHandler(IAgentParamValidator validationHandler) {
        validatorsRegistry.put(validationHandler.getKey(), validationHandler);
    }

    public static IAgentParamValidator getValidationHandler(String key) {
        return validatorsRegistry.get(key);
    }

    public static void performValidationForkey(String key, Map<String, String> params) {
        IAgentParamValidator validator = validatorsRegistry.get(key);
        if (validator == null) {
            LOGGER.info("No validation handler registered for the key " + key);
            return;
        }
        validator.validate(params);
    }
}

