/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentStripLockByKey {
    private final ReentrantLock lockInternal = new ReentrantLock();
    private final ConcurrentHashMap<String, ConcurrentStripLock> lockCache = new ConcurrentHashMap();

    public Lock lock(String key) {
        ConcurrentStripLock keyLock;
        this.lockInternal.lock();
        try {
            if (!this.lockCache.containsKey(key)) {
                keyLock = new ConcurrentStripLock();
                ConcurrentStripLock prevRetryLock = this.lockCache.putIfAbsent(key, keyLock);
                if (prevRetryLock != null) {
                    keyLock = prevRetryLock;
                }
            } else {
                keyLock = this.lockCache.get(key);
            }
            keyLock.counter.incrementAndGet();
        }
        finally {
            this.lockInternal.unlock();
        }
        keyLock.lock.lock();
        return keyLock.lock;
    }

    public void unlock(String key, Lock lock) {
        ConcurrentStripLock keyLock = null;
        this.lockInternal.lock();
        try {
            if (this.lockCache.containsKey(key)) {
                keyLock = this.lockCache.get(key);
                if (lock != keyLock.lock) {
                    throw new IllegalArgumentException();
                }
                keyLock.counter.decrementAndGet();
                keyLock.lock.unlock();
                if (keyLock.counter.get() == 0) {
                    this.lockCache.remove(key);
                }
            }
        }
        finally {
            this.lockInternal.unlock();
        }
    }

    public int size() {
        this.lockInternal.lock();
        try {
            int n = this.lockCache.size();
            return n;
        }
        finally {
            this.lockInternal.unlock();
        }
    }

    private static class ConcurrentStripLock {
        public final ReentrantLock lock = new ReentrantLock();
        private final AtomicInteger counter = new AtomicInteger(0);

        private ConcurrentStripLock() {
        }
    }
}

