/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.classfile.java;

import com.wily.util.StringUtils;
import com.wily.util.classfile.ISlotSignature;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.InvalidFieldDescriptorException;
import com.wily.util.classfile.java.ClassFileValidationUtilities;
import com.wily.util.text.FormattedLocalizableMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ClassFileFieldDescriptor
implements ISlotSignature {
    public static final int kMaximumAllowableJavaArrayDimensionality = 255;
    public static final String kByteType = "B";
    public static final String kCharType = "C";
    public static final String kDoubleType = "D";
    public static final String kFloatType = "F";
    public static final String kIntegerType = "I";
    public static final String kLongType = "J";
    public static final String kShortType = "S";
    public static final String kBooleanType = "Z";
    public static final String kReferenceType = "L";
    public static final String kReferenceTypeSuffix = ";";
    public static final String kArrayType = "[";
    public static final String kStringParameterType = "Ljava/lang/String;";
    public static final String kObjectParameterType = "Ljava/lang/Object;";
    public static final String kVoidType = "V";
    public static final String kEndParameterListType = ")";
    private static final String kInternalTypeList = "BCDFIJLSZ[)";
    private static final String kReturnTypeList = "BCDFIJLSZ[V";
    private static final int kByteTypeCode = 10;
    private static final int kCharTypeCode = 11;
    private static final int kDoubleTypeCode = 12;
    private static final int kFloatTypeCode = 13;
    private static final int kIntegerTypeCode = 14;
    private static final int kLongTypeCode = 15;
    private static final int kReferenceTypeCode = 16;
    private static final int kReferenceTypeSuffixCode = 17;
    private static final int kShortTypeCode = 18;
    private static final int kBooleanTypeCode = 19;
    private static final int kArrayTypeCode = 20;
    private static final int kVoidTypeCode = 21;
    private static final int kEndParameterListTypeCode = 22;
    private static final String kByteTypeString = "byte";
    private static final String kCharTypeString = "char";
    private static final String kDoubleTypeString = "double";
    private static final String kFloatTypeString = "float";
    private static final String kIntegerTypeString = "int";
    private static final String kLongTypeString = "long";
    private static final String kReferenceTypeString = "java.lang.Object";
    private static final String kShortTypeString = "short";
    private static final String kBooleanTypeString = "boolean";
    private static final String kArrayTypeString = "[]";
    private static final String kVoidTypeString = "void";
    private static Map<String, Integer> fLookupTypeCodeTable;
    private static Map<String, String> fLookupTypeStringTable;
    private boolean fIsValid;
    private boolean fIsObject;
    private String fFieldDescriptor;

    static {
        ClassFileFieldDescriptor.buildTypeCodeTable();
        ClassFileFieldDescriptor.buildTypeStringTable();
    }

    private static void buildTypeCodeTable() {
        fLookupTypeCodeTable = new HashMap<String, Integer>();
        fLookupTypeCodeTable.put(kByteType, 10);
        fLookupTypeCodeTable.put(kCharType, 11);
        fLookupTypeCodeTable.put(kDoubleType, 12);
        fLookupTypeCodeTable.put(kFloatType, 13);
        fLookupTypeCodeTable.put(kIntegerType, 14);
        fLookupTypeCodeTable.put(kLongType, 15);
        fLookupTypeCodeTable.put(kReferenceType, 16);
        fLookupTypeCodeTable.put(kReferenceTypeSuffix, 17);
        fLookupTypeCodeTable.put(kShortType, 18);
        fLookupTypeCodeTable.put(kBooleanType, 19);
        fLookupTypeCodeTable.put(kArrayType, 20);
        fLookupTypeCodeTable.put(kVoidType, 21);
        fLookupTypeCodeTable.put(kEndParameterListType, 22);
    }

    private static void buildTypeStringTable() {
        fLookupTypeStringTable = new HashMap<String, String>();
        fLookupTypeStringTable.put(kByteType, kByteTypeString);
        fLookupTypeStringTable.put(kCharType, kCharTypeString);
        fLookupTypeStringTable.put(kDoubleType, kDoubleTypeString);
        fLookupTypeStringTable.put(kFloatType, kFloatTypeString);
        fLookupTypeStringTable.put(kIntegerType, kIntegerTypeString);
        fLookupTypeStringTable.put(kLongType, kLongTypeString);
        fLookupTypeStringTable.put(kReferenceType, kReferenceTypeString);
        fLookupTypeStringTable.put(kShortType, kShortTypeString);
        fLookupTypeStringTable.put(kBooleanType, kBooleanTypeString);
        fLookupTypeStringTable.put(kArrayType, kArrayTypeString);
        fLookupTypeStringTable.put(kVoidType, kVoidTypeString);
    }

    private static int lookupCode(String value) {
        Integer result = fLookupTypeCodeTable.get(value);
        if (result != null) {
            return result;
        }
        return -1;
    }

    private static String lookupString(String value) {
        return fLookupTypeStringTable.get(value);
    }

    public static ClassFileFieldDescriptor getVoidDescriptor() {
        return new ClassFileFieldDescriptor(kVoidType);
    }

    public static ClassFileFieldDescriptor getFieldDescriptor(String descriptor) throws InvalidFieldDescriptorException {
        StringTokenizer tokenizer = new StringTokenizer(descriptor, "", true);
        ClassFileFieldDescriptor desc = new ClassFileFieldDescriptor(tokenizer);
        if (!desc.isValid()) {
            throw new InvalidFieldDescriptorException(new FormattedLocalizableMessage("Class_File_Field_Descriptor_Invalid_Character", descriptor, kEndParameterListType), descriptor);
        }
        return desc;
    }

    public boolean isValid() {
        return this.fIsValid;
    }

    protected ClassFileFieldDescriptor(String fieldDescriptor) {
        this.fFieldDescriptor = fieldDescriptor == null ? null : fieldDescriptor.intern();
        this.fIsObject = this.calculateIsObject();
        this.fIsValid = true;
    }

    protected ClassFileFieldDescriptor() {
        this.fIsValid = true;
    }

    ClassFileFieldDescriptor(StringTokenizer tokenizer) throws InvalidFieldDescriptorException {
        this(tokenizer, false);
    }

    ClassFileFieldDescriptor(StringTokenizer tokenizer, boolean isReturnValue) throws InvalidFieldDescriptorException {
        this(tokenizer, isReturnValue, true);
    }

    ClassFileFieldDescriptor(StringTokenizer tokenizer, boolean isReturnValue, boolean doValidate) throws InvalidFieldDescriptorException {
        this.fIsValid = this.loadFromTokenizer(tokenizer, isReturnValue, doValidate);
    }

    @Override
    public boolean looselyMatches(ISlotSignature candidate) {
        ClassFileFieldDescriptor other = (ClassFileFieldDescriptor)candidate;
        return this.fFieldDescriptor == null ? other.fFieldDescriptor == null : this.fFieldDescriptor.equals(other.fFieldDescriptor);
    }

    @Override
    public boolean isExactlyObject() {
        return this.fFieldDescriptor.equals(kObjectParameterType);
    }

    protected boolean loadFromTokenizer(StringTokenizer tokenizer, boolean isReturnValue) throws InvalidFieldDescriptorException {
        return this.loadFromTokenizer(tokenizer, isReturnValue, true);
    }

    protected boolean loadFromTokenizer(StringTokenizer tokenizer, boolean isReturnValue, boolean doValidate) throws InvalidFieldDescriptorException {
        this.fFieldDescriptor = !isReturnValue ? this.parseSingleElement(tokenizer, "", kInternalTypeList, false) : this.parseSingleElement(tokenizer, "", kReturnTypeList, true);
        this.fIsObject = false;
        if (this.fFieldDescriptor != null) {
            this.fFieldDescriptor = this.fFieldDescriptor.intern();
            this.fIsObject = this.calculateIsObject();
        }
        if (this.fFieldDescriptor == null) {
            return false;
        }
        if (doValidate) {
            this.validateFieldDescriptor();
        }
        return true;
    }

    private void validateFieldDescriptor() throws InvalidFieldDescriptorException {
        if (this.isArrayReference()) {
            int lastBracket = this.fFieldDescriptor.lastIndexOf(kArrayType);
            String allBrackets = this.fFieldDescriptor.substring(0, lastBracket + 1);
            String dimensionType = this.fFieldDescriptor.substring(lastBracket + 1);
            if (allBrackets.length() > 255) {
                throw new InvalidFieldDescriptorException(new FormattedLocalizableMessage("Class_File_Field_Descriptor_Maximum_Array_Dimensions_Exceeded", this.fFieldDescriptor, String.valueOf(255), String.valueOf(allBrackets.length())), this.fFieldDescriptor);
            }
            if (dimensionType.startsWith(kReferenceType)) {
                this.validateReferenceDescriptor(dimensionType);
            }
        } else if (this.isNonArrayReference()) {
            this.validateReferenceDescriptor(this.fFieldDescriptor);
        }
    }

    private void validateReferenceDescriptor(String descriptor) throws InvalidFieldDescriptorException {
        if (!descriptor.startsWith(kReferenceType)) {
            throw new InvalidFieldDescriptorException(new FormattedLocalizableMessage("Class_File_Field_Descriptor_Invalid_Reference_Type_Prefix", this.fFieldDescriptor, kReferenceType), this.fFieldDescriptor);
        }
        if (!descriptor.endsWith(kReferenceTypeSuffix)) {
            throw new InvalidFieldDescriptorException(new FormattedLocalizableMessage("Class_File_Field_Descriptor_Invalid_Reference_Type_Suffix", this.fFieldDescriptor, kReferenceTypeSuffix), this.fFieldDescriptor);
        }
        try {
            String classReference = descriptor.substring(1, descriptor.length() - 1);
            ClassFileValidationUtilities.validateFullyQualifiedSlashSeparatedClassName(classReference);
        }
        catch (InvalidClassNameException icne) {
            throw new InvalidFieldDescriptorException(icne.ILocalizableException_getLocalizableMessage(), this.fFieldDescriptor);
        }
    }

    private String parseSingleElement(StringTokenizer tokenizer, String prefix, String delimiters, boolean isReturnValue) throws InvalidFieldDescriptorException {
        if (!tokenizer.hasMoreTokens()) {
            if (!prefix.isEmpty()) {
                throw new InvalidFieldDescriptorException(new FormattedLocalizableMessage("Class_File_Field_Descriptor_Incomplete", prefix), prefix);
            }
            return null;
        }
        String token = tokenizer.nextToken(delimiters);
        int value = ClassFileFieldDescriptor.lookupCode(token);
        if (!isReturnValue && value == 22) {
            if (!prefix.isEmpty()) {
                throw new InvalidFieldDescriptorException(new FormattedLocalizableMessage("Class_File_Field_Descriptor_Incomplete", prefix), prefix);
            }
            return null;
        }
        switch (value) {
            case 10: {
                return String.valueOf(prefix) + kByteType;
            }
            case 11: {
                return String.valueOf(prefix) + kCharType;
            }
            case 12: {
                return String.valueOf(prefix) + kDoubleType;
            }
            case 13: {
                return String.valueOf(prefix) + kFloatType;
            }
            case 14: {
                return String.valueOf(prefix) + kIntegerType;
            }
            case 15: {
                return String.valueOf(prefix) + kLongType;
            }
            case 16: {
                String classname = null;
                if (tokenizer.hasMoreTokens()) {
                    classname = tokenizer.nextToken(kReferenceTypeSuffix);
                }
                if (classname == null || classname.isEmpty() || classname.equals(kReferenceTypeSuffix)) {
                    String descriptor = String.valueOf(prefix) + token + (classname == null ? "" : classname);
                    throw new InvalidFieldDescriptorException(new FormattedLocalizableMessage("Class_File_Field_Descriptor_Missing_Reference_Type_Class_Name", descriptor), descriptor);
                }
                if (!tokenizer.hasMoreTokens()) {
                    String descriptor = String.valueOf(prefix) + token + classname;
                    throw new InvalidFieldDescriptorException(new FormattedLocalizableMessage("Class_File_Field_Descriptor_Invalid_Reference_Type_Suffix", descriptor, kReferenceTypeSuffix), descriptor);
                }
                String suffix = tokenizer.nextToken(kReferenceTypeSuffix);
                if (ClassFileFieldDescriptor.lookupCode(suffix) != 17) {
                    String descriptor = String.valueOf(prefix) + token + classname + suffix;
                    throw new InvalidFieldDescriptorException(new FormattedLocalizableMessage("Class_File_Field_Descriptor_Invalid_Reference_Type_Suffix", descriptor, kReferenceTypeSuffix), descriptor);
                }
                return String.valueOf(prefix) + kReferenceType + classname + kReferenceTypeSuffix;
            }
            case 18: {
                return String.valueOf(prefix) + kShortType;
            }
            case 19: {
                return String.valueOf(prefix) + kBooleanType;
            }
            case 20: {
                return this.parseSingleElement(tokenizer, String.valueOf(prefix) + kArrayType, delimiters, isReturnValue);
            }
            case 21: {
                if (!isReturnValue) {
                    throw new InvalidFieldDescriptorException(new FormattedLocalizableMessage("Class_File_Field_Descriptor_Invalid_Void_Parameter", String.valueOf(prefix) + token), String.valueOf(prefix) + token);
                }
                if (!prefix.isEmpty()) {
                    throw new InvalidFieldDescriptorException(new FormattedLocalizableMessage("Class_File_Field_Descriptor_Invalid_Void_Array", String.valueOf(prefix) + token), String.valueOf(prefix) + token);
                }
                return kVoidType;
            }
        }
        throw new InvalidFieldDescriptorException(new FormattedLocalizableMessage("Class_File_Field_Descriptor_Invalid_Character", String.valueOf(prefix) + token, token), String.valueOf(prefix) + token);
    }

    public String toString() {
        return this.fFieldDescriptor;
    }

    private String formatReferenceDescriptor(String descriptor) {
        String desc = descriptor.substring(1, descriptor.length() - 1);
        String formatted = StringUtils.replace(desc, "/", ".");
        return formatted;
    }

    @Override
    public String getSignatureString() {
        StringBuilder formatted = new StringBuilder(this.fFieldDescriptor.length() * 3);
        if (this.isArrayReference()) {
            int lastBracket = this.fFieldDescriptor.lastIndexOf(kArrayType);
            String allBrackets = this.fFieldDescriptor.substring(0, lastBracket + 1);
            String dimensionType = this.fFieldDescriptor.substring(lastBracket + 1);
            String dimensionTypeString = dimensionType.startsWith(kReferenceType) ? this.formatReferenceDescriptor(dimensionType) : ClassFileFieldDescriptor.lookupString(dimensionType);
            formatted.append(dimensionTypeString);
            int i = 0;
            while (i < allBrackets.length()) {
                formatted.append(kArrayTypeString);
                ++i;
            }
        } else if (this.isNonArrayReference()) {
            formatted.append(this.formatReferenceDescriptor(this.fFieldDescriptor));
        } else {
            formatted.append(ClassFileFieldDescriptor.lookupString(this.fFieldDescriptor));
        }
        return formatted.toString();
    }

    public String getGenericType() {
        if (this.isAnyReference()) {
            return kObjectParameterType;
        }
        return this.fFieldDescriptor;
    }

    @Override
    public boolean isSInt8() {
        return this.fFieldDescriptor != null && this.fFieldDescriptor.equals(kByteType);
    }

    @Override
    public boolean isChar() {
        return this.fFieldDescriptor != null && this.fFieldDescriptor.equals(kCharType);
    }

    @Override
    public boolean isDouble() {
        return this.fFieldDescriptor != null && this.fFieldDescriptor.equals(kDoubleType);
    }

    @Override
    public boolean isFloat() {
        return this.fFieldDescriptor != null && this.fFieldDescriptor.equals(kFloatType);
    }

    @Override
    public boolean isSInt32() {
        return this.fFieldDescriptor != null && this.fFieldDescriptor.equals(kIntegerType);
    }

    @Override
    public boolean isSInt64() {
        return this.fFieldDescriptor != null && this.fFieldDescriptor.equals(kLongType);
    }

    @Override
    public boolean isNonArrayReference() {
        return this.fFieldDescriptor.startsWith(kReferenceType);
    }

    @Override
    public boolean isString() {
        return this.fFieldDescriptor != null && this.fFieldDescriptor.equals(kStringParameterType);
    }

    private boolean calculateIsObject() {
        return this.isNonArrayReference() || this.isArrayReference();
    }

    @Override
    public boolean isAnyReference() {
        return this.fIsObject;
    }

    @Override
    public boolean isSInt16() {
        return this.fFieldDescriptor != null && this.fFieldDescriptor.equals(kShortType);
    }

    @Override
    public boolean isUInt8() {
        return false;
    }

    @Override
    public boolean isUInt16() {
        return false;
    }

    @Override
    public boolean isUInt32() {
        return false;
    }

    @Override
    public boolean isUInt64() {
        return false;
    }

    @Override
    public boolean isArrayReference() {
        return this.fFieldDescriptor.startsWith(kArrayType);
    }

    @Override
    public boolean isBoolean() {
        return this.fFieldDescriptor != null && this.fFieldDescriptor.equals(kBooleanType);
    }

    @Override
    public boolean isVoid() {
        return this.fFieldDescriptor != null && this.fFieldDescriptor.equals(kVoidType);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassFileFieldDescriptor) {
            ClassFileFieldDescriptor o = (ClassFileFieldDescriptor)obj;
            return this.fFieldDescriptor == null ? o.fFieldDescriptor == null : this.fFieldDescriptor.equals(o.fFieldDescriptor);
        }
        return false;
    }

    public int hashCode() {
        return this.fFieldDescriptor.hashCode();
    }
}

