/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.preflight.modules;

import com.wily.util.JavaVersion;
import com.wily.util.preflight.PreflightMessage;
import com.wily.util.preflight.modules.IPreflightModule;

public class JavaVersionModule
implements IPreflightModule {
    private static String kVersionProperty = "java.version";
    private final int fCheckMajor;
    private final int fCheckMinor;
    private final int fCheckMicro;
    private String fSystemFull;
    private final String fErrorMessage;
    private final String fWarningMessage;
    private final JavaVersion fSystemVersion;

    public JavaVersionModule(int majorVersion, int minorVersion, int microVersion, String errorMessage, String warningMessage) {
        this.fCheckMajor = majorVersion;
        this.fCheckMinor = minorVersion;
        this.fCheckMicro = microVersion;
        this.fErrorMessage = errorMessage;
        this.fWarningMessage = warningMessage;
        this.fSystemFull = System.getProperty(kVersionProperty);
        this.fSystemVersion = JavaVersion.getCurrentVersion();
    }

    @Override
    public PreflightMessage[] IPreflightModule_doCheck() {
        String lineSeparator = System.getProperty("line.separator");
        if (this.fSystemVersion.isFuzzy()) {
            String message = "Your Java Virtual Machine reports the following fuzzy version number: " + this.fSystemFull + lineSeparator + this.fWarningMessage;
            return new PreflightMessage[]{new PreflightMessage(message, false, false)};
        }
        if (this.fSystemVersion.getMajor() < this.fCheckMajor || this.fSystemVersion.getMajor() == this.fCheckMajor && this.fSystemVersion.getMinor() < this.fCheckMinor || this.fSystemVersion.getMajor() == this.fCheckMajor && this.fSystemVersion.getMinor() == this.fCheckMinor && this.fSystemVersion.getRelease() < this.fCheckMicro) {
            String message = "Your Java Virtual Machine reports the following version number: " + this.fSystemVersion.getMajor() + "." + this.fSystemVersion.getMinor() + "." + this.fSystemVersion.getRelease() + lineSeparator + this.fErrorMessage;
            return new PreflightMessage[]{new PreflightMessage(message, false, true)};
        }
        return new PreflightMessage[]{new PreflightMessage("Success")};
    }
}

