/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.correlation.WSCorrelationTracer;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WL9CorrelationTracer
extends WSCorrelationTracer {
    private final IAgent agent;
    final String tracerKey = "WL9CorrelationTracer";
    private static ThreadLocal Cache = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new HashMap();
        }
    };

    public static void set(Object key, Object value) {
        WL9CorrelationTracer.get().put(key, value);
    }

    public static Object get(Object key) {
        return WL9CorrelationTracer.get().get(key);
    }

    private static Map get() {
        return (Map)Cache.get();
    }

    public static void clear() {
        WL9CorrelationTracer.get().clear();
    }

    public WL9CorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.agent = agent;
    }

    private boolean headerAlreadySet(Object soapHeader) {
        try {
            Object childElement = null;
            if (soapHeader != null) {
                this.logger.debug("WL9CorrelationTracer.headerAlreadySet header !=null");
                Iterator itr = (Iterator)WSMUtils.invokeMethodOnObject(soapHeader, "getChildElements");
                while (itr.hasNext()) {
                    childElement = itr.next();
                    this.logger.debug("WL9CorrelationTracer.headerAlreadySet soap in while childElement=" + childElement.getClass());
                    if (!childElement.getClass().getName().equals("weblogic.xml.saaj.SOAPHeaderElementImpl")) continue;
                    Object elementName = WSMUtils.invokeMethodOnObject(childElement, "getElementName");
                    String headerName = (String)WSMUtils.invokeMethodOnObject(elementName, "getLocalName");
                    this.logger.debug("WL9CorrelationTracer.headerAlreadySet SOAP headerName=" + headerName);
                    if (!headerName.equals("WSCorIDSOAPHeader")) continue;
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug("WL9CorrelationTracer.headerAlreadySet::CorId Found.");
                    }
                    return true;
                }
            }
        }
        catch (Exception e) {
            WSMUtils.handleException(this.agent, "WL9CorrelationTracer headerAlreadySet Error ", e);
        }
        return false;
    }

    private void processClientCorrelation(Object soapMessage) {
        try {
            String correlationString = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
            this.logger.debug("WL9CorrelationTracer.processClientCorrelation correlationString=" + correlationString);
            this.insertHTTPCorrelationInfo(soapMessage, WSMUtils.correlationHTTPInsertionEnabled());
            if (WSMUtils.correlationSOAPInsertionEnabled()) {
                Object soapPart = WSMUtils.invokeMethodOnObject(soapMessage, "getSOAPPart");
                Object soapEnvelope = WSMUtils.invokeMethodOnObject(soapPart, "getEnvelope");
                Object soapHeader = WSMUtils.invokeMethodOnObject(soapEnvelope, "getHeader");
                if (this.headerAlreadySet(soapHeader)) {
                    return;
                }
                Object attrName = WSMUtils.invokeMethodOnObject(soapEnvelope, "createName", new Class[]{String.class}, new Object[]{"CorID"});
                Object soapElement = WSMUtils.invokeMethodOnObject(soapHeader, "addChildElement", new Class[]{String.class, String.class, String.class}, new Object[]{"WSCorIDSOAPHeader", "", "http://www.ca.com/apm"});
                ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
                WSMUtils.invokeMethodOnObject(soapElement, "addAttribute", new Class[]{Class.forName("javax.xml.soap.Name", false, threadClassLoader), String.class}, new Object[]{attrName, correlationString});
                WSMUtils.invokeMethodOnObject(soapElement, "addNamespaceDeclaration", new Class[]{String.class, String.class}, new Object[]{"", "http://www.ca.com/apm"});
            }
        }
        catch (Exception e) {
            WSMUtils.handleException(this.agent, "WL9CorrelationTracer processClientCorrelation Error ", e);
        }
    }

    protected void insertHTTPCorrelationInfo(Object soapMessage, boolean isHTTPCorrelationEnabled) throws Exception {
        if (isHTTPCorrelationEnabled) {
            Object mimeheaders = WSMUtils.invokeMethodOnObject(soapMessage, "getMimeHeaders");
            this.addCorrelationInfoToHttpHeaders(mimeheaders);
        }
    }

    protected void addCorrelationInfoToHttpHeaders(Object mimeheaders) throws Exception {
        String corId = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
        WSMUtils.invokeMethodOnObject(mimeheaders, "addHeader", new Class[]{String.class, String.class}, new Object[]{"CorID", corId});
    }

    @Override
    public void ITracer_finishTrace(int index, InvocationData data) {
        try {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                WSMUtils.getLogger().debug("WL9CorrelationTracer.ITracer_finishTrace ");
                Object messageContext = data.getInvocationParameterAsObject(0);
                Object soapMessage = WSMUtils.invokeMethodOnObject(messageContext, "getMessage");
                Object soapPart = WSMUtils.invokeMethodOnObject(soapMessage, "getSOAPPart");
                Object soapEnvelope = WSMUtils.invokeMethodOnObject(soapPart, "getEnvelope");
                Object soapHeader = WSMUtils.invokeMethodOnObject(soapEnvelope, "getHeader");
                this.headerAlreadySet(soapHeader);
            }
        }
        catch (Exception e) {
            WSMUtils.handleException(this.agent, "WL9CorrelationTracer ITracer_finishTrace Error ", e);
        }
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            String dispatcherType = (String)WL9CorrelationTracer.get("WL9CorrelationTracer");
            Object messageContext = data.getInvocationParameterAsObject(0);
            Object soapMessage = WSMUtils.invokeMethodOnObject(messageContext, "getMessage");
            WSMUtils.getLogger().debug("WL9CorrelationTracer:: cache size" + WL9CorrelationTracer.get().size());
            ClassLoader wsdmClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
            WSMUtils.getLogger().debug("WL9CorrelationTracer: wsdmClassLoader=" + wsdmClassLoader);
            if (dispatcherType != null) {
                if (dispatcherType.equals("weblogic.wsee.ws.dispatch.server.ServerDispatcher")) {
                    WSMUtils.getLogger().debug("WLS9CorrelationTracer ServerDispatcher do nothing");
                } else if (dispatcherType.equals("weblogic.wsee.ws.dispatch.client.ClientDispatcher")) {
                    WSMUtils.getLogger().debug("WLS9CorrelationTracer ClientDispatcher");
                    this.processClientCorrelation(soapMessage);
                } else {
                    WSMUtils.getLogger().debug("Detected unsupported Weblogic dispatcher");
                }
            }
        }
        catch (Exception e) {
            WSMUtils.handleException(this.agent, "WL9CorrelationTracer Error ", e);
        }
        super.ITracer_startTrace(tracerIndex, data);
    }
}

