/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.client.transport.websocket;

import com.wily.introscope.agent.AgentFactoryThread;
import com.wily.isengard.client.transport.websocket.HackedHttpProxyHandler;
import com.wily.isengard.client.transport.websocket.NettyAgentLogger;
import com.wily.isengard.client.transport.websocket.ProxySupport;
import com.wily.isengard.client.transport.websocket.WebSocketAdapter;
import com.wily.isengard.client.transport.websocket.WebSocketClientImpl;
import com.wily.isengard.client.transport.websocket.WebSocketClientNettyHandler;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import sun.security.util.HostnameChecker;

public class WebSocketClientNettyImpl
implements WebSocketClientImpl {
    private static EventLoopGroup group = new NioEventLoopGroup(1, (ThreadFactory)new NettyAgentThreadFactory(WebSocketClientNettyImpl.class, true));
    private boolean closed = false;
    private URI uri;
    private final WebSocketClientNettyHandler handler;
    private final Bootstrap bootstrap;
    private final int port;
    private final boolean sniEnabled;
    private SslHandler sslHandler = null;
    private final IModuleFeedbackChannel feedback;
    private final Module module;

    public WebSocketClientNettyImpl(URI serverUri, Map<String, String> httpHeaders, WebSocketAdapter adapter) {
        this.feedback = adapter.getFeedbackChannel();
        this.module = adapter.getModule();
        this.sniEnabled = adapter.isSniEnabled();
        InternalLoggerFactory.setDefaultFactory(new NettyAgentLoggerFactory(this.feedback));
        this.uri = serverUri;
        String scheme = this.uri.getScheme() == null ? "ws" : this.uri.getScheme();
        int p = this.uri.getPort();
        if (p == -1) {
            if ("ws".equalsIgnoreCase(scheme)) {
                p = 80;
            } else if ("wss".equalsIgnoreCase(scheme)) {
                p = 443;
            }
        }
        this.port = p;
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        for (String header : httpHeaders.keySet()) {
            headers.add(header, (Object)httpHeaders.get(header));
        }
        this.handler = new WebSocketClientNettyHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)this.uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)true, (HttpHeaders)headers), adapter);
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)this.bootstrap.group(group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws IOException {
                ChannelPipeline p = ch.pipeline();
                Proxy proxy = ProxySupport.getProxy();
                if (proxy != null) {
                    HackedHttpProxyHandler proxyHandler = ProxySupport.isAuthRequired() ? new HackedHttpProxyHandler(proxy.address(), ProxySupport.getUserName(), ProxySupport.getPassword()) : new HackedHttpProxyHandler(proxy.address());
                    p.addLast("proxy", (ChannelHandler)proxyHandler);
                }
                if (WebSocketClientNettyImpl.this.sslHandler != null) {
                    p.addLast("ssl", (ChannelHandler)WebSocketClientNettyImpl.this.sslHandler);
                }
                p.addLast("httpclient", (ChannelHandler)new HttpClientCodec());
                p.addLast("httpaggregator", (ChannelHandler)new HttpObjectAggregator(8192));
                p.addLast("wscompression", (ChannelHandler)WebSocketClientCompressionHandler.INSTANCE);
                p.addLast("websocket", (ChannelHandler)WebSocketClientNettyImpl.this.handler);
            }
        });
    }

    @Override
    public boolean isOpen() {
        return this.handler != null && this.handler.isOpen();
    }

    @Override
    public void send(ByteBuffer buffer) {
        ByteBuf data = Unpooled.copiedBuffer((ByteBuffer)buffer);
        this.handler.send(data);
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.handler.getInetAddress();
    }

    @Override
    public void close() {
        if (this.isOpen()) {
            this.handler.close();
        }
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return 0;
    }

    @Override
    public void setSSLContext(SSLContext sslctx, boolean validateHostname, String[] ciphers, String[] protocols, final String serverHost, int port) {
        final SSLEngine engine = this.sniEnabled && serverHost != null ? sslctx.createSSLEngine(serverHost, port) : sslctx.createSSLEngine();
        engine.setUseClientMode(true);
        if (ciphers != null && ciphers.length > 0) {
            engine.setEnabledCipherSuites(ciphers);
        }
        if (protocols != null && protocols.length > 0) {
            engine.setEnabledProtocols(protocols);
        }
        this.sslHandler = new SslHandler(engine);
        if (validateHostname) {
            this.sslHandler.handshakeFuture().addListener(new FutureListener<Channel>(){

                @Override
                public void operationComplete(Future<Channel> future) throws Exception {
                    if (!future.isSuccess()) {
                        WebSocketClientNettyImpl.this.feedback.debug(WebSocketClientNettyImpl.this.module, "Handshake failed");
                        return;
                    }
                    WebSocketClientNettyImpl.this.feedback.debug(WebSocketClientNettyImpl.this.module, "Handshake complete, will validate certificate");
                    try {
                        HostnameChecker checker = HostnameChecker.getInstance((byte)1);
                        Certificate[] certificates = engine.getSession().getPeerCertificates();
                        X509Certificate x509 = (X509Certificate)certificates[0];
                        try {
                            checker.match(serverHost, x509);
                        }
                        catch (CertificateException e1) {
                            WebSocketClientNettyImpl.this.feedback.warn(WebSocketClientNettyImpl.this.module, "Failed to validate hostname in certificate:" + e1.getMessage());
                            try {
                                ((Channel)future.get()).close();
                                WebSocketClientNettyImpl.this.feedback.debug(WebSocketClientNettyImpl.this.module, "Closed the channel as result of hostname mismatch");
                            }
                            catch (Exception e2) {
                                WebSocketClientNettyImpl.this.feedback.debug(WebSocketClientNettyImpl.this.module, "failed to close channel", (Throwable)e2);
                            }
                        }
                        WebSocketClientNettyImpl.this.feedback.debug(WebSocketClientNettyImpl.this.module, "Hostname in certificate is valid");
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Error e) {
                        WebSocketClientNettyImpl.this.feedback.warn(WebSocketClientNettyImpl.this.module, "Failed to verify remote hostname certificate: " + e.getMessage() + "; will allow connection to be established. (This may happen due to removal of non-public API)");
                    }
                }
            });
        }
    }

    @Override
    public void connect(int timeout) throws IOException {
        try {
            this.bootstrap.connect(this.uri.getHost(), this.port).await((long)timeout);
            this.handler.handshakeFuture().await((long)timeout);
        }
        catch (InterruptedException e) {
            this.feedback.debug(this.module, "InterruptedException: ", (Throwable)e);
        }
    }

    private static class NettyAgentLoggerFactory
    extends InternalLoggerFactory {
        IModuleFeedbackChannel feedback;

        public NettyAgentLoggerFactory(IModuleFeedbackChannel feedback) {
            this.feedback = feedback;
        }

        @Override
        protected InternalLogger newInstance(String name) {
            return new NettyAgentLogger(this.feedback, name);
        }
    }

    private static class NettyAgentThreadFactory
    extends DefaultThreadFactory {
        boolean isDaemon = true;

        public NettyAgentThreadFactory(Class<?> clazz, boolean daemon) {
            super(clazz, daemon);
            this.isDaemon = daemon;
        }

        @Override
        protected Thread newThread(Runnable runnable, String name) {
            AgentFactoryThread t = new AgentFactoryThread(null, runnable, name);
            t.setDaemon(this.isDaemon);
            return t;
        }
    }
}

