/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.compiler;

import com.wily.diagnos.cmp.batch.ASingleCompiler;
import com.wily.diagnos.cmp.classfile.DGClassException;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.mutate.IClassMutator;
import com.wily.diagnos.personality.java.classfile.DGClass;
import com.wily.introscope.api.instrument.DeepInheritanceHelper;
import com.wily.util.classfile.IModeledClass;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DGStreamSingleCompiler
extends ASingleCompiler {
    private final InputStream fClassFileStream;
    private final OutputStream fOutputStream;
    private final ClassLoader fLoader;
    static final boolean isDIv2 = "agentmain".equals(System.getProperty("com.wily.introscope.agent.starter")) || "2".equals(System.getProperty("com.wily.introscope.deepInheritance.implementationVersion", "1"));

    public DGStreamSingleCompiler(DGCompilerSettings settings, ICompilerLog log, InputStream classFileStream, OutputStream outputStream, boolean isRedefine, Class<?> classRedefined) {
        this(settings, log, classFileStream, outputStream, null, isRedefine, classRedefined);
    }

    public DGStreamSingleCompiler(DGCompilerSettings settings, ICompilerLog log, InputStream classFileStream, OutputStream outputStream, ClassLoader loader, boolean isRedefine, Class<?> classRedefined) {
        super(settings, log, isRedefine, classRedefined);
        this.fClassFileStream = classFileStream;
        this.fOutputStream = outputStream;
        this.fLoader = loader;
    }

    @Override
    protected IModeledClass doNewModeledClass() throws DGClassException, IOException {
        DGClass retClass = new DGClass(this.fClassFileStream, this.getLog(), this.fLoader);
        if (DeepInheritanceHelper.isDebugOn && DeepInheritanceHelper.debugForClass.contains(DeepInheritanceHelper.classNameForest.addAndGetID(retClass.getClassName().getReflectionFriendlyQualifiedNameString()))) {
            System.out.print("");
        }
        if (isDIv2) {
            DeepInheritanceHelper.addClass((IModeledClass)retClass);
        }
        return retClass;
    }

    @Override
    protected IClassMutator doNewMutator(IModeledClass targetClass) throws DGClassException, IOException {
        Assertion.wilyAssert((boolean)(targetClass instanceof DGClass));
        return (DGClass)targetClass;
    }

    @Override
    protected void doCommit(IModeledClass targetClass, IClassMutator mutator) throws DGClassException, IOException {
        Assertion.wilyAssert((boolean)(targetClass instanceof DGClass));
        DGClass javaClass = (DGClass)targetClass;
        javaClass.write(this.fOutputStream);
    }
}

