/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.trace.cas.IMetricHolder;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.cas.SharedDataStructure4;
import com.wily.introscope.agent.trace.cas.SharedDataStructure5;
import com.wily.introscope.agent.trace.cas.TransactionTransitionException;
import com.wily.introscope.agent.trace.hc2.AverageMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.CountMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.SaturationGathererWrapper;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;

public final class RepositoryFactory {
    private static final int kHighConcurrencyNumberOfStripes = 16;
    private static final int kLowConcurrencyNumberOfStripes = 1;
    private static final String kNumberOfStripes = "com.wily.introscope.agent.highconcurrency.numberofstripes";
    private volatile DataAccumulatorFactory fFactory;
    private final int fNumberOfStripes;

    public RepositoryFactory(DataAccumulatorFactory factory) {
        this(factory, false);
    }

    public RepositoryFactory(DataAccumulatorFactory factory, boolean isHighConcurrency) {
        int numberOfStripesHighConcurrency = 16;
        try {
            numberOfStripesHighConcurrency = AgentShim.getAgent().IAgent_getIndexedProperties().getIntProperty(kNumberOfStripes, 16);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            // empty catch block
        }
        this.fFactory = factory;
        this.fNumberOfStripes = isHighConcurrency ? numberOfStripesHighConcurrency : 1;
    }

    public RepositoryFactory() {
        this(null, false);
    }

    public final IRepository safeGetIntegerAverageDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 1025;
        boolean shouldBeConsumedOnRead = true;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
        IRepository result = this.safeGetIntegerAverageDataAccumulator(shouldBeConsumedOnRead, this.fNumberOfStripes);
        result = this.combineMetricAndRepository(target, metric, result);
        return result;
    }

    public final IRepository safeGetFrontendIntegerAverageDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 0x10000401;
        boolean shouldBeConsumedOnRead = true;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
        IRepository result = this.safeGetIntegerAverageDataAccumulator(shouldBeConsumedOnRead, this.fNumberOfStripes);
        result = this.combineMetricAndRepository(target, metric, result);
        return result;
    }

    public final IRepository safeGetBackendIntegerAverageDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 536871937;
        boolean shouldBeConsumedOnRead = true;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
        IRepository result = this.safeGetIntegerAverageDataAccumulator(shouldBeConsumedOnRead, this.fNumberOfStripes);
        result = this.combineMetricAndRepository(target, metric, result);
        return result;
    }

    public final IRepository safeGetBizTrxIntegerAverageDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 0x40000401;
        boolean shouldBeConsumedOnRead = true;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
        IRepository result = this.safeGetIntegerAverageDataAccumulator(shouldBeConsumedOnRead, this.fNumberOfStripes);
        result = this.combineMetricAndRepository(target, metric, result);
        return result;
    }

    public final IRepository safeGetIntegerPercentageDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 4097;
        boolean shouldBeConsumedOnRead = true;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
        IRepository result = this.safeGetIntegerAverageDataAccumulator(shouldBeConsumedOnRead, this.fNumberOfStripes);
        result = this.combineMetricAndRepository(target, metric, result);
        return result;
    }

    public final IRepository safeGetIntegerPercentageDataAccumulator(String metricName, int modifiers, ISharedMetricHolder target) {
        int metricType = 0x1001 | modifiers;
        boolean shouldBeConsumedOnRead = true;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
        IRepository result = this.safeGetIntegerAverageDataAccumulator(shouldBeConsumedOnRead, this.fNumberOfStripes);
        result = this.combineMetricAndRepository(target, metric, result);
        return result;
    }

    public final IRepository safeGetLongIntervalCounterDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 8194;
        boolean shouldBeConsumedOnRead = true;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        IRepository result = this.safeGetLongIntervalCounterDataAccumulator(shouldBeConsumedOnRead, this.fNumberOfStripes);
        result = this.combineMetricAndRepository(target, metric, result);
        return result;
    }

    public final IRepository safeGetFrontendLongIntervalCounterDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 0x10002002;
        boolean shouldBeConsumedOnRead = true;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        IRepository result = this.safeGetLongIntervalCounterDataAccumulator(shouldBeConsumedOnRead, this.fNumberOfStripes);
        result = this.combineMetricAndRepository(target, metric, result);
        return result;
    }

    public final IRepository safeGetBackendLongIntervalCounterDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 0x20002002;
        boolean shouldBeConsumedOnRead = true;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        IRepository result = this.safeGetLongIntervalCounterDataAccumulator(shouldBeConsumedOnRead, this.fNumberOfStripes);
        result = this.combineMetricAndRepository(target, metric, result);
        return result;
    }

    public final IRepository safeGetBizTrxLongIntervalCounterDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 0x40002002;
        boolean shouldBeConsumedOnRead = true;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        IRepository result = this.safeGetLongIntervalCounterDataAccumulator(shouldBeConsumedOnRead, this.fNumberOfStripes);
        result = this.combineMetricAndRepository(target, metric, result);
        return result;
    }

    public final IRepository safeGetIntegerFluctuatingCounterDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 257;
        boolean shouldBeConsumedOnRead = false;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
        IRepository result = new SharedDataStructure5(shouldBeConsumedOnRead);
        result = this.combineMetricAndRepositoryForcedShared(target, metric, result);
        return result;
    }

    public final IRepository safeGetLongFluctuatingCounterDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 258;
        boolean shouldBeConsumedOnRead = false;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a long fluctuating counter metric");
        IRepository result = new SharedDataStructure5(shouldBeConsumedOnRead);
        result = this.combineMetricAndRepositoryForcedShared(target, metric, result);
        return result;
    }

    public final IRepository safeGetFrontendIntegerFluctuatingCounterDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 0x10000101;
        boolean shouldBeConsumedOnRead = false;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
        IRepository result = new SharedDataStructure5(shouldBeConsumedOnRead);
        result = this.combineMetricAndRepositoryForcedShared(target, metric, result);
        return result;
    }

    public final IRepository safeGetBackendIntegerFluctuatingCounterDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 0x20000101;
        boolean shouldBeConsumedOnRead = false;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
        IRepository result = new SharedDataStructure5(shouldBeConsumedOnRead);
        result = this.combineMetricAndRepositoryForcedShared(target, metric, result);
        return result;
    }

    public final IRepository safeGetBizTrxIntegerFluctuatingCounterDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 0x40000101;
        boolean shouldBeConsumedOnRead = false;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
        IRepository result = new SharedDataStructure5(shouldBeConsumedOnRead);
        result = this.combineMetricAndRepositoryForcedShared(target, metric, result);
        return result;
    }

    public final IRepository safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 385;
        boolean shouldBeConsumedOnRead = false;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
        IRepository result = new SharedDataStructure5(shouldBeConsumedOnRead);
        result = this.combineMetricAndRepositoryForcedShared(target, metric, result);
        return result;
    }

    public final IRepository safeGetFrontendIntegerAggregatingFluctuatingCounterDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 0x10000181;
        boolean shouldBeConsumedOnRead = false;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
        IRepository result = new SharedDataStructure5(shouldBeConsumedOnRead);
        result = this.combineMetricAndRepositoryForcedShared(target, metric, result);
        return result;
    }

    public final IRepository safeGetBackendIntegerAggregatingFluctuatingCounterDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 536871297;
        boolean shouldBeConsumedOnRead = false;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
        IRepository result = new SharedDataStructure5(shouldBeConsumedOnRead);
        result = this.combineMetricAndRepositoryForcedShared(target, metric, result);
        return result;
    }

    public final IRepository safeGetBizTrxIntegerAggregatingFluctuatingCounterDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 1073742209;
        boolean shouldBeConsumedOnRead = false;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
        IRepository result = new SharedDataStructure5(shouldBeConsumedOnRead);
        result = this.combineMetricAndRepositoryForcedShared(target, metric, result);
        return result;
    }

    public final IRepository safeGetLongAverageDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 1026;
        boolean shouldBeConsumedOnRead = true;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a long duration metric");
        IRepository result = this.safeGetLongAverageDataAccumulator(shouldBeConsumedOnRead, this.fNumberOfStripes);
        result = this.combineMetricAndRepository(target, metric, result);
        return result;
    }

    public IRepository safeGetIntegerSaturationDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 16385;
        boolean shouldBeConsumedOnRead = true;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer saturation metric");
        IRepository result = this.safeGetIntegerSaturationDataAccumulator(shouldBeConsumedOnRead, this.fNumberOfStripes);
        result = this.combineMetricAndRepository(target, metric, result);
        return result;
    }

    public IRepository safeGetIntegerRateDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 513;
        boolean shouldBeConsumedOnRead = true;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer rate metric");
        IRepository result = this.safeGetIntegerRateDataAccumulator(shouldBeConsumedOnRead, this.fNumberOfStripes);
        result = this.combineMetricAndRepository(target, metric, result);
        return result;
    }

    public final IRepository safeGetIntegerMonotonicallyIncreasingCounterDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 0x100101;
        boolean shouldBeConsumedOnRead = false;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for an integer monotonically increasing counter metric");
        IRepository result = this.safeGetIntegerIntervalCounterDataAccumulator(shouldBeConsumedOnRead, this.fNumberOfStripes);
        result = this.combineMetricAndRepository(target, metric, result);
        return result;
    }

    public final IRepository safeGetLongMonotonicallyIncreasingCounterDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 0x100102;
        boolean shouldBeConsumedOnRead = false;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a long monotonically increasing counter metric");
        IRepository result = this.safeGetIntegerIntervalCounterDataAccumulator(shouldBeConsumedOnRead, this.fNumberOfStripes);
        result = this.combineMetricAndRepository(target, metric, result);
        return result;
    }

    public final IRepository safeGetTimestampDataAccumulator(String metricName, ISharedMetricHolder target) {
        int metricType = 2050;
        boolean shouldBeConsumedOnRead = false;
        AgentMetric metric = this.unSafeGetMetricOfType(metricName, metricType, "Invalid Names:Invalid name given for a long monotonically increasing counter metric");
        IRepository result = this.safeGetIntegerIntervalCounterDataAccumulator(shouldBeConsumedOnRead, this.fNumberOfStripes);
        result = this.combineMetricAndRepository(target, metric, result);
        return result;
    }

    private IRepository combineMetricAndRepository(ISharedMetricHolder target, AgentMetric metric, IRepository result) {
        if (target instanceof IMetricHolder) {
            target.addMetric(metric, result);
            return result;
        }
        IRepository existing = WilyTransactionStructure.putIntoGlobalGathererIfAbsent(metric, result);
        if (existing == null) {
            existing = result;
        }
        target.addMetric(metric, existing);
        return existing;
    }

    private IRepository combineMetricAndRepositoryForcedShared(ISharedMetricHolder target, AgentMetric metric, IRepository result) {
        IRepository existing = WilyTransactionStructure.putIntoGlobalGathererIfAbsent(metric, result);
        if (existing == null) {
            existing = result;
        }
        target.addMetric(metric, existing);
        return existing;
    }

    private IRepository safeGetIntegerAverageDataAccumulator(boolean shouldBeConsumedOnRead, int numberOfStripes) {
        SharedDataStructure4 result = new SharedDataStructure4(AverageMetricGathererWrapper.getFactory(shouldBeConsumedOnRead), numberOfStripes);
        return result;
    }

    private IRepository safeGetIntegerIntervalCounterDataAccumulator(boolean shouldBeConsumedOnRead, int numberOfStripes) {
        SharedDataStructure4 result = new SharedDataStructure4(CountMetricGathererWrapper.getFactory(shouldBeConsumedOnRead), numberOfStripes);
        return result;
    }

    private IRepository safeGetIntegerSaturationDataAccumulator(boolean shouldBeConsumedOnRead, int numberOfStripes) {
        SharedDataStructure4 result = new SharedDataStructure4(SaturationGathererWrapper.getFactory(shouldBeConsumedOnRead), numberOfStripes);
        return result;
    }

    private IRepository safeGetIntegerRateDataAccumulator(boolean shouldBeConsumedOnRead, int numberOfStripes) {
        SharedDataStructure4 result = new SharedDataStructure4(CountMetricGathererWrapper.getFactory(shouldBeConsumedOnRead), numberOfStripes);
        return result;
    }

    private IRepository safeGetLongAverageDataAccumulator(boolean shouldBeConsumedOnRead, int numberOfStripes) {
        SharedDataStructure4 result = new SharedDataStructure4(AverageMetricGathererWrapper.getFactory(shouldBeConsumedOnRead), numberOfStripes);
        return result;
    }

    private IRepository safeGetLongIntervalCounterDataAccumulator(boolean shouldBeConsumedOnRead, int numberOfStripes) {
        SharedDataStructure4 result = new SharedDataStructure4(CountMetricGathererWrapper.getFactory(shouldBeConsumedOnRead), numberOfStripes);
        return result;
    }

    private IRepository getSharedRepository(boolean shouldBeConsumedOnRead, int numberOfStripes) {
        return new SharedDataStructure4(CountMetricGathererWrapper.getFactory(shouldBeConsumedOnRead), numberOfStripes);
    }

    private IRepository getSharedRepository(ISharedElement wrapper, int numberOfStripes) {
        return new SharedDataStructure4(wrapper, numberOfStripes);
    }

    protected IRepository getSharedRepositoryNoSharedStructure(boolean shouldBeConsumedOnRead) {
        return new SharedDataStructure5(false);
    }

    public static IRepository getAverageMetricRepository() {
        return new SharedDataStructure4(AverageMetricGathererWrapper.getFactory(true), 16);
    }

    public static IRepository getCountQueuedRepository(boolean shouldBeConsumedOnRead) {
        return new SharedDataStructure4(CountMetricGathererWrapper.getFactory(shouldBeConsumedOnRead), 16);
    }

    public static IRepository getCountImmediateRepository(boolean shouldBeConsumedOnRead) {
        return new SharedDataStructure5(false);
    }

    public void setFactory(DataAccumulatorFactory fFactory) {
        this.fFactory = fFactory;
    }

    public static AgentMetric unSafeGetMetricOfType(IAgent agent, String formattedMetricName, int metricType, String kplaceholderintegeraveragename) throws TransactionTransitionException {
        AgentMetric metric = agent.IAgent_getDataAccumulatorFactory().safeGetMetricOfType(formattedMetricName, metricType, kplaceholderintegeraveragename);
        if (metric == null || metric == AgentMetric.kNullAgentMetric) {
            throw new TransactionTransitionException("Metric is null for " + formattedMetricName);
        }
        return metric;
    }

    public AgentMetric unSafeGetMetricOfType(String formattedMetricName, int metricType, String kplaceholderintegeraveragename) throws TransactionTransitionException {
        AgentMetric metric = this.fFactory.safeGetMetricOfType(formattedMetricName, metricType, kplaceholderintegeraveragename);
        if (metric == null || metric == AgentMetric.kNullAgentMetric) {
            throw new TransactionTransitionException("Metric is null for " + formattedMetricName);
        }
        return metric;
    }

    public static void safeGetMetricOfType(IAgent agent, String formattedMetricName, int metricType, String kplaceholderintegeraveragename, ISafeGetMetricOfTypeResultCallBack result) throws TransactionTransitionException {
        AgentMetric metric = agent.IAgent_getDataAccumulatorFactory().safeGetMetricOfType(formattedMetricName, metricType, kplaceholderintegeraveragename);
        if (metric == null || metric == AgentMetric.kNullAgentMetric) {
            result.onFailure(metric);
        } else {
            result.onSuccess(metric);
        }
    }

    public static interface ISafeGetMetricOfTypeResultCallBack {
        public void onSuccess(AgentMetric var1);

        public void onFailure(AgentMetric var1);
    }
}

