/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postoffice;

import com.wily.EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue;
import com.wily.EDU.oswego.cs.dl.util.concurrent.Executor;
import com.wily.EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import com.wily.isengard.api.ServerInstanceLocator;
import com.wily.isengard.api.TransportConfiguration;
import com.wily.isengard.message.AControlMessage;
import com.wily.isengard.message.AMessage;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.ClassLoaderManager;
import com.wily.isengard.postoffice.DefaultApplicationNotification;
import com.wily.isengard.postoffice.IApplicationNotification;
import com.wily.isengard.postoffice.IPostOfficeNotification;
import com.wily.isengard.postoffice.MailboxInUseException;
import com.wily.isengard.postoffice.MessageUndeliverableMessage;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.postoffice.PostOfficeAlreadyExistsError;
import com.wily.isengard.postoffice.PostOfficeSpecifier;
import com.wily.isengard.postofficehub.ARoutingMessage;
import com.wily.isengard.postofficehub.AckMessage;
import com.wily.isengard.postofficehub.AddRouteMessage;
import com.wily.isengard.postofficehub.ClonedRegistry;
import com.wily.isengard.postofficehub.IRouteTransport;
import com.wily.isengard.postofficehub.LoopbackTransport;
import com.wily.isengard.postofficehub.RegistryAvailableMessage;
import com.wily.isengard.postofficehub.RemoveRouteMessage;
import com.wily.isengard.postofficehub.Route;
import com.wily.isengard.postofficehub.RoutingTable;
import com.wily.isengard.postofficehub.auth.IAuthenticateServerGroup;
import com.wily.isengard.postofficehub.link.IIncomingConnectionHandler;
import com.wily.isengard.postofficehub.link.IOutgoingConnection;
import com.wily.isengard.postofficehub.link.OutgoingConnectionFactory;
import com.wily.isengard.registry.IRegistryServiceLocal;
import com.wily.isengard.registry.RegistryServiceLocal;
import com.wily.util.adt.IntHashMap;
import com.wily.util.concurrent.ConstantNameThreadFactory;
import com.wily.util.exception.UnexpectedExceptionError;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.IKeyedClassLoader;
import com.wily.util.thread.IThreadFactory;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class PostOfficeHub {
    public static final String kDefaultClassLoaderName = "";
    protected static Module sModule = new Module("PostOfficeHub");
    private String fHubName;
    private final RoutingTable fRouteTable;
    private final LinkedList<IRouteTransport> fRouteTransports;
    private Address fRegistryAddress;
    private CountDownLatch fConnectionLatch;
    private HashMap<String, PostOffice> fPostOffices;
    private IPostOfficeNotification fNotification;
    private IApplicationNotification fAppNotification;
    private boolean fClosing;
    private PostOffice fHubPO;
    private IntHashMap fLinkProtocolHandler;
    private final IAuthenticateServerGroup fAuthenticateServerGroup;
    private IModuleFeedbackChannel fFeedback;
    private final ClassLoaderManager fClassLoaderManager;
    private IThreadFactory fThreadFactory;
    private TransportConfiguration fDefaultTransportConfig;
    private IOutgoingConnection fOutgoingConnection;
    private QueuedExecutor fAsyncExecutionQueue;
    private BoundedLinkedQueue fAsyncExecutionQueueInternal;
    private QueuedExecutor fExceptionAsyncExecutionQueue;
    private BoundedLinkedQueue fExceptionAsyncExecutionQueueInternal;
    private QueuedExecutor fRouteDownQueue;
    private BoundedLinkedQueue fRouteDownQueueInternal;
    private boolean fIsGlobalRegistryOwner;
    private RegistryServiceLocal fLocalRegistry;
    private int fCorruptedMessageCount = 0;

    public PostOfficeHub(String hubName, IAuthenticateServerGroup authServerGroup, TransportConfiguration defaultTransportConfig, IModuleFeedbackChannel feedback, ClassLoader defaultClassloader, IThreadFactory threadFactory) {
        this.fHubName = hubName;
        this.fThreadFactory = threadFactory;
        this.fFeedback = feedback;
        this.fAsyncExecutionQueueInternal = new BoundedLinkedQueue(Integer.MAX_VALUE);
        this.fAsyncExecutionQueue = new QueuedExecutor(this.fAsyncExecutionQueueInternal);
        this.fAsyncExecutionQueue.setThreadFactory(new ConstantNameThreadFactory("PO Async Executor", threadFactory));
        this.fExceptionAsyncExecutionQueueInternal = new BoundedLinkedQueue(Integer.MAX_VALUE);
        this.fExceptionAsyncExecutionQueue = new QueuedExecutor(this.fExceptionAsyncExecutionQueueInternal);
        this.fExceptionAsyncExecutionQueue.setThreadFactory(new ConstantNameThreadFactory("PO Exception Async Executor", threadFactory));
        this.fRouteDownQueueInternal = new BoundedLinkedQueue(Integer.MAX_VALUE);
        this.fRouteDownQueue = new QueuedExecutor(this.fRouteDownQueueInternal);
        this.fRouteDownQueue.setThreadFactory(new ConstantNameThreadFactory("PO Route Down Executor", threadFactory));
        this.fRouteTable = new RoutingTable(this);
        this.fRouteTransports = new LinkedList();
        this.fPostOffices = new HashMap();
        this.fAppNotification = new DefaultApplicationNotification(this.getFeedbackChannel());
        this.fLinkProtocolHandler = new IntHashMap();
        this.fAuthenticateServerGroup = authServerGroup;
        this.fDefaultTransportConfig = defaultTransportConfig;
        this.fClassLoaderManager = new ClassLoaderManager(defaultClassloader);
        this.fLocalRegistry = new RegistryServiceLocal();
    }

    public PostOfficeHub(TransportConfiguration defaultTransportConfig, IModuleFeedbackChannel feedback, IThreadFactory threadFactory) {
        this("UnknownHub", null, defaultTransportConfig, feedback, PostOfficeHub.class.getClassLoader(), threadFactory);
    }

    public TransportConfiguration getDefaultTransportConfiguration() {
        return this.fDefaultTransportConfig;
    }

    public IAuthenticateServerGroup getAuthenticationPolicy() {
        return this.fAuthenticateServerGroup;
    }

    public void setPostOfficeNotification(IPostOfficeNotification notification) {
        this.fNotification = notification;
    }

    public ClassLoader getDefaultClassloader() {
        return this.fClassLoaderManager.getDefaultClassLoader();
    }

    public IThreadFactory getThreadFactory() {
        return this.fThreadFactory;
    }

    public void setApplicationNotification(IApplicationNotification notification) {
        this.fAppNotification = notification;
    }

    void setRegistryAddress(Address address) {
        Assertion.wilyAssert(address != null);
        this.fRegistryAddress = address;
        this.fIsGlobalRegistryOwner = true;
    }

    Address getRegistryAddress() throws ConnectionException {
        if (this.fRegistryAddress == null) {
            throw new ConnectionException();
        }
        return this.fRegistryAddress;
    }

    public String getHubName() {
        return this.fHubName;
    }

    public PostOffice getHubPO() {
        return this.fHubPO;
    }

    public synchronized PostOffice getOrCreatePostOffice(String postOfficeName) {
        PostOffice po = this.fPostOffices.get(postOfficeName);
        if (po == null) {
            po = new PostOffice(this, postOfficeName);
        }
        return po;
    }

    public synchronized PostOffice[] getPostOffices() {
        return this.fPostOffices.values().toArray(new PostOffice[0]);
    }

    public void createClonedRegistry() throws ConnectionException {
        ClonedRegistry reg;
        try {
            reg = new ClonedRegistry(this.fHubPO, this.getRegistryAddress());
        }
        catch (MailboxInUseException e) {
            throw new UnexpectedExceptionError(e);
        }
        this.fRegistryAddress = reg.getAddress();
    }

    synchronized void addLocalPostOffice(PostOffice postOffice) {
        if (this.fHubPO == null) {
            this.fHubPO = postOffice;
        }
        if (this.fPostOffices.get(postOffice.getSpecifier().getPostOfficeName()) != null) {
            throw new PostOfficeAlreadyExistsError("PostOffice: " + postOffice.getSpecifier().getPostOfficeName() + " already exists on this hub");
        }
        this.fPostOffices.put(postOffice.getSpecifier().getPostOfficeName(), postOffice);
        LoopbackTransport newTransport = new LoopbackTransport(postOffice);
        this.notifyTransportUp(newTransport);
        this.addRoute(postOffice.getSpecifier(), newTransport, 0);
    }

    synchronized void removePostOffice(PostOffice postOffice) {
        this.fPostOffices.remove(postOffice.getSpecifier().getPostOfficeName());
        Route route = this.fRouteTable.getRoute(postOffice.getSpecifier());
        if (route != null) {
            this.removeRoute(route);
            this.notifyTransportDown(route.getRouteTransport());
        }
    }

    void reportUnrecoverableException(Throwable t) {
        if (this.fAppNotification != null) {
            this.fAppNotification.reportUnrecoverableException(t);
        } else {
            this.getFeedbackChannel().error("Caught an unrecoverable exception", t);
        }
    }

    public void connectToServerHub(long timeout, String groupName, String credential, ServerInstanceLocator serverLocator) throws IOException {
        this.connectToServerHub(timeout, groupName, credential, this.getDefaultTransportConfiguration(), serverLocator);
    }

    public void connectToServerHub(long timeout, String groupName, String credential, TransportConfiguration transportConfig, ServerInstanceLocator serverLocator) throws IOException {
        IOutgoingConnection connection;
        block9: {
            connection = null;
            OutgoingConnectionFactory connFactory = new OutgoingConnectionFactory();
            connection = serverLocator.isHttpTunnelingRequested() ? connFactory.newHttpBasedConnection(transportConfig, serverLocator, this) : connFactory.newSocketBasedConnection(transportConfig, serverLocator, this);
            this.fConnectionLatch = new CountDownLatch(1);
            boolean succeeded = false;
            try {
                try {
                    String hubName = connection.connect(groupName, credential);
                    this.setHubName(hubName);
                    if (!this.fConnectionLatch.await(timeout, TimeUnit.MILLISECONDS)) {
                        throw new IOException("Connection failed since client did not receive timely ACK from server when connecting to remote hub: " + hubName);
                    }
                    succeeded = true;
                }
                catch (InterruptedException interruptedException) {
                    if (!succeeded) {
                        connection.close();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (!succeeded) {
                    connection.close();
                }
                throw throwable;
            }
            if (!succeeded) {
                connection.close();
            }
        }
        this.fOutgoingConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void close() {
        var1_1 = this;
        synchronized (var1_1) {
            if (this.fClosing) {
                return;
            }
            this.fClosing = true;
        }
        var2_2 = this;
        synchronized (var2_2) {
            iterator = new ArrayList<IRouteTransport>(this.fRouteTransports).iterator();
            // MONITOREXIT @DISABLED, blocks:[1, 3] lbl17 : MonitorExitStatement: MONITOREXIT : var2_2
            if (true) ** GOTO lbl21
        }
        do {
            transport = iterator.next();
            this.notifyTransportDown(transport);
lbl21:
            // 2 sources

        } while (iterator.hasNext());
        this.closeOutgoingConnections();
        this.fAsyncExecutionQueue.shutdownAfterProcessingCurrentlyQueuedTasks();
        this.fExceptionAsyncExecutionQueue.shutdownAfterProcessingCurrentlyQueuedTasks();
        this.fRouteDownQueue.shutdownAfterProcessingCurrentlyQueuedTasks();
    }

    public void hardDisconnect() {
        this.closeOutgoingConnections();
    }

    public void setHandlerForLinkProtocol(int protocol, IIncomingConnectionHandler handler) {
        this.fLinkProtocolHandler.put(protocol, handler);
    }

    public synchronized IIncomingConnectionHandler getHandlerForLinkProtocol(int protocol) {
        return (IIncomingConnectionHandler)this.fLinkProtocolHandler.get(protocol);
    }

    private synchronized void setHubName(String hubName) {
        if (this.getFeedbackChannel().isDebugEnabled(sModule)) {
            this.getFeedbackChannel().debug(sModule, "Hub name set to: " + hubName);
        }
        this.fHubName = hubName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRoute(PostOfficeSpecifier postOfficeName, IRouteTransport transport, int hops) {
        IRouteTransport[] transports;
        boolean added;
        Route route = new Route(postOfficeName, transport, hops);
        PostOfficeHub postOfficeHub = this;
        synchronized (postOfficeHub) {
            added = this.fRouteTable.addIfNotExists(route);
            transports = this.fRouteTransports.toArray(new IRouteTransport[0]);
        }
        if (added) {
            IRouteTransport[] iRouteTransportArray = transports;
            int n = transports.length;
            int n2 = 0;
            while (n2 < n) {
                IRouteTransport iRouteTransport = iRouteTransportArray[n2];
                if (iRouteTransport != transport) {
                    iRouteTransport.routeUp(route);
                }
                ++n2;
            }
            if (this.fNotification != null) {
                this.fNotification.postOfficeAdded(postOfficeName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRoute(Route route) {
        IRouteTransport[] currentRoute;
        PostOfficeHub postOfficeHub = this;
        synchronized (postOfficeHub) {
            this.fRouteTable.remove(route);
            currentRoute = this.fRouteTransports.toArray(new IRouteTransport[0]);
        }
        Thread.interrupted();
        try {
            this.fRouteDownQueue.execute(new RouteDown(route, currentRoute));
        }
        catch (InterruptedException interruptedException) {
            this.getFeedbackChannel().debug(sModule, "RouteDown task execution interrupted for hub: " + this.getHubName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectedPO(PostOfficeSpecifier spec) {
        Route route = null;
        PostOfficeHub postOfficeHub = this;
        synchronized (postOfficeHub) {
            route = this.fRouteTable.getRoute(spec);
        }
        return route != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void routeMessage(AMessage message, Address destination) {
        Route route = null;
        PostOfficeHub postOfficeHub = this;
        synchronized (postOfficeHub) {
            route = this.fRouteTable.getRoute(destination.getPostOffice());
        }
        if (route != null) {
            route.sendMessage(message, destination);
        } else {
            if (this.getFeedbackChannel().isDebugEnabled(sModule)) {
                this.getFeedbackChannel().debug(sModule, "No route for message " + message + " -> " + destination);
            }
            if (!(message instanceof AControlMessage)) {
                MessageUndeliverableMessage reportError = new MessageUndeliverableMessage(message, destination, "Route Unavailable", null);
                this.routeMessage(reportError, message.getSourceAddress());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTransportDown(IRouteTransport transport) {
        if (!(transport instanceof LoopbackTransport) && this.getFeedbackChannel().isVerboseEnabled(sModule)) {
            this.getFeedbackChannel().verbose(sModule, "Disconnected From: " + transport.getRouteConnectionInfo());
        }
        Route[] routes = null;
        LinkedList<Route> downList = new LinkedList<Route>();
        PostOfficeHub postOfficeHub = this;
        synchronized (postOfficeHub) {
            this.fRouteTransports.remove(transport);
            Route[] routeArray = routes = this.fRouteTable.getRoutes();
            int n = routes.length;
            int n2 = 0;
            while (n2 < n) {
                Route route = routeArray[n2];
                if (route.getRouteTransport() == transport) {
                    downList.add(route);
                }
                ++n2;
            }
            for (Route route : downList) {
                this.fRouteTable.remove(route);
            }
        }
        transport.close();
        Route[] routeArray = routes = downList.toArray(new Route[0]);
        int n = routes.length;
        int n3 = 0;
        while (n3 < n) {
            Route route = routeArray[n3];
            if (this.getFeedbackChannel().isTraceEnabled(sModule)) {
                this.getFeedbackChannel().trace(sModule, "Route down: " + route);
            }
            this.removeRoute(route);
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTransportUp(IRouteTransport transport) {
        int n;
        Route[] routes = null;
        LinkedList<Route> upList = new LinkedList<Route>();
        PostOfficeHub postOfficeHub = this;
        synchronized (postOfficeHub) {
            this.fRouteTransports.add(transport);
            Route[] routeArray = routes = this.fRouteTable.getRoutes();
            int n2 = routes.length;
            n = 0;
            while (n < n2) {
                Route route = routeArray[n];
                if (route.getHops() <= 1) {
                    upList.add(route);
                }
                ++n;
            }
        }
        Route[] routeArray = routes = upList.toArray(new Route[0]);
        n = routes.length;
        int n3 = 0;
        while (n3 < n) {
            Route route = routeArray[n3];
            transport.routeUp(route);
            ++n3;
        }
        if (this.getFeedbackChannel().isDebugEnabled(sModule)) {
            this.getFeedbackChannel().debug(sModule, "Transport up: " + transport);
        }
        if (this.fIsGlobalRegistryOwner) {
            Assertion.wilyAssert(this.fRegistryAddress != null);
            transport.sendMessage(new RegistryAvailableMessage(this.fRegistryAddress), new Address(this));
        }
        transport.sendMessage(new AckMessage(), new Address(this));
        if (!(transport instanceof LoopbackTransport) && this.getFeedbackChannel().isVerboseEnabled(sModule)) {
            this.getFeedbackChannel().verbose(sModule, "Connected To: " + transport.getRouteConnectionInfo());
        }
    }

    public void notifyMessageReceived(AMessage message, Address destination, IRouteTransport routeTransport) {
        if (message instanceof ARoutingMessage) {
            this.onRoutingMessage(routeTransport, (ARoutingMessage)message);
        } else {
            try {
                this.routeMessage(message, destination);
            }
            catch (Exception e) {
                this.getFeedbackChannel().error(sModule, "Failed to route message: " + message.toString(destination), e);
            }
        }
    }

    public IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }

    private void onRoutingMessage(IRouteTransport routeTransport, ARoutingMessage message) {
        if (message instanceof AddRouteMessage) {
            AddRouteMessage addRouteMessage = (AddRouteMessage)message;
            this.addRoute(addRouteMessage.getPostOffice(), routeTransport, addRouteMessage.getHops() + 1);
        } else if (message instanceof RemoveRouteMessage) {
            PostOfficeSpecifier removedPO = ((RemoveRouteMessage)message).getPostOffice();
            Route theRoute = this.fRouteTable.getRoute(removedPO);
            if (theRoute != null) {
                this.removeRoute(theRoute);
            }
        } else if (message instanceof AckMessage) {
            if (this.fConnectionLatch != null) {
                this.fConnectionLatch.countDown();
            }
        } else if (message instanceof RegistryAvailableMessage) {
            this.fRegistryAddress = ((RegistryAvailableMessage)message).getAddress();
        } else {
            this.getFeedbackChannel().error(sModule, "Unknown routing message: " + message);
            Assertion.wilyAssert(false, "Unknown routing message: " + message);
        }
    }

    public void debug_dropRemoteConnection() {
        this.closeOutgoingConnections();
    }

    private void closeOutgoingConnections() {
        if (this.fOutgoingConnection != null) {
            this.fOutgoingConnection.close();
        }
    }

    public Executor getAsyncExecutor() {
        return this.fAsyncExecutionQueue;
    }

    public Executor getExceptionAsyncExecutor() {
        return this.fExceptionAsyncExecutionQueue;
    }

    public Executor getRouteDownExecutor() {
        return this.fRouteDownQueue;
    }

    public ClassLoaderManager getClassLoaderManager() {
        return this.fClassLoaderManager;
    }

    @Deprecated
    public Map<ClassLoader, String> getRegisteredClassLoaders() {
        return this.fClassLoaderManager.getRegisteredClassLoaders();
    }

    public IKeyedClassLoader getKeyedClassLoader() {
        return this.fClassLoaderManager.getKeyedClassLoader();
    }

    @Deprecated
    public Map<String, ClassLoader> getRegisteredClassLoadersByClassName() {
        return this.fClassLoaderManager.getRegisteredClassLoadersByClassName();
    }

    public void registerClassLoader(ClassLoader loader, String loaderName) {
        this.fClassLoaderManager.registerClassLoader(loader, loaderName);
    }

    public void unregisterClassLoader(ClassLoader loader, String loaderName) {
        this.fClassLoaderManager.unregisterClassLoader(loader, loaderName);
    }

    public void addKeyedClassLoader(IKeyedClassLoader clMap) {
        this.fClassLoaderManager.addKeyedClassLoader(clMap);
    }

    public void removeKeyedClassLoader(IKeyedClassLoader clMap) {
        this.fClassLoaderManager.removeKeyedClassLoader(clMap);
    }

    public IRegistryServiceLocal getLocalRegistry() {
        return this.fLocalRegistry;
    }

    public synchronized void incrementCorruptedMessageCount() {
        ++this.fCorruptedMessageCount;
    }

    public synchronized int getCorruptedMessageCount() {
        return this.fCorruptedMessageCount;
    }

    public Map<String, Integer> getSupportabilityMetricsValues() {
        HashMap<String, Integer> map = new HashMap<String, Integer>(3);
        map.put("Async Exection Queue Length", new Integer(this.fAsyncExecutionQueueInternal.size()));
        map.put("Route Down Queue Length", new Integer(this.fRouteDownQueueInternal.size()));
        map.put("Exception Async Exection Queue Length", new Integer(this.fExceptionAsyncExecutionQueueInternal.size()));
        return map;
    }

    private class RouteDown
    implements Runnable {
        private Route fRoute;
        private IRouteTransport[] fCurrentRoute;

        public RouteDown(Route route, IRouteTransport[] currentRoute) {
            this.fRoute = route;
            this.fCurrentRoute = currentRoute;
        }

        @Override
        public void run() {
            if (this.fCurrentRoute != null) {
                IRouteTransport[] iRouteTransportArray = this.fCurrentRoute;
                int n = this.fCurrentRoute.length;
                int n2 = 0;
                while (n2 < n) {
                    IRouteTransport iRouteTransport = iRouteTransportArray[n2];
                    if (this.fRoute.getRouteTransport() != iRouteTransport) {
                        if (PostOfficeHub.this.getFeedbackChannel().isDebugEnabled(sModule)) {
                            PostOfficeHub.this.getFeedbackChannel().debug(sModule, "Notifying transport " + iRouteTransport + " that route " + this.fRoute + " is down");
                        }
                        iRouteTransport.routeDown(this.fRoute);
                    }
                    ++n2;
                }
            }
            if (PostOfficeHub.this.fNotification != null) {
                PostOfficeHub.this.fNotification.postOfficeRemoved(this.fRoute.getPostOffice());
            }
        }
    }
}

