/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.blame;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.ISamplingStack;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.concurrent.atomic.AtomicInteger;

public final class TracerSamplingHelper {
    private IAgent fAgent;
    private static final String kSamplingMaxRateProperty = "introscope.agent.tracer.sampling.maxrate";
    private static final String kSamplingInitialPeriodProperty = "introscope.agent.tracer.sampling.initial.period";
    private static final String kSamplingResetPeriodProperty = "introscope.agent.tracer.sampling.reset.period";
    private static final int kSamplingMaxRateDefault = 10;
    private static final int kSamplingInitialPeriodDefault = 100;
    private static final int kSamplingResetPeriodDefault = 10000;
    private static volatile int sSamplingMaxRate = 10;
    private static volatile int sSamplingInitialPeriod = 100;
    private static volatile int sSamplingResetPeriod = 10000;
    private static AtomicInteger sSamplingCounter = new AtomicInteger(0);
    private Module fModule;
    private IModuleFeedbackChannel fFeedback;

    public TracerSamplingHelper(IAgent agent) {
        this.fAgent = agent;
        ConfigurationManager cm = this.fAgent.IAgent_getConfigurationManager();
        this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
        this.fModule = this.fAgent.IAgent_getModule();
        IStringLocalizer localizer = this.fAgent.IAgent_getStringLocalizer();
        cm.add(new PositiveIntegerConfigurationProperty(kSamplingMaxRateProperty, 10, this.fFeedback, this.fModule, localizer){

            @Override
            public void set(Object value) {
                sSamplingMaxRate = (Integer)value;
                sSamplingCounter.set(0);
            }
        });
        cm.add(new PositiveIntegerConfigurationProperty(kSamplingInitialPeriodProperty, 100, this.fFeedback, this.fModule, localizer){

            @Override
            public void set(Object value) {
                sSamplingInitialPeriod = (Integer)value;
                sSamplingCounter.set(0);
            }
        });
        cm.add(new PositiveIntegerConfigurationProperty(kSamplingResetPeriodProperty, 10000, this.fFeedback, this.fModule, localizer){

            @Override
            public void set(Object value) {
                sSamplingResetPeriod = (Integer)value;
                sSamplingCounter.set(0);
            }
        });
    }

    public boolean getSamplingSkipFlag(IBlameStack stack) {
        if (stack instanceof ISamplingStack) {
            ISamplingStack ss = (ISamplingStack)((Object)stack);
            return ss.getSetSamplingSkipFlag();
        }
        return false;
    }

    public void setSamplingSkipFlag(IBlameStack stack, boolean flag) {
        if (stack instanceof ISamplingStack) {
            ISamplingStack ss = (ISamplingStack)((Object)stack);
            ss.setSetSamplingSkipFlag(flag);
        }
    }

    public boolean checkSamplingCounter() {
        if (sSamplingMaxRate == 0) {
            return false;
        }
        int samplingRate = 1;
        if (sSamplingCounter.get() > sSamplingResetPeriod) {
            sSamplingCounter.set(0);
        }
        sSamplingCounter.incrementAndGet();
        if (sSamplingCounter.get() <= sSamplingInitialPeriod) {
            samplingRate = 1;
        } else if (sSamplingCounter.get() <= 2 * sSamplingInitialPeriod) {
            samplingRate = sSamplingMaxRate * (sSamplingCounter.get() - sSamplingInitialPeriod) / sSamplingInitialPeriod;
            if (samplingRate < 1) {
                samplingRate = 1;
            }
        } else {
            samplingRate = sSamplingMaxRate;
        }
        if (sSamplingCounter.get() % samplingRate != 0) {
            return true;
        }
        if (this.fFeedback.isDebugEnabled(this.fModule)) {
            this.fFeedback.debug(this.fModule, "Tracer Sampling Counter is " + sSamplingCounter.get() + ", current rate is " + samplingRate);
        }
        return false;
    }

    public void resetSamplingCounter() {
        sSamplingCounter.set(0);
    }

    public boolean setSamplingTracer(InvocationData data, int tracerIndex) {
        return data.setSamplingTracer(tracerIndex);
    }
}

