/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transactiontrace.ASamplingFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.IConfigurationListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class URLSamplingTransactionTraceFilter
extends ASamplingFilter {
    private long fSamplingPeriodInMillis;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private boolean fUseRandomization;
    private boolean fSamplingEnabled;
    private final Random random = new Random();
    private ThreadLocal fCollect = new ThreadLocal(){

        public Object initialValue() {
            return Boolean.FALSE;
        }
    };
    private static Set[] urlSet = new Set[16];
    private static final int kUrlSetListSize = 16;
    private static final int kUrlSetListBitField = 15;
    private static URLMapCleaner fURLMapCleaner;
    public static final int kDefaultSamplingPeriodInSeconds = 3600;
    private IAgent fAgent;
    private IConfigurationListener fChangeListener;

    public URLSamplingTransactionTraceFilter(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IAgent agent) {
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fAgent = agent;
        IndexedProperties indexedProperties = agent.IAgent_getIndexedProperties();
        this.fSamplingEnabled = indexedProperties.safeGetBooleanProperty("introscope.agent.transactiontracer.sampling.enabled", true, this.fFeedback, this.fLocalizer);
        if (this.fSamplingEnabled) {
            this.initialize(indexedProperties);
        }
        this.fChangeListener = new IConfigurationListener(){

            @Override
            public void onChange(IndexedProperties props) {
                URLSamplingTransactionTraceFilter.this.checkForSamplingEnablingChanges(props);
                URLSamplingTransactionTraceFilter.this.checkForSamplingPeriodChanges(props);
            }
        };
        this.fAgent.addConfigurationListener(this.fChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForSamplingEnablingChanges(IndexedProperties props) {
        boolean samplingEnabled = props.safeGetBooleanProperty("introscope.agent.transactiontracer.sampling.enabled", true, this.fFeedback, this.fLocalizer);
        if (samplingEnabled != this.fSamplingEnabled) {
            this.fSamplingEnabled = samplingEnabled;
            if (samplingEnabled) {
                this.initialize(props);
                this.fAgent.IAgent_getModuleFeedback().info("Url Sampling has been enabled");
            } else {
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    fURLMapCleaner = null;
                }
                this.fAgent.IAgent_getModuleFeedback().info("Url Sampling has been disabled");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForSamplingPeriodChanges(IndexedProperties props) {
        long newSamplingPeriod = props.safeGetPositiveIntProperty("introscope.agent.transactiontracer.sampling.periodinseconds", 3600, this.fAgent.IAgent_getModuleFeedback(), this.fAgent.IAgent_getStringLocalizer()) * 1000;
        if (this.fSamplingPeriodInMillis != newSamplingPeriod) {
            this.fSamplingPeriodInMillis = newSamplingPeriod;
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (fURLMapCleaner != null) {
                    URLSamplingTransactionTraceFilter.fURLMapCleaner.fBehavior.IRegisteredBehavior_setPeriod(this.fSamplingPeriodInMillis);
                }
            }
            this.fAgent.IAgent_getModuleFeedback().info("Url Sampling period has been updated to " + this.fSamplingPeriodInMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(IndexedProperties indexedProperties) {
        this.fUseRandomization = indexedProperties.safeGetBooleanProperty("introscope.agent.transactiontracer.sampling.randomize", true, this.fFeedback, this.fLocalizer);
        this.fSamplingPeriodInMillis = indexedProperties.safeGetPositiveIntProperty("introscope.agent.transactiontracer.sampling.periodinseconds", 3600, this.fFeedback, this.fLocalizer) * 1000;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (fURLMapCleaner == null) {
                fURLMapCleaner = new URLMapCleaner(this.fAgent, this.fSamplingPeriodInMillis);
            }
        }
    }

    private int getIndex(Object key) {
        int index = 0;
        if (key != null) {
            index = key.hashCode() & 0xF;
        }
        return index;
    }

    private Set getURLSet(Object key) {
        return urlSet[this.getIndex(key)];
    }

    @Override
    public int ITransactionTraceFilter_getFilterType() {
        return -1;
    }

    @Override
    public boolean ITransactionTraceFilter_passesFilter(TransactionComponentData root) {
        return this.fSamplingEnabled && (Boolean)this.fCollect.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldCollect(Map parameters) {
        Set vector;
        if (!this.fSamplingEnabled) {
            return false;
        }
        String URLName = (String)parameters.get("Normalized URL");
        if (URLName == null) {
            this.fCollect.set(Boolean.FALSE);
            return false;
        }
        int rand = this.random.nextInt(10);
        if (this.fUseRandomization && rand != 3) {
            this.fCollect.set(Boolean.FALSE);
            return false;
        }
        Set set = vector = this.getURLSet(URLName);
        synchronized (set) {
            if (vector.contains(URLName)) {
                this.fCollect.set(Boolean.FALSE);
                return false;
            }
            vector.add(URLName);
            this.fCollect.set(Boolean.TRUE);
            return true;
        }
    }

    public void setDefaultSamplingPeriod(long samplingPeriodInMillis) {
        if (fURLMapCleaner != null) {
            fURLMapCleaner.setNewSamplingPeriod(samplingPeriodInMillis);
        }
    }

    @Override
    public String ITransactionTraceFilter_getLocalizedDescription(IStringLocalizer localizer) {
        return null;
    }

    @Override
    public void ITransactionTraceFilter_write(DataOutput out) throws IOException {
    }

    @Override
    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer) {
        return null;
    }

    @Override
    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer, Locale locale) {
        return null;
    }

    @Override
    public boolean isHeadFilter() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSingleEntry(String URLName) {
        if (this.fSamplingEnabled) {
            Set localUrlSet;
            Set set = localUrlSet = this.getURLSet(URLName);
            synchronized (set) {
                localUrlSet.remove(URLName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug_clearAll() {
        for (int i = 0; i < urlSet.length; ++i) {
            Set set = urlSet[i];
            synchronized (set) {
                urlSet[i].clear();
                continue;
            }
        }
    }

    public void debug_setRandomization(boolean b) {
        this.fUseRandomization = b;
    }

    static {
        for (int i = 0; i < 16; ++i) {
            URLSamplingTransactionTraceFilter.urlSet[i] = new HashSet();
        }
    }

    private static class URLMapCleaner
    implements ITimestampedRunnable {
        public IRegisteredBehavior fBehavior;
        private IAgent fAgent;

        public URLMapCleaner(IAgent agent, long samplingPeriod) {
            this.fAgent = agent;
            this.fBehavior = agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)this, "URLMapCleaner", true, samplingPeriod, true);
        }

        public void setNewSamplingPeriod(long samplingPeriod) {
            this.fAgent.IAgent_getCommonHeartbeat().removeBehavior(this.fBehavior);
            this.fBehavior = this.fAgent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)this, "URLMapCleaner", true, samplingPeriod, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            for (int i = 0; i < urlSet.length; ++i) {
                Set set = urlSet[i];
                synchronized (set) {
                    urlSet[i].clear();
                    continue;
                }
            }
        }
    }
}

