/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt.primitive;

import com.wily.util.adt.primitive.IntSetEntry;
import com.wily.util.adt.primitive.PrimitiveIntSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IntHashSet
implements PrimitiveIntSet,
Serializable {
    private static final long serialVersionUID = 6209377165100253810L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient IntSetEntry[] table;
    private transient int size;
    private int threshold;
    private final float loadFactor;

    public IntHashSet(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        int capacity = 1;
        while (capacity < initialCapacity) {
            capacity <<= 1;
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new IntSetEntry[capacity];
    }

    public IntHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashSet() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new IntSetEntry[16];
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        IntSetEntry[] intSetEntryArray = this.table;
        int n = this.table.length;
        int n2 = 0;
        while (n2 < n) {
            IntSetEntry vEntry;
            IntSetEntry e = vEntry = intSetEntryArray[n2];
            while (e != null) {
                int key = e.val;
                buf.append(key).append(",");
                e = e.next;
            }
            ++n2;
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(int val) {
        int i = val & this.table.length - 1;
        IntSetEntry e = this.table[i];
        while (e != null) {
            if (val == e.val) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    @Override
    public boolean add(int val) {
        int i = val & this.table.length - 1;
        IntSetEntry e = this.table[i];
        while (e != null) {
            if (val == e.val) {
                return false;
            }
            e = e.next;
        }
        this.addEntry(val, i);
        return true;
    }

    private void putForCreate(int val) {
        int i = val & this.table.length - 1;
        IntSetEntry e = this.table[i];
        while (e != null) {
            if (val == e.val) {
                return;
            }
            e = e.next;
        }
        this.createEntry(val, i);
    }

    private void resize(int newCapacity) {
        IntSetEntry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        IntSetEntry[] newTable = new IntSetEntry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    private void transfer(IntSetEntry[] newTable) {
        IntSetEntry[] src = this.table;
        int newCapacity = newTable.length;
        int j = 0;
        while (j < src.length) {
            IntSetEntry e = src[j];
            if (e != null) {
                IntSetEntry next;
                src[j] = null;
                do {
                    next = e.next;
                    int i = e.val & newCapacity - 1;
                    e.next = newTable[i];
                    newTable[i] = e;
                } while ((e = next) != null);
            }
            ++j;
        }
    }

    @Override
    public boolean remove(int val) {
        IntSetEntry e = this.removeEntryForKey(val);
        return e != null;
    }

    private IntSetEntry removeEntryForKey(int val) {
        IntSetEntry prev;
        int i = val & this.table.length - 1;
        IntSetEntry e = prev = this.table[i];
        while (e != null) {
            IntSetEntry next = e.next;
            if (val == e.val) {
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    @Override
    public void clear() {
        IntSetEntry[] tab = this.table;
        int i = 0;
        while (i < tab.length) {
            tab[i] = null;
            ++i;
        }
        this.size = 0;
    }

    private void addEntry(int val, int bucketIndex) {
        this.table[bucketIndex] = new IntSetEntry(val, this.table[bucketIndex]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    private void createEntry(int key, int bucketIndex) {
        this.table[bucketIndex] = new IntSetEntry(key, this.table[bucketIndex]);
        ++this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        int c = 0;
        int i = 0;
        while (c < this.size && i < this.table.length) {
            IntSetEntry e = this.table[i];
            while (e != null) {
                s.writeInt(e.val);
                e = e.next;
                ++c;
            }
            ++i;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new IntSetEntry[numBuckets];
        int size = s.readInt();
        int i = 0;
        while (i < size) {
            int key = s.readInt();
            this.putForCreate(key);
            ++i;
        }
    }

    @Override
    public Iterator<IntSetEntry> iterator() {
        return new IntHashSetEntryIterator();
    }

    private class IntHashSetEntryIterator
    implements Iterator<IntSetEntry> {
        int index = -1;
        IntSetEntry cur = null;
        IntSetEntry next = null;

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                while (++this.index < IntHashSet.this.table.length) {
                    this.next = IntHashSet.this.table[this.index];
                    if (this.next != null) break;
                }
            }
            return this.next != null;
        }

        @Override
        public IntSetEntry next() {
            if (this.next == null) {
                if (this.hasNext()) {
                    return this.next();
                }
                throw new NoSuchElementException("No more entries");
            }
            this.cur = this.next;
            this.next = this.next.next;
            this.hasNext();
            return this.cur;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void remove() {
            block1: {
                if (this.index <= -1 || this.index >= IntHashSet.access$0(IntHashSet.this).length) break block1;
                curNode = IntHashSet.access$0(IntHashSet.this)[this.index];
                prev = null;
                if (this.cur == null) break block1;
                if (curNode != this.cur) ** GOTO lbl14
                IntHashSet.access$0((IntHashSet)IntHashSet.this)[this.index] = this.cur.next;
                return;
lbl-1000:
                // 1 sources

                {
                    prev = curNode;
                    curNode = curNode.next;
                    if (curNode != this.cur) continue;
                    prev.next = curNode.next;
                    this.cur = null;
                    break;
lbl14:
                    // 2 sources

                    ** while (curNode != null)
                }
            }
        }
    }
}

