/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extension.deployer;

import com.wily.introscope.agent.extension.deployer.DeploymentLock;
import com.wily.introscope.agent.extension.deployer.DeploymentManager;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.resource.IResource;
import com.wily.util.resource.IResourceWriter;
import com.wily.util.resource.InvalidResourceException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ProfileWriter {
    private final DeploymentManager fManager;
    private final Module kModule;
    private final IModuleFeedbackChannel fFeedback;
    private IResource fExtensionProfileResource;

    public ProfileWriter(DeploymentManager manager) {
        this.fManager = manager;
        this.kModule = this.fManager.getModule();
        this.fFeedback = this.fManager.getFeedback();
        this.fExtensionProfileResource = manager.getExtensionProfileResource();
    }

    private String createListLine(String key, Set<String> values) {
        StringBuilder line = new StringBuilder(key);
        line.append("=");
        boolean firstExtension = true;
        Iterator<String> it = values.iterator();
        while (it.hasNext()) {
            if (!firstExtension) {
                line.append(",");
            }
            firstExtension = false;
            line.append(it.next());
        }
        return line.toString();
    }

    private Set<String> readList(String line) {
        HashSet<String> result = new HashSet<String>();
        int index = line.indexOf("=");
        if (index >= 0) {
            line = line.substring(index + 1);
            String[] items = line.split(",");
            for (int i = 0; i < items.length; ++i) {
                String item = items[i].trim();
                if (item.length() <= 0) continue;
                result.add(item);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProfile(Set<String> hotExtensions, Set<String> coldExtensions, boolean addTo) {
        DeploymentLock deploymentLock = this.fManager.getProfileLock();
        synchronized (deploymentLock) {
            try {
                String line;
                this.fManager.getProfileLock().acquireExclusiveLock();
                InputStream in = this.fExtensionProfileResource.IResource_getContents();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                ArrayList<String> lines = new ArrayList<String>(20);
                boolean includesLineFound = false;
                boolean bootLoadLineFound = false;
                boolean fileChanged = false;
                while ((line = reader.readLine()) != null) {
                    String newline;
                    Set<String> list;
                    if (line.startsWith("introscope.agent.extensions.bundles.load")) {
                        list = this.readList(line);
                        if (addTo) {
                            list.addAll(hotExtensions);
                        } else {
                            list.removeAll(hotExtensions);
                        }
                        newline = this.createListLine("introscope.agent.extensions.bundles.load", list);
                        if (!line.equals(newline)) {
                            line = newline;
                            fileChanged = true;
                        }
                        includesLineFound = true;
                    }
                    if (line.startsWith("introscope.agent.extensions.bundles.boot.load")) {
                        list = this.readList(line);
                        if (addTo) {
                            list.addAll(coldExtensions);
                        } else {
                            list.removeAll(coldExtensions);
                        }
                        newline = this.createListLine("introscope.agent.extensions.bundles.boot.load", list);
                        if (!line.equals(newline)) {
                            line = newline;
                            fileChanged = true;
                        }
                        bootLoadLineFound = true;
                    }
                    lines.add(line);
                }
                if (addTo && !includesLineFound) {
                    lines.add(this.createListLine("introscope.agent.extensions.bundles.load", hotExtensions));
                    fileChanged = true;
                }
                if (addTo && !bootLoadLineFound) {
                    lines.add(this.createListLine("introscope.agent.extensions.bundles.boot.load", coldExtensions));
                    fileChanged = true;
                }
                reader.close();
                in.close();
                if (!fileChanged) {
                    return;
                }
                IResourceWriter resource = this.fExtensionProfileResource.IResource_getResourceWriter();
                OutputStream out = resource.IResourceWriter_getResource(this.fExtensionProfileResource.IResource_getLocation());
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
                Iterator it = lines.iterator();
                while (it.hasNext()) {
                    writer.write((String)it.next());
                    writer.newLine();
                }
                writer.close();
                out.close();
                this.fFeedback.info(this.kModule, "Successfully updated the profile file in " + this.fExtensionProfileResource.IResource_getLocation());
            }
            catch (InvalidResourceException e) {
                this.fFeedback.error(this.kModule, "Cannot write the profile file in " + this.fExtensionProfileResource.IResource_getLocation() + " : " + e.getMessage());
                if (this.fFeedback.isDebugEnabled(this.kModule)) {
                    this.fFeedback.debug(this.kModule, "Cannot write the profile file in", (Throwable)e);
                }
            }
            catch (IOException e) {
                this.fFeedback.error(this.kModule, "Cannot write the profile file in " + this.fExtensionProfileResource.IResource_getLocation() + " : " + e.getMessage());
                if (this.fFeedback.isDebugEnabled(this.kModule)) {
                    this.fFeedback.debug(this.kModule, "Cannot write the profile file in", (Throwable)e);
                }
            }
            finally {
                this.fManager.getProfileLock().releaseLock();
            }
        }
    }
}

