/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.connection.PlatformReportingQueue;
import com.wily.introscope.agent.connection.PlatformServerConnectionManager;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;

class PlatformHarvestThread
implements Runnable {
    private static final Module sModule = new Module("PlatformHarvestThread");
    private final PlatformServerConnectionManager fServerConnectionManager;
    private final IModuleFeedbackChannel fFeedback;
    private final PlatformReportingQueue fQueue;
    private int fTimesliceType = 0;

    public PlatformHarvestThread(PlatformServerConnectionManager connectionManager, PlatformReportingQueue queue, ConfigurationManager configurationManager) {
        this.fServerConnectionManager = connectionManager;
        this.fFeedback = connectionManager.getFeedbackChannel();
        this.fQueue = queue;
    }

    @Override
    public void run() {
        while (true) {
            this.harvest();
        }
    }

    private void harvest() {
        try {
            boolean keepHarvesting = true;
            while (keepHarvesting) {
                long sleepTime;
                long startTime = MasterClock.currentTimeMillis();
                if (this.shouldHarvest()) {
                    this.fFeedback.debug(sModule, "Harvesting slice type: " + this.fTimesliceType);
                    keepHarvesting = this.getServerConnectionManager().harvest(this.fTimesliceType, this.shouldHarvestTraces());
                    if (this.fTimesliceType == 0) {
                        this.fTimesliceType = 1;
                    } else if (this.fTimesliceType == 1) {
                        this.fTimesliceType = 2;
                    }
                }
                if ((sleepTime = this.getServerConnectionManager().getAgentHarvestTimeMillis() - (MasterClock.currentTimeMillis() - startTime)) < 1L) {
                    sleepTime = 1L;
                } else if (sleepTime > this.getServerConnectionManager().getAgentHarvestTimeMillis()) {
                    sleepTime = this.getServerConnectionManager().getAgentHarvestTimeMillis();
                }
                Thread.sleep(sleepTime);
            }
        }
        catch (Throwable t) {
            this.getFeedbackChannel().debug(sModule, "PlatformHarvestThread caught throwable while harvesting data", t);
        }
    }

    private boolean shouldHarvest() {
        boolean shouldHarvest = this.fQueue.isEnqueuingCommands();
        if (shouldHarvest && this.fTimesliceType == 2 && this.fQueue.isWaitingForInitialTimeSlice()) {
            this.fTimesliceType = 0;
        }
        return shouldHarvest;
    }

    private boolean shouldHarvestTraces() {
        return this.getServerConnectionManager().isConnected();
    }

    private PlatformServerConnectionManager getServerConnectionManager() {
        return this.fServerConnectionManager;
    }

    private IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }
}

