/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.IUpdater;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;

public class ListSharedDataStructure
implements IRepository {
    private volatile boolean fShutOff = false;
    private final ConcurrentLinkedQueue offeredUpdates = new ConcurrentLinkedQueue();
    private final AtomicReference sharedValue = new AtomicReference();
    private final ISharedElement kInstancer;

    public ListSharedDataStructure(ISharedElement instance) {
        this.kInstancer = instance;
        this.reset();
    }

    public ListSharedDataStructure() {
        this(null);
    }

    @Override
    public void offer(ISharedElement offered) {
        ISharedElement other;
        while ((other = (ISharedElement)this.offeredUpdates.poll()) != null) {
            offered.merge(other);
        }
        this.offeredUpdates.add(offered);
        this.sharedValue.set(offered);
    }

    public String toString() {
        return Thread.currentThread().getName() + " value = " + this.sharedValue.get();
    }

    @Override
    public ISharedElement get() {
        ISharedElement result = (ISharedElement)this.offeredUpdates.poll();
        if (result == null) {
            return this.kInstancer.getSharedElementInstance();
        }
        return result;
    }

    @Override
    public ISharedElement read(ISharedElement result) {
        ISharedElement current = this.sharedValue.getAndSet(this.kInstancer.getSharedElementInstance());
        result.merge(current);
        return result;
    }

    @Override
    public ISharedElement read() {
        ISharedElement result = (ISharedElement)this.sharedValue.get();
        this.reset();
        return result;
    }

    @Override
    public void reset() {
        this.sharedValue.set(this.kInstancer.getSharedElementInstance());
    }

    @Override
    public void update(IUpdater updater, long value, long startTime, int hashcode) {
        ISharedElement element = this.get();
        updater.update(element, value, startTime);
        this.offer(element);
    }

    @Override
    public boolean hasNotChanged() {
        return false;
    }

    @Override
    public void update(IUpdater updater, long value, long startTime, long endTime) {
        this.update(updater, value, startTime, 0);
    }

    @Override
    public ISharedElement read(IRepository.IRepositorySustainabilityCallback callback) {
        return this.read();
    }

    @Override
    public boolean shouldBeHarvested() {
        return true;
    }

    @Override
    public void cleanup(boolean offerBack) {
        if (offerBack) {
            this.offeredUpdates.clear();
        } else {
            this.reset();
        }
    }

    @Override
    public void setShutOff(boolean shutOff) {
        this.fShutOff = shutOff;
    }

    @Override
    public boolean isShutOff() {
        return this.fShutOff;
    }
}

