/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.HostSetConfigurationProperty;
import com.wily.util.properties.hot.IntegerSetConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class ChannelConfiguration {
    private static final ChannelConfiguration instance = new ChannelConfiguration();
    public static final int DATAGRAM_CLIENT_HOSTS = 0;
    public static final int SOCKET_CLIENT_HOSTS = 1;
    public static final int DATAGRAM_CLIENT_PORTS = 2;
    public static final int DATAGRAM_SERVER_PORTS = 3;
    public static final int SOCKET_CLIENT_PORTS = 4;
    public static final int SOCKET_SERVER_PORTS = 5;
    private final String[] paramNames = new String[]{"introscope.agent.nio.datagram.client.hosts", "introscope.agent.nio.socket.client.hosts", "introscope.agent.nio.datagram.client.ports", "introscope.agent.nio.datagram.server.ports", "introscope.agent.nio.socket.client.ports", "introscope.agent.nio.socket.server.ports"};
    private final String[] paramDescriptions = new String[]{"NIO_Datagram_Client_Hosts", "NIO_Socket_Client_Hosts", "NIO_Datagram_Client_Ports", "NIO_Datagram_Server_Ports", "NIO_Socket_Client_Ports", "NIO_Socket_Server_Ports"};
    private final AtomicReferenceArray<Set<Object>> paramSets = new AtomicReferenceArray(6);

    public static ChannelConfiguration getChannelConfiguration(IAgent agent) {
        return instance;
    }

    private ChannelConfiguration() {
        for (int i = 0; i < 3; ++i) {
            this.paramSets.set(i, null);
        }
    }

    public static void setAgent(IAgent agent) {
        instance.setAgentInternal(agent);
    }

    private void setAgentInternal(IAgent agent) {
        int i;
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        Module module = agent.IAgent_getModule();
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = agent.IAgent_getStringLocalizer();
        for (i = 0; i < 2; ++i) {
            cm.add(new ChannelHostSetConfigurationProperty(i, this.paramNames[i], this.paramDescriptions[i], feedback, module, localizer), true);
        }
        for (i = 2; i < 6; ++i) {
            cm.add(new ChannelIntegerSetConfigurationProperty(i, this.paramNames[i], this.paramDescriptions[i], feedback, module, localizer), true);
        }
    }

    public boolean isRequired(int i, Object o) {
        Set<Object> required = null;
        required = this.paramSets.get(i);
        if (required == null || required.size() == 0) {
            return true;
        }
        return required.contains(o);
    }

    private final class ChannelIntegerSetConfigurationProperty
    extends IntegerSetConfigurationProperty {
        private final int setIndex;

        private ChannelIntegerSetConfigurationProperty(int setIndex, String propName, String propDescription, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(propName, propDescription, feedback, module, localizer);
            this.setIndex = setIndex;
        }

        @Override
        public final void set(Object value) {
            Set cv = (Set)value;
            ChannelConfiguration.this.paramSets.set(this.setIndex, cv == null || cv.size() == 0 ? null : cv);
        }
    }

    private final class ChannelHostSetConfigurationProperty
    extends HostSetConfigurationProperty {
        private final int setIndex;

        private ChannelHostSetConfigurationProperty(int setIndex, String propName, String propDescription, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(propName, propDescription, feedback, module, localizer);
            this.setIndex = setIndex;
        }

        @Override
        public final void set(Object value) {
            Set cv = (Set)value;
            ChannelConfiguration.this.paramSets.set(this.setIndex, cv == null || cv.size() == 0 ? null : cv);
        }
    }
}

