/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.extension.IExtension;
import com.wily.util.extension.IPlugin;
import com.wily.util.extension.InvalidExtensionException;
import com.wily.util.extension.KExtensionConstants;
import com.wily.util.extension.Plugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.MultipleResourceBundleStringLocalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;

public abstract class AExtension
implements IExtension {
    private Attributes fAttributeMap;
    private String fName;
    private String fURL;
    private List<IExtension.IExtensionCallback> fCallbacks;

    protected void initialize(String extensionURL, Attributes attributeMap) throws InvalidExtensionException {
        block3: {
            this.fAttributeMap = attributeMap;
            this.fURL = extensionURL;
            this.fCallbacks = new ArrayList<IExtension.IExtensionCallback>();
            try {
                this.fName = this.getMainAttributeValueOrThrow("com-wily-Extension-Name");
            }
            catch (InvalidExtensionException e) {
                this.fName = this.getMainAttributeValue("Bundle-SymbolicName");
                if (this.fName == null) {
                    this.fName = this.getMainAttributeValue("Bundle-Name");
                }
                if (this.fName != null) break block3;
                throw e;
            }
        }
    }

    protected String getMainAttributeValueOrThrow(String key) throws InvalidExtensionException {
        String value = this.fAttributeMap.getValue(key);
        if (value == null) {
            throw new InvalidExtensionException(new FormattedLocalizableMessage("Extension_Missing_Required_Manifest_Attribute_Message", new String[]{this.fName, this.fURL, key}));
        }
        return value;
    }

    protected String getMainAttributeValue(String key) {
        String value = this.fAttributeMap.getValue(key);
        return value;
    }

    protected int getValidatedVersion() throws InvalidExtensionException {
        int result;
        String value = this.getMainAttributeValueOrThrow("com-wily-Extension-Version");
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidExtensionException("invalid extension version: " + value, (ILocalizableMessage)new FormattedLocalizableMessage("Extension_Invalid_Extension_Version_Message", this.IExtension_getSource(), this.IExtension_getName(), value));
        }
        if (result != 1) {
            throw new InvalidExtensionException("unsupported extension version: " + result, (ILocalizableMessage)new FormattedLocalizableMessage("Extension_Unexpected_Extension_Version_Message", this.IExtension_getSource(), this.IExtension_getName(), String.valueOf(1), String.valueOf(result)));
        }
        return result;
    }

    protected List<IPlugin> buildPluginList(IExtension owningExtension, String pluginNames) throws InvalidExtensionException {
        ArrayList<IPlugin> result = new ArrayList<IPlugin>();
        List<String> pluginNameList = this.parseListStringIntoStringList(pluginNames);
        for (String s : pluginNameList) {
            Plugin plugin = new Plugin(this, this.fAttributeMap, s);
            result.add(plugin);
        }
        return result;
    }

    private List<String> parseListStringIntoStringList(String list) {
        ArrayList<String> bag = new ArrayList<String>();
        if (list != null) {
            StringTokenizer tokenizer = new StringTokenizer(list, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                bag.add(token);
            }
        }
        return bag;
    }

    protected MultipleResourceBundleStringLocalizer buildStringLocalizer(IModuleFeedbackChannel feedback, ClassLoader extensionClassloader, String resourceNames) {
        List<String> resourceList = this.parseListStringIntoStringList(resourceNames);
        return new MultipleResourceBundleStringLocalizer(feedback, extensionClassloader, resourceList.toArray(new String[0]), false);
    }

    protected IPlugin[] getFilteredPluginList(List<IPlugin> pluginList, String pluginFilter) {
        ArrayList<IPlugin> bag = new ArrayList<IPlugin>();
        for (IPlugin plugin : pluginList) {
            if (!plugin.IPlugin_getType().equals(pluginFilter)) continue;
            bag.add(plugin);
        }
        return bag.toArray(KExtensionConstants.kZeroLengthPluginArray);
    }

    @Override
    public void IExtension_setCallback(IExtension.IExtensionCallback cb) {
        this.fCallbacks.add(cb);
    }

    protected void loadPlugins(List<IPlugin> pluginList) {
        for (IPlugin plugin : pluginList) {
            plugin.IPlugin_load();
        }
    }

    protected void load() {
        for (IExtension.IExtensionCallback callback : this.fCallbacks) {
            callback.onLoad(this);
        }
    }

    protected void unloadPlugins(List<IPlugin> pluginList) {
        for (IPlugin plugin : pluginList) {
            plugin.IPlugin_unload();
        }
    }

    protected void unload() {
        for (IExtension.IExtensionCallback callback : this.fCallbacks) {
            callback.onUnload(this);
        }
    }
}

