/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.util;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class PBDParseHelper {
    private static final String kDelimiter = "[\\s]+";

    private static StreamTokenizer getTokenizer(String directive) {
        StringReader reader = new StringReader(directive);
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        PBDParseHelper.initializeStream(tokenizer);
        return tokenizer;
    }

    public static String getKeyword(String directive) throws IOException {
        StreamTokenizer tokenizer = PBDParseHelper.getTokenizer(directive);
        String keyword = PBDParseHelper.getToken(tokenizer);
        return keyword;
    }

    private static void initializeStream(StreamTokenizer tokenizer) {
        tokenizer.resetSyntax();
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(160, 255);
        tokenizer.whitespaceChars(0, 32);
        tokenizer.quoteChar(34);
        tokenizer.quoteChar(39);
        tokenizer.commentChar(35);
        tokenizer.wordChars(47, 47);
        tokenizer.wordChars(92, 92);
        tokenizer.wordChars(46, 46);
        tokenizer.wordChars(58, 58);
        tokenizer.wordChars(95, 95);
        tokenizer.wordChars(45, 45);
        tokenizer.wordChars(48, 57);
        tokenizer.wordChars(60, 62);
        tokenizer.wordChars(36, 36);
        tokenizer.wordChars(43, 43);
        tokenizer.wordChars(96, 96);
        tokenizer.wordChars(40, 40);
        tokenizer.wordChars(41, 41);
        tokenizer.wordChars(47, 47);
        tokenizer.wordChars(59, 59);
        tokenizer.wordChars(91, 91);
        tokenizer.wordChars(93, 93);
        tokenizer.wordChars(44, 44);
        tokenizer.wordChars(33, 33);
        tokenizer.wordChars(38, 38);
        tokenizer.wordChars(42, 42);
        tokenizer.wordChars(123, 123);
        tokenizer.wordChars(125, 125);
    }

    private static String getToken(StreamTokenizer tokenizer) throws IOException {
        int tokenType = tokenizer.nextToken();
        if (tokenType == -3 || tokenType == 34 || tokenType == 39) {
            return tokenizer.sval;
        }
        if (tokenType != 10 && tokenType != -1) {
            String string = String.valueOf((char)tokenType);
        }
        return null;
    }

    public static String stripInitialHashes(String aString) {
        String anotherString = null;
        for (int i = 0; i < aString.length(); ++i) {
            if (aString.charAt(i) == '#') continue;
            anotherString = aString.substring(i);
        }
        return anotherString;
    }

    public static String removeMiddleSpacesFrom(String aString) {
        String[] temp = aString.split(kDelimiter);
        StringBuilder modified = new StringBuilder();
        for (int i = 0; i < temp.length; ++i) {
            modified.append(temp[i]);
            modified.append(" ");
        }
        return modified.toString();
    }
}

