/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizdef.operations;

import com.wily.introscope.agent.bizdef.BizDefEncapsulatedPattern;
import com.wily.introscope.agent.bizdef.IBizOperationType;
import com.wily.introscope.agent.bizdef.adt.CaseSensitiveMap;
import com.wily.introscope.agent.bizdef.operations.BizNotEqualOperation;
import com.wily.introscope.agent.bizdef.operations.IBizAction;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BizSimpleMatchValueOperation
implements IBizAction {
    private final String fName = "SIMPLE_MATCH_VALUE_OPERATION";
    private static ThreadLocal sPatterns = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    private IBizOperationType fType;

    private static void reinitializePatternMap() {
        sPatterns = new ThreadLocal(){

            protected Object initialValue() {
                return new HashMap();
            }
        };
    }

    public BizSimpleMatchValueOperation(IBizOperationType type) {
        this.fType = type;
    }

    @Override
    public boolean matches(BizDefEncapsulatedPattern pattern, String value, boolean caseSensitiveValue) {
        if (pattern == null && value == null) {
            return false;
        }
        String patternString = pattern.getPattern();
        String valueString = value;
        if (!caseSensitiveValue) {
            patternString = pattern.getLowercaseOnlyPattern();
            valueString = valueString.toLowerCase();
        }
        if (patternString.indexOf("*") < 0) {
            return valueString.equals(patternString);
        }
        patternString = caseSensitiveValue ? pattern.getReplacedEscapedPattern() : pattern.getLowerCaseReplacedEscapedPattern();
        Pattern patternMatcher = BizSimpleMatchValueOperation.getPattern(patternString);
        if (patternMatcher != null) {
            Matcher matcher = patternMatcher.matcher(valueString);
            return matcher.matches();
        }
        return false;
    }

    @Override
    public boolean matches(Object parameter, BizDefEncapsulatedPattern name, BizDefEncapsulatedPattern pattern, CaseSensitiveMap parameterMap, boolean caseSensitiveName, boolean caseSensitiveValue) {
        if (name != null && pattern != null && parameterMap != null) {
            boolean useRegex;
            String value = BizNotEqualOperation.findValue(parameter, name, parameterMap, caseSensitiveName, caseSensitiveValue);
            if (value == null) {
                return false;
            }
            if (BizSimpleMatchValueOperation.paramValueExceedSize(value)) {
                return false;
            }
            String patternString = null;
            boolean bl = useRegex = pattern.getPattern().indexOf("*") >= 0;
            patternString = useRegex ? (!caseSensitiveValue ? pattern.getLowerCaseReplacedEscapedPattern() : pattern.getReplacedEscapedPattern()) : (!caseSensitiveValue ? pattern.getLowercaseOnlyPattern() : pattern.getPattern());
            if (!useRegex) {
                return value.equals(patternString);
            }
            Pattern patternMatcher = BizSimpleMatchValueOperation.getPattern(patternString);
            if (patternMatcher == null) {
                return false;
            }
            Matcher matcher = patternMatcher.matcher(value);
            return matcher.matches();
        }
        return false;
    }

    private String getLowercase(String value) {
        return value.toLowerCase();
    }

    @Override
    public IBizOperationType getType() {
        return this.fType;
    }

    private static Pattern getPattern(String patternValue) {
        HashMap map = (HashMap)sPatterns.get();
        Pattern pattern = (Pattern)map.get(patternValue);
        if (pattern != null) {
            return pattern;
        }
        pattern = Pattern.compile(patternValue);
        map.put(patternValue, pattern);
        return pattern;
    }

    private static String escapeUnsupportedRegexChars(String clearText) {
        StringBuilder result = new StringBuilder();
        for (int x = 0; x < clearText.length(); ++x) {
            char currentChar = clearText.charAt(x);
            if (BizSimpleMatchValueOperation.requiresUnsupportedEscape(currentChar)) {
                result.append("\\");
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    private static boolean requiresUnsupportedEscape(char inputCharacter) {
        switch (inputCharacter) {
            case '$': 
            case '&': 
            case '(': 
            case ')': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private static String replace(String source, String pattern, String replace) {
        if (source != null) {
            int len = pattern.length();
            StringBuilder sb = new StringBuilder();
            int found = -1;
            int start = 0;
            while ((found = source.indexOf(pattern, start)) != -1) {
                sb.append(source.substring(start, found));
                sb.append(replace);
                start = found + len;
            }
            sb.append(source.substring(start));
            return sb.toString();
        }
        return "";
    }

    private static boolean paramValueExceedSize(String value) {
        return value != null && value.length() > 10000;
    }

    public String toString() {
        return "SIMPLE_MATCH_VALUE_OPERATION";
    }

    public boolean equals(Object arg0) {
        return this.toString().equals(arg0.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

