/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.bytecode;

import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.personality.java.classfile.attributes.DGCode;
import com.wily.diagnos.personality.java.classfile.bytecode.DGByteCode;
import com.wily.wilyassert.Assertion;
import java.io.IOException;

public class MethodStubbingByteCode
extends DGByteCode {
    protected int fLocalThisStorage;
    protected int fCPIShouldStubMethod;
    public int fLocal_tracer;
    public int fLocal_stubbool;
    private boolean fIsConstructor;

    public MethodStubbingByteCode(int localThisStorage, int cpiShouldStubMethod, int localTracerStorage) throws DGClassModificationException, IOException {
        this.fLocalThisStorage = localThisStorage;
        this.fCPIShouldStubMethod = cpiShouldStubMethod;
        this.fLocal_tracer = localTracerStorage;
    }

    public void initialize(boolean shouldStub, DGCode methodCode) throws DGClassModificationException, IOException {
        if (this.fLocalThisStorage != -1) {
            Assertion.wilyAssert((this.fCPIShouldStubMethod != -1 ? 1 : 0) != 0);
            Assertion.wilyAssert((this.fLocal_tracer != -1 ? 1 : 0) != 0);
            this.fIsConstructor = true;
        } else {
            this.addStubbingCode(methodCode);
        }
    }

    @Override
    public int getMaxStackSlotsUsed() {
        return this.fIsConstructor ? 2 : 1;
    }

    public void addStubbingCode(DGCode methodCode) throws DGClassModificationException, IOException {
        this.fLocal_stubbool = methodCode.addLocal();
        this.write_aload(this.fLocal_tracer);
        this.write_invokeinterface(this.fCPIShouldStubMethod, 1);
        this.write_istore(this.fLocal_stubbool);
        this.write_iload(this.fLocal_stubbool);
        this.write_ifeq(4);
        this.write(177);
    }
}

