/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public final class ThresholdMethodTimer
extends ASingleInstanceTracerFactory {
    private final int fThresholdInMillis = this.getIntegerParameter("threshold", -1);
    private volatile IIntegerRateDataAccumulator fUnderThresholdRate;
    private volatile IIntegerRateDataAccumulator fOverThresholdRate;

    public ThresholdMethodTimer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        Assertion.wilyAssert(false);
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        data.storeWallClockStartTime();
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        IIntegerRateDataAccumulator rate = null;
        rate = data.getWallClockElapsedTime() > (long)this.fThresholdInMillis ? this.getOverThresholdRate(data) : this.getUnderThresholdRate(data);
        if (!rate.IDataAccumulator_isShutOff()) {
            rate.IIntegerRateDataAccumulator_addSingleIncident();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IIntegerRateDataAccumulator getOverThresholdRate(InvocationData data) {
        if (this.canUseCaching()) {
            if (this.fOverThresholdRate == null) {
                ThresholdMethodTimer thresholdMethodTimer = this;
                synchronized (thresholdMethodTimer) {
                    if (this.fOverThresholdRate == null) {
                        this.fOverThresholdRate = this.createOverThresholdRate(this.getFormattedName());
                    }
                }
            }
            return this.fOverThresholdRate;
        }
        return this.createOverThresholdRate(this.formatParameterizedName(data));
    }

    private final IIntegerRateDataAccumulator createOverThresholdRate(String formattedName) {
        StringBuilder name = new StringBuilder(32);
        name.append(formattedName);
        name.append(":");
        name.append("Over Threshold Count");
        return this.getDataAccumulatorFactory().safeGetIntegerRateDataAccumulator(name.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIntegerRateDataAccumulator getUnderThresholdRate(InvocationData data) {
        if (this.canUseCaching()) {
            if (this.fUnderThresholdRate == null) {
                ThresholdMethodTimer thresholdMethodTimer = this;
                synchronized (thresholdMethodTimer) {
                    if (this.fUnderThresholdRate == null) {
                        this.fUnderThresholdRate = this.createUnderThresholdRate(this.getFormattedName());
                    }
                }
            }
            return this.fUnderThresholdRate;
        }
        return this.createUnderThresholdRate(this.formatParameterizedName(data));
    }

    private final IIntegerRateDataAccumulator createUnderThresholdRate(String formattedName) {
        StringBuilder name = new StringBuilder(32);
        name.append(formattedName);
        name.append(":");
        name.append("Under Threshold Count");
        return this.getDataAccumulatorFactory().safeGetIntegerRateDataAccumulator(name.toString());
    }
}

