/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointRTAnomalyDetector;
import com.wily.introscope.agent.intelligent.entrypoint.RuntimeAnomalyDetector;
import com.wily.introscope.agent.trace.IEnhancedInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class FrontendTracer
extends BlamePointTracer
implements IEnhancedInvocationDataParameterCallback {
    private static final String kIsFrontendUnless = "is.frontend.unless";
    private static final RuntimeAnomalyDetector ENTRYPOINT_ANOMALY_DETECTOR = EntryPointRTAnomalyDetector.getInstance();
    private Set fIsFrontendUnless;
    public static final String kIsFrontendAlive = "FrontendTracer.IsAlive";
    public static final String kFrontendsCategoryPrefix = "Frontends|";
    private boolean isSkippedClass = false;
    private final boolean fCheck;

    public FrontendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        String isFrontendUnless = this.getParameter(kIsFrontendUnless);
        this.fCheck = this.calculateBooleanParameter("checkfrontend", true);
        this.fIsFrontendUnless = StringUtils.parseAndTrimListToSet(isFrontendUnless, ",");
    }

    protected Set getClassesToSkip() {
        return this.fIsFrontendUnless;
    }

    protected void setSkippedClass() {
        this.isSkippedClass = true;
    }

    protected boolean isSkippedClass() {
        return this.isSkippedClass;
    }

    protected boolean hasFrontend() {
        return VirtualStack.staticHasFrontBoundary();
    }

    @Override
    protected String getFrontendNameForComponent(String rootName) {
        return kFrontendsCategoryPrefix + rootName;
    }

    @Override
    protected String getComponentName(InvocationData data) {
        String name = super.formatParameterizedName(data);
        if (name != null && !name.contains("Frontends")) {
            name = this.getFrontendNameForComponent(name);
        }
        return name;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        String className;
        Object invocationObject = data.getInvocationObject();
        String string = className = invocationObject == null ? data.getProbeInformation().getProbeIdentification().getProbeClassName() : invocationObject.getClass().getName();
        if (this.getClassesToSkip().contains(className)) {
            this.isSkippedClass = true;
            return;
        }
        super.ITracer_startTrace(tracerIndex, data);
        data.putInTransactionCache(kIsFrontendAlive, new AtomicBoolean(true));
        if (this.kGenerateBusinessTransactionMetrics) {
            this.fBizDefSupport.setFirstFrontendBusinessTransaction(data.getFrontBoundary(), data);
        }
        data.setParameterCallback(this);
        ENTRYPOINT_ANOMALY_DETECTOR.execute(data);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (this.isDisabled()) {
            return;
        }
        super.ITracer_finishTrace(tracerIndex, data);
        AtomicBoolean isAlive = (AtomicBoolean)data.getFromTransactionCache(kIsFrontendAlive);
        if (isAlive != null) {
            isAlive.set(false);
        }
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return this.fCheck && this.hasFrontend();
    }

    protected boolean isDisabled() {
        return this.isSkippedClass;
    }

    @Override
    protected final boolean hasContextualMetrics() {
        return true;
    }

    @Override
    protected boolean subscribeToDownstreamErrors() {
        return true;
    }

    @Override
    public void doOnStartTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData data = (InvocationData)elementData;
        data.setLastFrontendCursor(element);
        super.doOnStartTrace(tracerIndex, elementData, element);
        data.setFrontBoundary(tracerIndex);
    }

    @Override
    public void doOnEndTrace(int tracerIndex, IStackElement elementData, ITransactionElement element) {
        InvocationData data = (InvocationData)elementData;
        super.doOnEndTrace(tracerIndex, elementData, element);
        data.unsetFrontBoundary(tracerIndex);
    }

    @Override
    protected boolean subscribeToDownstreamStalls() {
        return true;
    }

    @Override
    protected AgentMetric[] createTimerMetric(String formattedMetricName) {
        int metricType = 0x10000401;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer duration metric");
        return new AgentMetric[]{metric};
    }

    @Override
    protected AgentMetric[] createPerIntervalMetric(String formattedMetricName) {
        int metricType = 0x10002002;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        return new AgentMetric[]{metric};
    }

    @Override
    protected AgentMetric[] createConcurrentInvocationMetric(String formattedMetricName) {
        int metricType = 0x10000101;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an integer fluctuating counter metric");
        return new AgentMetric[]{metric};
    }

    @Override
    protected AgentMetric[] createErrorsMetric(String formattedMetricName) {
        int metricType = 0x10002002;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for a long interval counter metric");
        return new AgentMetric[]{metric};
    }

    @Override
    protected AgentMetric[] createStallsMetric(String formattedMetricName) {
        int metricType = 0x10000181;
        AgentMetric metric = RepositoryFactory.unSafeGetMetricOfType(this.getAgent(), formattedMetricName, metricType, "Invalid Names:Invalid name given for an aggregating integer fluctuating counter metric");
        return new AgentMetric[]{metric};
    }

    @Override
    protected int getBlameStatus() {
        return 1;
    }

    @Override
    public boolean canCacheTracerInstances() {
        return false;
    }

    @Override
    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        this.addBizDefParameters(data, parameters);
    }

    @Override
    public Map IInvocationDataParameterCallback_addParametersAndReturnMap(InvocationData data, Map parameters) {
        this.IInvocationDataParameterCallback_addParameters(data, parameters);
        return parameters;
    }

    private void addBizDefParameters(InvocationData data, Map parameters) {
        String experienceSource;
        Boolean downstreamBT;
        String appname;
        String tenant;
        String sdk;
        String connection;
        String os;
        String device;
        String location;
        String carrier;
        IBizTrx bizTrx;
        IModuleFeedbackChannel moduleFeedback = this.getModuleFeedback();
        if (WilyTransactionStructure.fCEMForceTraceConfigurationProperty.value) {
            parameters.put("CEM Force Trace", "true");
            moduleFeedback.debug("Setting KTransactionTraceConstants.kCEMForceTrace  to true");
        }
        if ((bizTrx = (IBizTrx)data.get("BusinessTrxDataUsedForSendingTrace")) != null) {
            parameters.put("Business Definition", bizTrx.getBizFullName());
            parameters.put("EUM Business Transaction", bizTrx.getBizTrxName());
            if (!bizTrx.isIdentifying()) {
                moduleFeedback.debug("Setting forceTrace for non identifying business txn #" + bizTrx.getBizFullName());
                parameters.put("CEM Force Trace", "true");
            }
        }
        if ((carrier = (String)data.get("x-apm-bt.Carrier")) != null) {
            parameters.put("x-apm-bt.Carrier", carrier);
        }
        if ((location = (String)data.get("x-apm-bt.Location")) != null) {
            parameters.put("x-apm-bt.Location", location);
        }
        if ((device = (String)data.get("x-apm-bt.Device")) != null) {
            parameters.put("x-apm-bt.Device", device);
        }
        if ((os = (String)data.get("x-apm-bt.OS Version")) != null) {
            parameters.put("x-apm-bt.OS Version", os);
        }
        if ((connection = (String)data.get("x-apm-bt.Connection")) != null) {
            parameters.put("x-apm-bt.Connection", connection);
        }
        if ((sdk = (String)data.get("x-apm-bt.Identifier Version")) != null) {
            parameters.put("x-apm-bt.Identifier Version", sdk);
        }
        if ((tenant = (String)data.get("x-apm-bt.Tenant")) != null) {
            parameters.put("x-apm-bt.Tenant", tenant);
        }
        if ((appname = (String)data.get("x-apm-bt.Application Name")) != null) {
            parameters.put("x-apm-bt.Application Name", appname);
        }
        if ((downstreamBT = (Boolean)data.get("Passthrough External BT")) != null && downstreamBT.booleanValue()) {
            parameters.put("Passthrough External BT", "true");
        }
        if ((experienceSource = (String)data.get("ATTR_ExperienceSource")) != null) {
            parameters.put("ATTR_ExperienceSource", experienceSource);
        }
    }
}

