/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.v1;

import com.wily.isengard.postofficehub.auth.FailedToAuthenticateException;
import com.wily.isengard.postofficehub.link.IRemoteClientTransport;
import com.wily.isengard.postofficehub.link.v1.ABaseTransport;
import com.wily.isengard.postofficehub.link.v1.SessionBasedMessageDeliveryStrategy;
import com.wily.util.properties.IndexedProperties;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ABaseClientTransport
extends ABaseTransport
implements IRemoteClientTransport {
    public ABaseClientTransport(int version) {
        super(version);
    }

    @Override
    public void writeVersion(DataOutput os) throws IOException {
        os.writeInt(this.getIsengardProtocolVersion());
    }

    @Override
    public String connect(String groupName, String credential, IndexedProperties reconnectToProperties) throws IOException {
        ABaseTransport.DataStreams streams = this.createStreams(this.getRawInputStream(), this.getRawOutputStream(), false);
        DataOutputStream dataOutput = streams.getDataOutputStream();
        DataInputStream dataInput = streams.getDataInputStream();
        dataOutput.writeUTF(groupName);
        dataOutput.flush();
        String nodeName = dataInput.readUTF();
        this.setNodeName(nodeName);
        dataOutput.writeUTF(credential);
        dataOutput.flush();
        boolean authSuccess = dataInput.readBoolean();
        if (!authSuccess) {
            String message = dataInput.readUTF();
            throw new FailedToAuthenticateException(message);
        }
        String hubName = dataInput.readUTF();
        int serializationMode = this.getTransportConfiguration().getSerializationMode();
        dataOutput.writeByte(serializationMode);
        dataOutput.flush();
        this.setSerializationHandler(serializationMode);
        this.completeConnection(streams, new SessionBasedMessageDeliveryStrategy(this), true);
        return hubName;
    }
}

