/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.dataresolver;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.backend.http.dataresolver.HttpDataResolver;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.feedback.Module;
import java.net.URI;

public class ApacheCxfWebClientDataResolver
implements HttpDataResolver {
    private static Module module = new Module("ApacheCxfWebClientDataResolver");
    private static final HttpDataResolver instance = new ApacheCxfWebClientDataResolver();

    private ApacheCxfWebClientDataResolver() {
    }

    public static HttpDataResolver getInstance() {
        return instance;
    }

    @Override
    public URI getUri(IAgent agent, InvocationData data) {
        try {
            Object client = this.getClientObject(data);
            Object url = this.determineURI(agent, client);
            if (url instanceof URI) {
                URI uri = (URI)url;
                return uri;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getURI : Unable to get URL for Apache Http components client");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return BackendProtocolsConstants.UNKNOWN_URI;
    }

    private Object determineURI(IAgent agent, Object client) throws Throwable {
        Object returnValue = null;
        if (client != null) {
            returnValue = ReflectionUtils.invokeMethodOnObject((Object)client, (String)"getCurrentURI", (Class[])new Class[0], (Object[])new Object[0]);
        } else {
            agent.IAgent_getModuleFeedback().warn(module, "determineURI : Expecting to find non-null request object");
        }
        return returnValue != null ? returnValue : BackendProtocolsConstants.UNKNOWN_URI;
    }

    @Override
    public String getHttpMethod(IAgent agent, InvocationData data) {
        String methodValueReturn = null;
        try {
            Object httpMethod = data.getInvocationParameterAsObject(0);
            if (httpMethod != null && httpMethod instanceof String) {
                methodValueReturn = (String)httpMethod;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getHttpMethod() : Unable to get HTTP method");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return methodValueReturn;
    }

    @Override
    public int getHttpStatusCode(IAgent agent, InvocationData data) {
        try {
            Object statusCode;
            Object response = data.getInvocationReturnValueAsObject();
            if (response == null) {
                response = data.getInvocationParameterAsObject(1);
            }
            if ((statusCode = ReflectionUtils.invokeMethodOnObject((Object)response, (String)"getStatus", (Class[])new Class[0], (Object[])new Object[0])) != null) {
                return (Integer)statusCode;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getStatusCode() : Unable to get http status code");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    public String getHttpStatusMessage(IAgent agent, InvocationData data) {
        try {
            Object statusType;
            Object response = data.getInvocationReturnValueAsObject();
            if (response == null) {
                response = data.getInvocationParameterAsObject(1);
            }
            if ((statusType = ReflectionUtils.invokeMethodOnObject((Object)response, (String)"getStatusInfo", (Class[])new Class[0], (Object[])new Object[0])) != null) {
                Object reasonPhrase = ReflectionUtils.invokeMethodOnObject((Object)statusType, (String)"getReasonPhrase", (Class[])new Class[0], (Object[])new Object[0]);
                return (String)reasonPhrase;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                agent.IAgent_getModuleFeedback().error(module, "getReasonPhrase() : Unable to get http status message");
                agent.IAgent_getModuleFeedback().verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private Object getClientObject(InvocationData data) {
        Object reqObj = data.getInvocationObject();
        return reqObj;
    }
}

