/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.pbd;

import java.util.ArrayList;
import java.util.List;

public class Directive {
    private String command;
    private List<String> arguments = new ArrayList<String>();

    public Directive(String line) {
        int colonPos = line.indexOf(58);
        if (colonPos != -1) {
            this.command = line.substring(0, colonPos).trim();
            this.parseArgs(line.substring(colonPos + 1));
        }
    }

    public static void main(String[] args) {
        String cmd = "TraceOneMethodWithParametersIfFlagged: ApacheHTTPClientBackend executeMethod(Lorg/apache/commons/httpclient/HostConfiguration;Lorg/apache/commons/httpclient/HttpMethod;Lorg/apache/commons/httpclient/HttpState;)I; ApacheHTTPCommonsClientDetailErrorTracer \"Backends|WebService at {protocol}_//{host}_{port}|Paths|{path}:Errors Per Interval\"";
        Directive d = new Directive(cmd);
        System.out.println(d.getTracer());
    }

    public String getArg(int index) {
        if (index < this.arguments.size()) {
            return this.arguments.get(index);
        }
        return null;
    }

    public String getGroup() {
        switch (this.command) {
            case "SkipMethodForFlag": 
            case "SkipStaticMethodsForFlag": 
            case "SetFlag": 
            case "TurnOn": 
            case "TurnOff": 
            case "MarkNotToggled": 
            case "IdentifyCorbaAs": 
            case "IdentifyAllClasses": 
            case "SubstituteClassIfFlagged": 
            case "SubstituteStaticFieldIfFlagged": 
            case "SubstituteStaticMethodIfFlagged": 
            case "SubstituteResultIfFlagged": 
            case "NoticeConstructorCompletionIfFlagged": 
            case "NoticeObjectCreationIfFlagged": 
            case "NoticeFieldAssignmentIfFlagged": 
            case "NoticeScopedObjectCreationIfFlagged": 
            case "NoticeScopedFieldAssignmentIfFlagged": 
            case "TraceAllMethodsIfFlagged": 
            case "TraceAllComplexMethodsIfFlagged": 
            case "TraceAllComplexMethodsWithThresholdIfFlagged": 
            case "TraceComplexMethodsIfFlagged": 
            case "TraceComplexMethodsWithParametersIfFlagged": 
            case "TraceComplexMethodsWithThresholdIfFlagged": 
            case "TraceRemoteMethodsIfFlagged": 
            case "TraceOneMethodIfFlagged": 
            case "TraceOneMethodWithParametersIfFlagged": 
            case "TraceAllMethodsWithThresholdIfFlagged": 
            case "TraceOneMethodWithThresholdIfFlagged": 
            case "TraceAnnotatedMethodsIfFlagged": 
            case "TraceAttributeMarkedMethodsIfFlagged": 
            case "TraceAnnotatedMethodsWithParametersIfFlagged": 
            case "TraceAttributeMarkedMethodsWithParametersIfFlagged": 
            case "TraceMatchingMethodsWithParametersIfFlagged": 
            case "TraceAllMethodsWithParametersIfFlagged": {
                return this.getArg(0);
            }
            case "SkipAssemblyPrefixForFlag": 
            case "SkipAssemblyForFlag": 
            case "IdentifyClassAs": 
            case "IdentifyInheritedAs": 
            case "IdentifyDeepInheritedAs": 
            case "IdentifyMatchingClassesAs": 
            case "IdentifyFlagAs": 
            case "IdentifyAnnotatedClassAs": 
            case "IdentifyAttributeMarkedClassAs": 
            case "IdentifyInheritedAnnotatedClassAs": 
            case "IdentifyInheritedAttributeMarkedClassAs": 
            case "IdentifyDeepInheritedAnnotatedClassAs": 
            case "IdentifyDeepInheritedAttributeMarkedClassAs": 
            case "SkipAnnotatedForFlag": 
            case "SkipIfInheritedForFlag": 
            case "SkipClassForFlag": 
            case "SkipPackageForFlag": 
            case "SkipNamespaceForFlag": 
            case "SkipPackagePrefixForFlag": 
            case "SkipNamespacePrefixForFlag": {
                return this.getArg(1);
            }
            case "IdentifyTwoFlagUnionAsAggregateFlag": 
            case "IdentifyTwoFlagIntersectionAsAggregateFlag": {
                return this.getArg(2);
            }
            case "TraceOneMethodWithLabelOfClass": 
            case "ConditionallyTraceOneMethodWithLabelOfClass": 
            case "TraceOneMethodWithLabelIfInherits": 
            case "ConditionallyTraceOneMethodWithLabelIfInherits": {
                return this.getArg(3);
            }
        }
        return null;
    }

    public String getTracer() {
        switch (this.command) {
            case "SetTracerClassMapping": 
            case "SetTracerOrdering": 
            case "SetTracerParameter": 
            case "TraceAllMethodsIfCorba": 
            case "TraceRemoteMethodsIfCorba": {
                return this.getArg(0);
            }
            case "TraceAllMethodsOfClass": 
            case "TraceAllMethodsIfInherits": 
            case "TraceAllMethodsIfFlagged": 
            case "TraceAllComplexMethodsIfFlagged": 
            case "TraceAllComplexMethodsWithThresholdIfFlagged": 
            case "TraceComplexMethodsIfFlagged": 
            case "TraceComplexMethodsWithParametersIfFlagged": 
            case "TraceComplexMethodsWithThresholdIfFlagged": 
            case "TraceRemoteMethodsOfClass": 
            case "TraceRemoteMethodsIfInherits": 
            case "TraceRemoteMethodsIfFlagged": 
            case "TraceOneMethodIfCorba": 
            case "TraceOneMethodWithParametersIfCorba": 
            case "TraceAllMethodsWithThresholdIfFlagged": 
            case "TraceAllMethodsWithThresholdOfClass": 
            case "TraceAllMethodsWithParametersIfFlagged": {
                return this.getArg(1);
            }
            case "TraceOneMethodOfClass": 
            case "TraceOneMethodIfInherits": 
            case "TraceOneMethodIfFlagged": 
            case "TraceOneMethodWithParametersOfClass": 
            case "TraceOneMethodWithParametersIfInherits": 
            case "TraceOneMethodWithParametersIfFlagged": 
            case "TraceOneMethodWithThresholdIfFlagged": 
            case "TraceOneMethodWithThresholdOfClass": 
            case "TraceAnnotatedMethodsIfFlagged": 
            case "TraceAttributeMarkedMethodsIfFlagged": 
            case "TraceAnnotatedMethodsWithParametersIfFlagged": 
            case "TraceAttributeMarkedMethodsWithParametersIfFlagged": 
            case "TraceMatchingMethodsWithParametersIfFlagged": {
                return this.getArg(2);
            }
            case "TraceOneMethodWithLabelOfClass": 
            case "ConditionallyTraceOneMethodWithLabelOfClass": 
            case "TraceOneMethodWithLabelIfInherits": 
            case "ConditionallyTraceOneMethodWithLabelIfInherits": {
                return this.getArg(4);
            }
        }
        return null;
    }

    private void parseArgs(String argStr) {
        String[] chunks = argStr.split(" ");
        StringBuilder quotedArg = new StringBuilder();
        boolean insideQuote = false;
        for (String chunk : chunks) {
            if (chunk.startsWith("\"")) {
                quotedArg = new StringBuilder(chunk);
                insideQuote = true;
                continue;
            }
            if (chunk.endsWith("\"") && insideQuote) {
                quotedArg.append(" ").append(chunk);
                this.arguments.add(quotedArg.toString());
                insideQuote = false;
                continue;
            }
            if (insideQuote) {
                quotedArg.append(" ").append(chunk);
                continue;
            }
            if (chunk.isEmpty()) continue;
            this.arguments.add(chunk);
        }
    }
}

