/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.gcmonitor.instrumentation;

import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.gcmonitor.instrumentation.GCStatsUtils;
import com.wily.introscope.gcmonitor.metric.Metric;
import com.wily.introscope.gcmonitor.metricpublisher.MetricPublisher;
import com.wily.introscope.gcmonitor.metricpublisher.MetricPublisherFactory;
import com.wily.introscope.gcmonitor.ui.Messages;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;

public class GCGenerics
implements Metric {
    private MetricPublisher metricPublisher = MetricPublisherFactory.getInstance().getMetricPublisher();
    private MemoryMXBean fMemoryMXBean = ManagementFactory.getMemoryMXBean();
    private String fJvmType;
    private String fGcPolicy;
    private String fGcPolicyName;
    private String fJvmTypeName;
    private String fHeapUsageName;
    private ArrayList<String> fMetricNames;
    private int fCachedHeapUsage;

    public GCGenerics(String jvmType) {
        this.fJvmType = jvmType;
        this.fMetricNames = new ArrayList();
        String metricPrefix = this.generateName();
        this.fGcPolicyName = metricPrefix + Messages.getString("GCMonitorTypeViewer.GcPolicy");
        this.fJvmTypeName = metricPrefix + Messages.getString("GCMonitorTypeViewer.JvmType");
        this.fHeapUsageName = metricPrefix + Messages.getString("GCMonitorTypeViewer.HeapUsage");
    }

    @Override
    public long getLongValue() {
        return GCStatsUtils.getPercentageOfMemoryUsed(this.fMemoryMXBean.getHeapMemoryUsage());
    }

    @Override
    public String getValue() {
        return String.valueOf(this.getLongValue());
    }

    @Override
    public void publish() {
        this.fCachedHeapUsage = (int)this.getLongValue();
        this.metricPublisher.publish(this.fGcPolicyName, this.fGcPolicy);
        if (!this.fMetricNames.contains(this.fGcPolicyName)) {
            this.fMetricNames.add(this.fGcPolicyName);
        }
        this.metricPublisher.publish(this.fHeapUsageName, this.fCachedHeapUsage);
        if (!this.fMetricNames.contains(this.fHeapUsageName)) {
            this.fMetricNames.add(this.fHeapUsageName);
        }
        this.metricPublisher.publish(this.fJvmTypeName, this.fJvmType);
        if (!this.fMetricNames.contains(this.fJvmTypeName)) {
            this.fMetricNames.add(this.fJvmTypeName);
        }
    }

    private String generateName() {
        String metricName = Messages.getString("GCMonitorTypeViewer.RootNode");
        return metricName + ":";
    }

    public void turnOffMetrics(DataAccumulatorFactory factory) {
        ArrayList<String> metricsTobeRemoved = new ArrayList<String>();
        for (String metricName : this.fMetricNames) {
            metricsTobeRemoved.add(metricName);
        }
        for (String metric : metricsTobeRemoved) {
            this.fMetricNames.remove(metric);
            try {
                factory.removeMetric(metric);
            }
            catch (Exception exception) {}
        }
    }

    public void setfGcPolicy(String gcPolicy) {
        this.fGcPolicy = this.fGcPolicy == null ? gcPolicy : this.fGcPolicy + ":" + gcPolicy;
    }

    public String getfGcPolicy() {
        return this.fGcPolicy;
    }
}

