/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.ICacheableInvocationDataTracerFactory;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;

public class MethodThrewErrorReportingTracer
extends ASingleInstanceTracerFactory
implements ICacheableInvocationDataTracerFactory {
    private final ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    protected boolean qualifyingExceptionWasThrown(InvocationData data) {
        return data.hasInvocationThrownException();
    }

    public MethodThrewErrorReportingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        this.doFinishTrace(tracerIndex, data);
    }

    protected void doFinishTrace(int tracerIndex, InvocationData data) {
        String errMsg = this.constructErrorMessage(data);
        if (this.qualifyingExceptionWasThrown(data) && ErrorFeature.evalErrorQualificationForCurrTxn(this.getAgent(), data.getInvocationThrownException(), errMsg)) {
            this.decorateTransactionTraceWithErrorData(data, errMsg);
            IStackElement topElement = data.getVirtualCursor().getTopOfStack();
            if (topElement != null && topElement != data) {
                Throwable error = data.getInvocationThrownException();
                this.incrementErrorMetric(topElement);
                this.constructAndSendErrorSnapshot(topElement, error, errMsg);
            } else {
                this.incrementErrorMetric(data);
                this.constructAndSendErrorSnapshot(data, errMsg);
            }
            data.incrementErrorMetric();
        }
    }

    protected void incrementErrorMetric(InvocationData data) {
        if (this.calculateBooleanParameter("ownmetric", false)) {
            this.createOwnErrorMetric(data);
        } else if (!ErrorFeature.incrementSelfErrorMetric(data)) {
            this.createOwnErrorMetric(data);
        }
        ErrorFeature.incrementUpstreamErrorMetric(data);
    }

    protected void createOwnErrorMetric(InvocationData data) {
        Throwable error = data.getInvocationThrownException();
        if (error != null) {
            String component = this.formatParameterizedResource(data);
            String errorMessage = component + ": " + error.getClass().getName() + ": " + error.getMessage();
            if (ErrorFeature.evalErrorQualificationForCurrTxn(this.getAgent(), null, errorMessage)) {
                String name = this.formatParameterizedName(data);
                try {
                    this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                }
                catch (ESEException e) {
                    Assertion.wilyFail("Metric type conflict");
                }
            }
        }
    }

    protected void decorateTransactionTraceWithErrorData(InvocationData data, String errMsg) {
        ErrorFeature.decorateTransactionsWithError(data, errMsg);
    }

    protected void incrementErrorMetric(IStackElement data) {
        ErrorFeature.incrementErrorMetric(data);
    }

    protected String constructErrorMessage(InvocationData data) {
        String errorMessage = ErrorFeature.fetchErrorMessage(data);
        if (errorMessage != null) {
            String component = this.getComponentNameOfLastBlamePoint(data);
            if (component != null) {
                return component + ": " + errorMessage;
            }
            return errorMessage;
        }
        return null;
    }

    protected void constructAndSendErrorSnapshot(InvocationData data, String errMsg) {
        ErrorFeature.constructAndSendErrorSnapshotToServer(data, errMsg, this.getAgent());
    }

    protected void constructAndSendErrorSnapshot(IStackElement topElement, Throwable error, String errMsg) {
        ErrorFeature.constructAndSendErrorSnapshotToServer(topElement, error, errMsg, this.getAgent());
    }

    public String getComponentNameOfLastBlamePoint(InvocationData data) {
        String componentName = null;
        ITracer[] tracers = data.getTracersByType(null);
        for (int i = tracers.length - 1; i >= 0 && (tracers[i] == null || !(tracers[i] instanceof BlamePointTracer) && !(tracers[i] instanceof com.wily.introscope.agent.trace.BlamePointTracer) || (componentName = data.getComponentNameAt(i)) == null); --i) {
        }
        return componentName;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public boolean canCacheInvocationData() {
        return true;
    }

    @Override
    public boolean canCacheTracerInstances() {
        return true;
    }

    @Override
    public boolean canCacheComponentNames() {
        return true;
    }
}

