/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.metric;

import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.IllegalTypeConversionException;
import com.wily.introscope.spec.metric.IllegalTypeException;
import com.wily.introscope.spec.metric.TypeException;
import com.wily.introscope.spec.server.xml.KMetricTypeDTDConstants;
import com.wily.util.text.FormattedLocalizableMessage;
import java.io.DataOutputStream;
import java.io.IOException;

public final class TypeInquisitor
implements KMetricTypeDTDConstants {
    public static final int kUnderlyingType_Integer = 1;
    static final int kUnderlyingType_Long = 2;
    static final int kUnderlyingType_Float = 3;
    static final int kUnderlyingType_Double = 4;
    static final int kUnderlyingType_String = 5;
    static final int kUnderlyingType_Boolean = 6;
    static final int kUnderlyingType_Unknown = 15;
    public static final int kUnderlyingTypeMask = 15;
    static final int kTypePropertyConstant = 16;
    static final int kTypePropertyChanging = 0;
    public static final int kTypePropertyDoNotAggregate = 32;
    static final int kTreatZeroCountAsHole = 64;
    static final int kDoAdditiveAggregation = 128;
    static final int kNumericInfo_Counter = 256;
    static final int kNumericInfo_Rate = 512;
    public static final int kNumericInfo_Duration = 1024;
    static final int kNumericInfo_Timestamp = 2048;
    static final int kNumericInfo_Percentage = 4096;
    static final int kNumericInfo_IntervalCounter = 8192;
    static final int kNumericInfo_Saturation = 16384;
    static final int kNumericInfoMask = 1048320;
    static final int kStringInfo_SystemLog = 256;
    static final int kStringInfo_ThrowException = 512;
    static final int kStringInfo_CatchException = 1024;
    static final int kStringInfo_IndividualEvents = 4096;
    static final int kStringInfo_Collating = 8192;
    static final int kStringInfoMask = 1048320;
    static final int kCounterInfo_MonotonicallyIncreasing = 0x100000;
    static final int kCounterInfo_Fluctuating = 0;
    static final int kCounterInfo_TimeAggregatingByMin = 0x200000;
    static final int kCounterInfo_CumulativeCounter = 0x800000;
    static final int kCounterInfoMask = 0xF00000;
    static final int kTransientFieldsMask = -65;
    public static final int kMetricTypeInfoMask = -268435456;
    static final int kMetricTypeInfo_Standard = 0;
    public static final int kMetricTypeInfo_Frontend = 0x10000000;
    public static final int kMetricTypeInfo_Backend = 0x20000000;
    static final int kMetricTypeInfo_BusinessTransactions = 0x40000000;
    static final int kMetricTypeInfo_Application = Integer.MIN_VALUE;
    private int fType;

    public TypeInquisitor(int type) {
        this.fType = type;
    }

    public TypeInquisitor(AgentMetric attribute) {
        this.fType = attribute.getAttributeType();
    }

    public int getTypeCookie() {
        return this.fType;
    }

    public boolean isInteger() {
        return TypeInquisitor.isInteger(this.fType);
    }

    public boolean isLong() {
        return TypeInquisitor.isLong(this.fType);
    }

    public boolean isFloat() {
        return TypeInquisitor.isFloat(this.fType);
    }

    public boolean isDouble() {
        return TypeInquisitor.isDouble(this.fType);
    }

    public boolean isBoolean() {
        return TypeInquisitor.isBoolean(this.fType);
    }

    public boolean isString() {
        return TypeInquisitor.isString(this.fType);
    }

    public boolean isAdditiveAggregator() {
        return TypeInquisitor.isAdditiveAggregator(this.fType);
    }

    public boolean isIndividualEvents() {
        return TypeInquisitor.isIndividualEvents(this.fType);
    }

    public boolean isCollating() {
        return TypeInquisitor.isCollating(this.fType);
    }

    public boolean isException() {
        return TypeInquisitor.isException(this.fType);
    }

    public boolean isThrowException() {
        return TypeInquisitor.isThrowException(this.fType);
    }

    public boolean isCatchException() {
        return TypeInquisitor.isCatchException(this.fType);
    }

    public boolean isSystemLog() {
        return TypeInquisitor.isSystemLog(this.fType);
    }

    public boolean isNumeric() {
        return TypeInquisitor.isNumeric(this.fType);
    }

    public boolean isTimestamp() {
        return TypeInquisitor.isTimestamp(this.fType);
    }

    public boolean isConstant() {
        return TypeInquisitor.isConstant(this.fType);
    }

    public boolean isCounter() {
        return TypeInquisitor.isCounter(this.fType);
    }

    public boolean isMonotonicallyIncreasingCounter() {
        return TypeInquisitor.isMonotonicallyIncreasingCounter(this.fType);
    }

    public boolean isFluctuatingCounter() {
        return TypeInquisitor.isFluctuatingCounter(this.fType);
    }

    public boolean isCumulativeCounter() {
        return TypeInquisitor.isCumulativeCounter(this.fType);
    }

    public boolean isRate() {
        return TypeInquisitor.isRate(this.fType);
    }

    public boolean isSaturation() {
        return TypeInquisitor.isSaturation(this.fType);
    }

    public boolean isDuration() {
        return TypeInquisitor.isDuration(this.fType);
    }

    public boolean isPercentage() {
        return TypeInquisitor.isPercentage(this.fType);
    }

    public boolean isIntervalCounter() {
        return TypeInquisitor.isIntervalCounter(this.fType);
    }

    public String getName() {
        return TypeInquisitor.getName(this.fType);
    }

    public boolean isTimeAggregatingByMin() {
        return TypeInquisitor.isTimeAggregatingByMin(this.fType);
    }

    private static int getUnderlyingType(int typeCookie) {
        return typeCookie & 0xF;
    }

    public static int getUnderlyingFrontendType(int typeCookie) {
        return typeCookie & 0xEFFFFFFF;
    }

    public static int switchFrontendType(int typeCookie) {
        return typeCookie ^ 0x10000000;
    }

    private static int getStringSubType(int typeCookie) {
        return typeCookie & 0xFFF00;
    }

    private static int getApplicationMetricType(int typeCookie) {
        return typeCookie & 0xF0000000;
    }

    public static boolean isInteger(int typeCookie) {
        int underlyingType = TypeInquisitor.getUnderlyingType(typeCookie);
        return underlyingType == 1;
    }

    public static boolean isLong(int typeCookie) {
        int underlyingType = TypeInquisitor.getUnderlyingType(typeCookie);
        return underlyingType == 2;
    }

    public static boolean isFloat(int typeCookie) {
        int underlyingType = TypeInquisitor.getUnderlyingType(typeCookie);
        return underlyingType == 3;
    }

    public static boolean isTreatZeroCountAsHole(int typeCookie) {
        return (typeCookie & 0x40) == 64;
    }

    public static boolean isAdditiveAggregator(int typeCookie) {
        return (typeCookie & 0x80) == 128;
    }

    public static int getNonTransientTypeCookie(int typeCookie) {
        return typeCookie & 0xFFFFFFBF;
    }

    public static boolean isDouble(int typeCookie) {
        int underlyingType = TypeInquisitor.getUnderlyingType(typeCookie);
        return underlyingType == 4;
    }

    public static boolean isString(int typeCookie) {
        int underlyingType = TypeInquisitor.getUnderlyingType(typeCookie);
        return underlyingType == 5;
    }

    public static boolean isBoolean(int typeCookie) {
        int underlyingType = TypeInquisitor.getUnderlyingType(typeCookie);
        return underlyingType == 6;
    }

    public static boolean isTimestamp(int typeCookie) {
        return TypeInquisitor.isNumeric(typeCookie) && (typeCookie & 0x800) == 2048;
    }

    public static boolean isConstant(int typeCookie) {
        return (typeCookie & 0x10) == 16;
    }

    public static boolean isCounter(int typeCookie) {
        return TypeInquisitor.isNumeric(typeCookie) && (typeCookie & 0x100) == 256;
    }

    public static boolean isMonotonicallyIncreasingCounter(int typeCookie) {
        return TypeInquisitor.isCounter(typeCookie) && (typeCookie & 0x100000) == 0x100000;
    }

    public static boolean isFluctuatingCounter(int typeCookie) {
        return TypeInquisitor.isCounter(typeCookie) && !TypeInquisitor.isMonotonicallyIncreasingCounter(typeCookie);
    }

    public static boolean isTimeAggregatingByMin(int typeCookie) {
        return (typeCookie & 0x200000) == 0x200000;
    }

    public static boolean isRate(int typeCookie) {
        return TypeInquisitor.isNumeric(typeCookie) && (typeCookie & 0x200) == 512;
    }

    public static boolean isCumulativeCounter(int typeCookie) {
        return TypeInquisitor.isNumeric(typeCookie) && (typeCookie & 0x800000) == 0x800000;
    }

    public static boolean isSaturation(int typeCookie) {
        return TypeInquisitor.isNumeric(typeCookie) && (typeCookie & 0x4000) == 16384;
    }

    public static boolean isDuration(int typeCookie) {
        return TypeInquisitor.isNumeric(typeCookie) && (typeCookie & 0x400) == 1024;
    }

    public static boolean isPercentage(int typeCookie) {
        return TypeInquisitor.isNumeric(typeCookie) && (typeCookie & 0x1000) == 4096;
    }

    public static boolean isIntervalCounter(int typeCookie) {
        return TypeInquisitor.isNumeric(typeCookie) && (typeCookie & 0x2000) == 8192 && !TypeInquisitor.isCumulativeCounter(typeCookie);
    }

    public static boolean isNumeric(int typeCookie) {
        int underlyingType = TypeInquisitor.getUnderlyingType(typeCookie);
        switch (underlyingType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIndividualEvents(int typeCookie) {
        if (TypeInquisitor.isString(typeCookie)) {
            int subtype = TypeInquisitor.getStringSubType(typeCookie);
            return (subtype & 0x1000) == 4096;
        }
        return false;
    }

    public static boolean isCollating(int typeCookie) {
        if (TypeInquisitor.isString(typeCookie)) {
            int subtype = TypeInquisitor.getStringSubType(typeCookie);
            return (subtype & 0x2000) == 8192;
        }
        return false;
    }

    public static boolean isDoNotAggregate(int typeCookie) {
        return (typeCookie & 0x20) == 32;
    }

    public static boolean isException(int typeCookie) {
        int subtype;
        return TypeInquisitor.isString(typeCookie) && (((subtype = TypeInquisitor.getStringSubType(typeCookie)) & 0x200) == 512 || (subtype & 0x400) == 1024);
    }

    public static boolean isThrowException(int typeCookie) {
        int subtype;
        return TypeInquisitor.isString(typeCookie) && ((subtype = TypeInquisitor.getStringSubType(typeCookie)) & 0x200) == 512;
    }

    public static boolean isCatchException(int typeCookie) {
        int subtype;
        return TypeInquisitor.isString(typeCookie) && ((subtype = TypeInquisitor.getStringSubType(typeCookie)) & 0x400) == 1024;
    }

    public static boolean isSystemLog(int typeCookie) {
        int subtype;
        return TypeInquisitor.isString(typeCookie) && ((subtype = TypeInquisitor.getStringSubType(typeCookie)) & 0x100) == 256;
    }

    public static boolean isFrontend(int typeCookie) {
        int subtype = TypeInquisitor.getApplicationMetricType(typeCookie);
        return (subtype & 0x10000000) == 0x10000000;
    }

    public static boolean isBackend(int typeCookie) {
        int subtype = TypeInquisitor.getApplicationMetricType(typeCookie);
        return (subtype & 0x20000000) == 0x20000000;
    }

    public static boolean isBusinessTransaction(int typeCookie) {
        int subtype = TypeInquisitor.getApplicationMetricType(typeCookie);
        return (subtype & 0x40000000) == 0x40000000;
    }

    public static boolean isApplication(int typeCookie) {
        int subtype = TypeInquisitor.getApplicationMetricType(typeCookie);
        return (subtype & Integer.MIN_VALUE) == Integer.MIN_VALUE;
    }

    public static boolean isSameType(int existingType, int metricType) {
        boolean match = false;
        if (existingType == metricType) {
            match = true;
        } else if ((existingType & 0xFFFFFFF) == (metricType & 0xFFFFFFF)) {
            match = true;
        }
        return match;
    }

    public static String getName(int typeCookie) {
        int underlyingType = TypeInquisitor.getUnderlyingType(typeCookie);
        String result = "<unexpected type>";
        switch (underlyingType) {
            case 15: {
                result = "kType_unknown";
                break;
            }
            case 1: {
                result = "kUnderlyingType_Integer";
                break;
            }
            case 2: {
                result = "kUnderlyingType_Long";
                break;
            }
            case 3: {
                result = "kUnderlyingType_Float";
                break;
            }
            case 4: {
                result = "kUnderlyingType_Double";
                break;
            }
            case 5: {
                result = "kUnderlyingType_String";
                break;
            }
            case 6: {
                result = "kUnderlyingType_Boolean";
            }
        }
        return result;
    }

    public static void write(int typeCookie, Object objectToInterpret, DataOutputStream outputStream) throws IOException, TypeException {
        int underlyingType = TypeInquisitor.getUnderlyingType(typeCookie);
        try {
            switch (underlyingType) {
                case 1: {
                    outputStream.writeInt((Integer)objectToInterpret);
                    break;
                }
                case 2: {
                    outputStream.writeLong((Long)objectToInterpret);
                    break;
                }
                case 3: {
                    outputStream.writeFloat(((Float)objectToInterpret).floatValue());
                    break;
                }
                case 4: {
                    outputStream.writeDouble((Double)objectToInterpret);
                    break;
                }
                case 6: {
                    outputStream.writeBoolean((Boolean)objectToInterpret);
                    break;
                }
                case 5: {
                    outputStream.writeUTF((String)objectToInterpret);
                    break;
                }
                default: {
                    throw new IllegalTypeException("ESEType: Tried to write unknown type: " + typeCookie);
                }
            }
        }
        catch (ClassCastException c) {
            throw new IllegalTypeConversionException(c.getMessage());
        }
    }

    public static int numberCompare(int typeCookie, Number objectToInterpret1, Number objectToInterpret2) throws TypeException {
        int result = 0;
        int underlyingType = TypeInquisitor.getUnderlyingType(typeCookie);
        try {
            switch (underlyingType) {
                case 1: {
                    int int1 = objectToInterpret1.intValue();
                    long int2 = objectToInterpret2.longValue();
                    result = (long)int1 < int2 ? -1 : ((long)int1 > int2 ? 1 : 0);
                    break;
                }
                case 2: {
                    long long1 = objectToInterpret1.longValue();
                    long long2 = objectToInterpret2.longValue();
                    result = long1 < long2 ? -1 : (long1 > long2 ? 1 : 0);
                    break;
                }
                case 3: {
                    float float1 = objectToInterpret1.floatValue();
                    float float2 = objectToInterpret2.floatValue();
                    result = float1 < float2 ? -1 : (float1 > float2 ? 1 : 0);
                    break;
                }
                case 4: {
                    double double1 = objectToInterpret1.doubleValue();
                    double double2 = objectToInterpret2.doubleValue();
                    result = double1 < double2 ? -1 : (double1 > double2 ? 1 : 0);
                    break;
                }
                default: {
                    throw new IllegalTypeException("Bad ESEType: " + typeCookie);
                }
            }
        }
        catch (ClassCastException c) {
            throw new IllegalTypeConversionException(c.getMessage());
        }
        return result;
    }

    public static Object parseFromString(int typeCookie, String sourceString) throws TypeException {
        if (sourceString == null) {
            return null;
        }
        Object result = null;
        int underlyingType = TypeInquisitor.getUnderlyingType(typeCookie);
        try {
            switch (underlyingType) {
                case 1: {
                    result = Integer.valueOf(sourceString);
                    break;
                }
                case 2: {
                    result = Long.valueOf(sourceString);
                    break;
                }
                case 3: {
                    result = Float.valueOf(sourceString);
                    break;
                }
                case 4: {
                    result = Double.valueOf(sourceString);
                    break;
                }
                case 6: {
                    result = Boolean.valueOf(sourceString);
                    break;
                }
                case 5: {
                    result = sourceString;
                    break;
                }
                default: {
                    throw new IllegalTypeException("ESEType: Tried to write unknown type: " + typeCookie);
                }
            }
        }
        catch (ClassCastException c) {
            throw new IllegalTypeConversionException(c.getMessage());
        }
        return result;
    }

    public static String convertToString(int typeCookie, Object value) throws TypeException {
        if (value == null) {
            return null;
        }
        String result = null;
        int underlyingType = TypeInquisitor.getUnderlyingType(typeCookie);
        try {
            switch (underlyingType) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    result = value.toString();
                    break;
                }
                default: {
                    throw new IllegalTypeException("ESEType: Tried to convertToString unknown type: " + typeCookie);
                }
            }
        }
        catch (ClassCastException c) {
            throw new IllegalTypeConversionException(c.getMessage());
        }
        return result;
    }

    public static int getValueFromString(String type) throws TypeException {
        if ("UnderlyingIntegerMetricType".equals(type)) {
            return 1;
        }
        if ("UnderlyingLongMetricType".equals(type)) {
            return 2;
        }
        if ("UnderlyingStringMetricType".equals(type)) {
            return 5;
        }
        if ("CounterType".equals(type)) {
            return 256;
        }
        if ("FluctuatingCounter".equals(type)) {
            return 0;
        }
        if ("MonotonicallyIncreasingCounter".equals(type)) {
            return 0x100000;
        }
        if ("RateType".equals(type)) {
            return 512;
        }
        if ("SaturationType".equals(type)) {
            return 16384;
        }
        if ("DurationType".equals(type)) {
            return 1024;
        }
        if ("TimestampType".equals(type)) {
            return 2048;
        }
        if ("PercentageType".equals(type)) {
            return 4096;
        }
        if ("IntervalCounterType".equals(type)) {
            return 8192;
        }
        if ("CollatingType".equals(type)) {
            return 8192;
        }
        if ("SystemLogType".equals(type)) {
            return 256;
        }
        if ("IndividualEventsType".equals(type)) {
            return 4096;
        }
        if ("ThrowExceptionType".equals(type)) {
            return 512;
        }
        if ("CatchExceptionType".equals(type)) {
            return 1024;
        }
        if ("ConstantType".equals(type)) {
            return 16;
        }
        if ("ChangingType".equals(type)) {
            return 0;
        }
        if ("AggregationType".equals(type)) {
            return 128;
        }
        if ("ZeroCountAsHoleType".equals(type)) {
            return 64;
        }
        if ("DoNotAggregateType".equals(type)) {
            return 32;
        }
        if ("FrontendMask".equals(type)) {
            return 0x10000000;
        }
        if ("BizTrxMask".equals(type)) {
            return 0x40000000;
        }
        if ("BackendMask".equals(type)) {
            return 0x20000000;
        }
        throw new TypeException(new FormattedLocalizableMessage("Unknown_Type_Identifier", type));
    }
}

