/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge;

import com.wily.introscope.agent.upgrade.merge.MergeConfigExtensions;
import com.wily.introscope.agent.upgrade.merge.MergeConfigurations;
import com.wily.introscope.agent.upgrade.merge.exceptions.MergeException;
import com.wily.introscope.agent.upgrade.merge.rules.RulesEngine;
import com.wily.introscope.agent.upgrade.merge.util.UpgradeUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;

public class MergeAdministrator {
    public static final String CORE_CONFIG = File.separator + "core" + File.separator + "config";
    public static final String EXTENSIONS = File.separator + "extensions";
    public static final String INTROSCOPE_AGENT_PROFILE = "IntroscopeAgent.profile";
    public static final String EXTENSIONS_PROFILE = "Extensions.profile";

    public static void doMergeMain(String updateDir, String configDir, String mergeRules) throws MergeException {
        MergeConfigurations administrator = new MergeConfigurations();
        administrator.doMerge(updateDir, configDir, mergeRules, true);
    }

    public static String mergeConfigAndExtensions(String oldDir, String newDir, String mergeRules, String fromRelease, String toRelease, boolean mergePBD) {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuilder resultMsg = new StringBuilder();
        String oldConfigDir = oldDir + CORE_CONFIG;
        String newConfigDir = newDir + CORE_CONFIG;
        String oldExtnDir = oldDir + EXTENSIONS;
        String newExtnDir = newDir + EXTENSIONS;
        MergeConfigExtensions mergeImpl = new MergeConfigExtensions();
        try {
            if (!UpgradeUtil.isFileAvailableAt(newConfigDir, INTROSCOPE_AGENT_PROFILE)) {
                throw new MergeException("IntroscopeAgent.profile not found. Invalid configuration directory passed-" + newConfigDir);
            }
            if (!UpgradeUtil.isFileAvailableAt(oldConfigDir, INTROSCOPE_AGENT_PROFILE)) {
                throw new MergeException("IntroscopeAgent.profile not found. Invalid configuration directory passed-" + oldConfigDir);
            }
            if (!UpgradeUtil.isFileAvailableAt(newExtnDir, EXTENSIONS_PROFILE)) {
                throw new MergeException("Extensions.profile not found. Invalid extensions directory passed-" + newExtnDir);
            }
            if (!UpgradeUtil.isFileAvailableAt(oldExtnDir, EXTENSIONS_PROFILE)) {
                throw new MergeException("Extensions.profile not found. Invalid extensions directory passed-" + oldExtnDir);
            }
            String baseDir = newDir;
            if (newDir.contains("releases")) {
                Path root = Paths.get(newDir, new String[0]);
                while (root.toString().contains("releases")) {
                    root = root.getParent();
                }
                baseDir = root.toString();
            }
            RulesEngine engine = new RulesEngine(mergeRules);
            mergeImpl.setTargetRelease(toRelease);
            mergeImpl.initializeMergeDiff(fromRelease, toRelease);
            mergeImpl.resolveWorkingDirectory(baseDir);
            if (mergePBD) {
                String configPBDResponse = mergeImpl.mergePBDInCoreConfig(oldConfigDir, newConfigDir);
                resultMsg.append(configPBDResponse);
                String extnPBDResponse = mergeImpl.mergeExtensionsPBD(oldExtnDir, newExtnDir, engine);
                resultMsg.append(extnPBDResponse);
            }
            String configResponse = mergeImpl.mergeConfig(oldConfigDir, newConfigDir, engine);
            resultMsg.append(configResponse);
            String extnResponse = mergeImpl.mergeExtensions(oldExtnDir, newExtnDir, engine);
            resultMsg.append(extnResponse);
            String mergeReport = mergeImpl.createDiffReport();
            resultMsg.append(mergeReport);
            result.put("Status", "0");
            result.put("Message", resultMsg.toString());
            mergeImpl.cleanup();
            return ((Object)result).toString();
        }
        catch (Exception ex) {
            result.put("Status", "-1");
            result.put("Message", "Error while performing merge action. Error-" + ex.getMessage());
            mergeImpl.cleanup();
            return ((Object)result).toString();
        }
    }
}

