/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.pbd;

import com.wily.introscope.agent.upgrade.merge.IMergeable;
import com.wily.introscope.agent.upgrade.merge.IRulesEngine;
import com.wily.introscope.agent.upgrade.merge.Line;
import com.wily.introscope.agent.upgrade.merge.pbd.DirectiveKey;
import com.wily.introscope.agent.upgrade.merge.pbd.DirectiveValue;
import com.wily.introscope.agent.upgrade.merge.util.KMergeConstants;
import com.wily.introscope.agent.upgrade.merge.util.PBDParseHelper;
import com.wily.introscope.agent.upgrade.merge.util.UpgradeUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class PBD
implements IMergeable<PBD> {
    private List<DirectiveKey> fDirectiveList = new ArrayList<DirectiveKey>();
    private List<Line> fHeader = new ArrayList<Line>();
    private List<String> fOrderedKeys = new ArrayList<String>();

    public List<Line> getHeader() {
        return Collections.unmodifiableList(this.fHeader);
    }

    public void setHeader(List<Line> header) {
        this.fHeader.clear();
        for (Line line : header) {
            this.fHeader.add(line);
        }
    }

    public static PBD read(BufferedReader reader) throws IOException {
        PBD pbd = new PBD();
        int header = 0;
        ArrayList<Line> comments = new ArrayList<Line>();
        String line = null;
        int count = 0;
        while ((line = reader.readLine()) != null) {
            ++count;
            if (UpgradeUtil.isBlank(line)) {
                comments.add(new Line("", count));
                continue;
            }
            if (UpgradeUtil.isCompleteHashedLine(line)) {
                comments.add(new Line(line, count));
                if (header == 1) {
                    pbd.setHeader(comments);
                    comments.clear();
                }
                ++header;
                continue;
            }
            if (line.trim().startsWith("#")) {
                comments.add(new Line(line, count));
                continue;
            }
            PBD.handleKey(pbd, line, comments);
            comments.clear();
        }
        return pbd;
    }

    private void addOrderedKeys(String key) {
        this.fOrderedKeys.add(key);
    }

    private static void handleKey(PBD pbd, String line, List<Line> comments) throws IOException {
        String keyWord = PBDParseHelper.getKeyword(line.toString());
        if (!UpgradeUtil.isBlank(keyWord)) {
            pbd.addKey(keyWord.substring(0, keyWord.length() - 1), line.toString(), comments);
        }
    }

    public int getKeyIndex(String key) {
        for (int i = 0; i < this.fDirectiveList.size(); ++i) {
            if (!this.fDirectiveList.get(i).getKey().equalsIgnoreCase(key)) continue;
            return i;
        }
        return -1;
    }

    public void addKey(String keyWord, String directiveLine, List<Line> comments) {
        DirectiveValue dValue = new DirectiveValue(directiveLine.substring(keyWord.length() + 1));
        dValue.addComment(comments);
        int keyPos = this.getKeyIndex(keyWord);
        if (keyPos >= 0) {
            if (!this.fDirectiveList.get(keyPos).hasValue(dValue)) {
                this.fDirectiveList.get(keyPos).getValueSet().add(dValue);
            }
        } else {
            DirectiveKey dKey = new DirectiveKey(keyWord);
            dKey.getValueSet().add(dValue);
            this.fDirectiveList.add(dKey);
        }
        this.addOrderedKeys(keyWord);
    }

    @Override
    public PBD merge(PBD otherPBD) {
        PBD mergedPbd = new PBD();
        mergedPbd.setHeader(otherPBD.getHeader());
        for (DirectiveKey directiveKey : this.fDirectiveList) {
            int keyIndex = otherPBD.getKeyIndex(directiveKey.getKey());
            if (keyIndex >= 0) {
                DirectiveKey otherDirectiveKey = otherPBD.fDirectiveList.get(keyIndex);
                DirectiveKey tempKey = new DirectiveKey(directiveKey.getKey());
                for (DirectiveValue aPreferredDirectiveValue : directiveKey.getValueSet()) {
                    if (otherDirectiveKey.getValueSet().contains(aPreferredDirectiveValue)) {
                        tempKey.add(aPreferredDirectiveValue);
                        otherDirectiveKey.getValueSet().remove(aPreferredDirectiveValue);
                        continue;
                    }
                    tempKey.add(aPreferredDirectiveValue);
                }
                otherPBD.fDirectiveList.remove(otherDirectiveKey);
                for (DirectiveValue value : otherDirectiveKey.getValueSet()) {
                    tempKey.add(value);
                }
                mergedPbd.fDirectiveList.add(tempKey);
                continue;
            }
            mergedPbd.addKey(directiveKey);
        }
        for (DirectiveKey anotherDirectiveKey : otherPBD.fDirectiveList) {
            mergedPbd.addKey(anotherDirectiveKey);
        }
        return mergedPbd;
    }

    @Override
    public PBD merge(PBD otherPBD, IRulesEngine engine) {
        PBD mergedPbd = new PBD();
        mergedPbd.setHeader(otherPBD.getHeader());
        HashSet<DirectiveKey> commonKeys = new HashSet<DirectiveKey>();
        for (DirectiveKey directiveKey : this.fDirectiveList) {
            if (engine.isEntryDelete(IRulesEngine.MergeableType.PBD, directiveKey)) continue;
            int keyIndex = otherPBD.getKeyIndex(directiveKey.getKey());
            if (keyIndex >= 0) {
                commonKeys.add(directiveKey);
                DirectiveKey otherDirectiveKey = otherPBD.fDirectiveList.get(keyIndex);
                DirectiveKey tempKey = new DirectiveKey(directiveKey.getKey());
                IRulesEngine.PreferenceType type = engine.getPreferredType(IRulesEngine.MergeableType.PBD, directiveKey);
                if (type == IRulesEngine.PreferenceType.CURRENT) {
                    for (DirectiveValue value : directiveKey.getValueSet()) {
                        if (otherDirectiveKey.getValueSet().contains(value)) {
                            tempKey.add(value);
                            otherDirectiveKey.getValueSet().remove(value);
                            continue;
                        }
                        tempKey.add(value);
                    }
                } else if (type == IRulesEngine.PreferenceType.UPGRADE) {
                    for (DirectiveValue value : otherDirectiveKey.getValueSet()) {
                        if (directiveKey.getValueSet().contains(value)) {
                            tempKey.add(value);
                            directiveKey.getValueSet().remove(value);
                            continue;
                        }
                        tempKey.add(value);
                    }
                }
                for (DirectiveValue value : otherDirectiveKey.getValueSet()) {
                    tempKey.add(value);
                }
                mergedPbd.fDirectiveList.add(tempKey);
                continue;
            }
            mergedPbd.addKey(directiveKey);
        }
        for (DirectiveKey anotherDirectiveKey : otherPBD.fDirectiveList) {
            if (commonKeys.contains(anotherDirectiveKey)) continue;
            mergedPbd.addKey(anotherDirectiveKey);
        }
        return mergedPbd;
    }

    private void addKey(DirectiveKey aKey) {
        this.fDirectiveList.add(aKey);
    }

    @Override
    public void write(Writer writer) throws IOException {
        writer.write(this.getPbd());
        writer.flush();
    }

    private String getPbd() {
        StringBuilder fOutput = new StringBuilder();
        for (Line aLine : this.getHeader()) {
            fOutput.append(aLine.getContent());
            fOutput.append(KMergeConstants.kNewline);
        }
        for (DirectiveKey aKey : this.fDirectiveList) {
            for (DirectiveValue aValue : aKey.getValueSet()) {
                List<Line> commentList = aValue.getComments();
                for (Line l : commentList) {
                    fOutput.append(l.getContent());
                    fOutput.append(KMergeConstants.kNewline);
                }
                fOutput.append(aKey.getKey());
                fOutput.append(": ");
                fOutput.append(aValue.getDirectiveLine());
                fOutput.append(KMergeConstants.kNewline);
            }
        }
        return fOutput.toString();
    }

    public String toString() {
        StringBuilder strBldr = new StringBuilder("Class: PBD\n");
        strBldr.append(this.getPbd());
        return strBldr.toString();
    }
}

