/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.profile;

import com.wily.introscope.agent.upgrade.merge.Line;
import java.util.ArrayList;
import java.util.List;

public class Value {
    private String fValue;
    private boolean fCommented;
    private List<Line> fComments = new ArrayList<Line>();
    private int fIndex;
    private boolean fIsOld = false;

    public Value(String value, boolean commented, List<Line> comments, int lineNumber) {
        this.fValue = value;
        this.fCommented = commented;
        this.fIndex = lineNumber;
        this.fComments.clear();
        if (comments != null) {
            for (Line aLine : comments) {
                Line line = new Line(aLine.getContent(), aLine.getIndex());
                this.fComments.add(line);
            }
        }
    }

    public Value(String value, boolean commented, List<Line> comments, int lineNumber, boolean isOldValue) {
        this.fValue = value;
        this.fCommented = commented;
        this.fIndex = lineNumber;
        this.fIsOld = isOldValue;
        this.fComments.clear();
        for (Line aLine : comments) {
            Line line = new Line(aLine.getContent(), aLine.getIndex());
            this.fComments.add(line);
        }
    }

    public String getValue() {
        return this.fValue;
    }

    public boolean isCommented() {
        return this.fCommented;
    }

    public List<Line> getComments() {
        return this.fComments;
    }

    public int getLineNumber() {
        return this.fIndex;
    }

    public boolean isOldValue() {
        return this.fIsOld;
    }

    public void setOldValue() {
        this.fIsOld = true;
    }

    public void setCommented() {
        this.fCommented = true;
    }

    public int hashCode() {
        int result = 17;
        int hash = this.fValue == null ? 0 : this.fValue.hashCode();
        result = 31 * result + hash;
        return result;
    }

    public boolean equals(Object obj) {
        boolean retValue = false;
        if (this == obj) {
            retValue = true;
        } else if (obj instanceof Value) {
            Value otherObj = (Value)obj;
            if (this.fValue != null && this.fValue.equals(otherObj.fValue)) {
                retValue = true;
            }
        }
        return retValue;
    }

    public String toString() {
        StringBuilder strBldr = new StringBuilder("Class: Value");
        strBldr.append("\n\tValue:     " + this.fValue).append("\n\tCommented: " + this.fCommented).append("\n\tComments:  " + this.getCommentString());
        return strBldr.toString();
    }

    private String getCommentString() {
        StringBuilder strBldr = new StringBuilder();
        for (Line line : this.fComments) {
            strBldr.append("\n").append(line);
        }
        return strBldr.toString();
    }
}

