/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.rules;

import com.wily.introscope.agent.upgrade.merge.IMetadataEntry;
import com.wily.introscope.agent.upgrade.merge.IRulesEngine;
import com.wily.introscope.agent.upgrade.merge.exceptions.MergeException;
import com.wily.introscope.agent.upgrade.merge.profile.Key;
import com.wily.introscope.agent.upgrade.merge.rules.DeleteEntryRule;
import com.wily.introscope.agent.upgrade.merge.rules.PreferredEntryRule;
import com.wily.introscope.agent.upgrade.merge.rules.RenamedEntryRule;
import com.wily.introscope.agent.upgrade.merge.rules.Rules;
import com.wily.introscope.agent.upgrade.merge.rules.RulesParser;
import java.util.Set;

public class RulesEngine
implements IRulesEngine {
    private Rules fRules;
    private RulesParser fParser;

    public RulesEngine(String rulesFile) throws MergeException {
        this.fParser = new RulesParser(rulesFile);
        this.addDefaultRules();
        this.fRules = this.fParser.getRules();
    }

    private void addDefaultRules() {
        this.fRules = this.fParser.getRules();
        this.fRules.addDeleteEntryRule(this.createDeleteRule("acc.package.id"));
        this.fRules.addDeleteEntryRule(this.createDeleteRule("acc.server.id"));
        this.fRules.addDeleteEntryRule(this.createDeleteRule("acc.package.name"));
        this.fRules.addDeleteEntryRule(this.createDeleteRule("acc.package.version"));
        this.fRules.addDeleteEntryRule(this.createDeleteRule("acc.package.truststore.hash"));
    }

    private DeleteEntryRule createDeleteRule(String property) {
        return new DeleteEntryRule(IRulesEngine.MergeableType.PROFILE, property);
    }

    @Override
    public boolean isDelete(IRulesEngine.MergeableType type, String fileName) {
        return this.fRules.hasDeleteFileRule(type, fileName);
    }

    @Override
    public boolean isOverwrite(IRulesEngine.MergeableType type, String fileName) {
        return this.fRules.hasOverwriteFileRule(type, fileName);
    }

    @Override
    public boolean isMerge(IRulesEngine.MergeableType type, String fileName) {
        return !this.fRules.hasNoMergeFileRule(type, fileName);
    }

    @Override
    public boolean isEntryDelete(IRulesEngine.MergeableType type, IMetadataEntry entry) {
        return this.fRules.hasDeleteEntryRule(type, entry.getKey());
    }

    @Override
    public IRulesEngine.PreferenceType getPreferredType(IRulesEngine.MergeableType type, IMetadataEntry entry) {
        IRulesEngine.PreferenceType preferred = IRulesEngine.PreferenceType.CURRENT;
        PreferredEntryRule rule = this.fRules.getPreferredEntryRule(type, entry.getKey());
        if (rule != null && (preferred = rule.getPreference()) == IRulesEngine.PreferenceType.INVALID) {
            preferred = IRulesEngine.PreferenceType.CURRENT;
        }
        return preferred;
    }

    @Override
    public Key getRenamedEntry(IRulesEngine.MergeableType type, IMetadataEntry entry) {
        Key renamedKey = (Key)entry;
        RenamedEntryRule rule = this.fRules.getRenameEntryRule(type, entry.getKey());
        if (rule != null) {
            renamedKey = rule.getRenamedKey();
        }
        return renamedKey;
    }

    @Override
    public Set<IMetadataEntry> getAllRenamedEntries(IRulesEngine.MergeableType type) {
        return this.fRules.getAllRenamedEntryRules(type);
    }
}

