/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.standalone;

import com.wily.introscope.agent.upgrade.merge.MergeAdministrator;
import com.wily.introscope.agent.upgrade.merge.exceptions.MergeException;
import com.wily.introscope.agent.upgrade.merge.util.KMergeConstants;

public class MergeMain {
    public static final String kLine = System.getProperty("line.separator");
    public static final String kTab = "    ";
    public static final String kCustomerDirParam = "customerDir";
    public static final String kmergePBD = "mergePBD";
    public static final String kUpgradeDirParam = "upgradeDir";
    public static final String kMergeRulePath = "rule";
    public static final String kExtensionEnable = "mode";
    public static final String kReleaseFrom = "from";
    public static final String kReleaseTo = "to";
    public static final String kbaseDir = "baseDir";
    public static final String kConsiderCommentedProperties = "dp";

    private static void usage() {
        StringBuffer usageBuffer = new StringBuffer();
        usageBuffer.append(kLine + kLine + "Usage: java -jar MergeUtility.jar customerDir=<customerDir> upgradedir=<upgradeDir> rule=<rule file path>(OPTIONAL) mode=extconfig(OPTIONAL) from=<releaseName>(OPTIONAL) to=<releaseName>(OPTIONAL) dp=true(default is false)");
        usageBuffer.append(kLine + kLine + "Where:").append(kLine + kTab + kTab + "<customerDir>    is the location of a directory containing").append(kLine + kTab + kTab + "                 customer's config files like profile,pbl and pbd").append(kLine + kTab + kTab + "<upgradeDir>     is the location of a directory containing").append(kLine + kTab + kTab + "                 upgrade configuration files").append(kLine + kTab + kTab + "<rule>           is the absolute path of the merge rule file (OPTIONAL)").append(kLine + kTab + kTab + "<mode>           flag to merge extensions and configurations both, default false. Possible value is 'extconfig' (OPTIONAL)").append(kLine + kTab + kTab + "<from>           old release version. Only required for mode=extconfig (OPTIONAL)").append(kLine + kTab + kTab + "<to>             new release version Only required for mode=extconfig (OPTIONAL)").append(kLine + kTab + kTab + "<dp>             consider disabled(commented) properties for merge. Default is false. Only used when mode=extconfig (OPTIONAL)");
        usageBuffer.append(kLine + kLine + "Example (with merge rule supplied):").append(kLine + "java -jar MergeUtility.jar customerDir=\"C:/wily/core/config\" upgradedir=\"C:/upgrade/core/config\" rule=\"C:/patch/upgrade/merge_rules.xml\"");
        usageBuffer.append(kLine + kLine + "Example (without merge rules):").append(kLine + "java -jar MergeUtility.jar customerDir=\"C:/wily/core/config\" upgradedir=\"C:/upgrade/core/config\"");
        usageBuffer.append(kLine + kLine + "Example of mode=extconfig (without merge rules)").append(kLine + "java -jar MergeUtility.jar customerDir=\"C:/wily-old/\" upgradedir=\"C:/wily-upgrade\" mode=extconfig from=22.1 to=24.5.3").append(kLine + "java -jar MergeUtility.jar customerDir=\"C:/apmia-old/\" upgradedir=\"C:/apmia-upgrade\" mode=extconfig from=22.1 to=24.5.3").append(kLine + kLine + "Only root directory path is expected for mode=extconfig").append(kLine + "The utility appends /core/config and /extensions to root directory path of old and new installation in this mode.").append(kLine + "<from> and <to> release versions are required to generate merge diff report.").append(kLine + "The diff report is created in mergedoutput folder under C:/<upgradeDir>/.acc/");
        usageBuffer.append(kLine + kLine + "For a detailed explanation of this utility's full functionality, see the").append(kLine + "Java Agent Guide.");
        System.out.println(usageBuffer);
    }

    private static void merge(String[] args) {
        String customerDir = null;
        String upgradeDir = null;
        String mergeRulePath = null;
        boolean extConfig = false;
        String fromRelease = null;
        String toRelease = null;
        boolean mergePBD = false;
        block23: for (String arg : args) {
            String[] tokens = arg.split("=");
            if (tokens.length != 2) {
                System.out.println("Invalid parameter: " + arg);
                MergeMain.usage();
                System.exit(0);
            }
            switch (tokens[0].trim()) {
                case "customerDir": {
                    customerDir = tokens[1];
                    continue block23;
                }
                case "upgradeDir": {
                    upgradeDir = tokens[1];
                    continue block23;
                }
                case "rule": {
                    mergeRulePath = tokens[1];
                    continue block23;
                }
                case "mode": {
                    if (tokens[1] == null || !"extconfig".equalsIgnoreCase(tokens[1].trim())) continue block23;
                    extConfig = true;
                    continue block23;
                }
                case "from": {
                    fromRelease = tokens[1];
                    continue block23;
                }
                case "to": {
                    toRelease = tokens[1];
                    continue block23;
                }
                case "mergePBD": {
                    if (tokens[1] == null || !"true".equalsIgnoreCase(tokens[1].trim())) continue block23;
                    mergePBD = true;
                    continue block23;
                }
                case "dp": {
                    String disabledProp = tokens[1];
                    if (!"true".equalsIgnoreCase(disabledProp.trim())) continue block23;
                    KMergeConstants.kMergeDisabledProperties = true;
                    continue block23;
                }
                default: {
                    System.out.println("Invalid parameter: " + arg);
                    MergeMain.usage();
                    System.exit(0);
                }
            }
        }
        if (customerDir == null || customerDir.trim().isEmpty()) {
            System.out.println("Missing parameter: customerDir");
            MergeMain.usage();
            System.exit(0);
        }
        if (upgradeDir == null || upgradeDir.trim().isEmpty()) {
            System.out.println("Missing parameter: upgradeDir");
            MergeMain.usage();
            System.exit(0);
        }
        if (extConfig) {
            if (fromRelease == null || fromRelease.trim().isEmpty()) {
                System.out.println("Missing parameter: from");
                MergeMain.usage();
                System.exit(0);
            }
            if (toRelease == null || toRelease.trim().isEmpty()) {
                System.out.println("Missing parameter: to");
                MergeMain.usage();
                System.exit(0);
            }
        }
        try {
            if (extConfig) {
                String response = MergeAdministrator.mergeConfigAndExtensions(customerDir, upgradeDir, mergeRulePath, fromRelease, toRelease, mergePBD);
                System.out.println(response);
            } else {
                MergeAdministrator.doMergeMain(upgradeDir, customerDir, mergeRulePath);
            }
            System.out.println("***** Merge Tool has finished operation.");
        }
        catch (MergeException e) {
            System.out.println(e.getMessage());
        }
        catch (Throwable ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length == 0 || args[0] != null && args[0].equals("usage")) {
            MergeMain.usage();
        } else {
            MergeMain.merge(args);
        }
    }
}

