/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.upgrade.merge.util;

import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;

public class UpgradeUtil {
    static Gson gson;

    public static void WriteObjectToFileAsJson(Object obj, String fileName, String path) throws IOException {
        if (gson == null) {
            gson = new Gson();
        }
        String json = gson.toJson(obj);
        UpgradeUtil.writeInternal(json, path + "/" + fileName);
    }

    static void writeInternal(String text, String destination) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(destination));){
            bufferedWriter.write(text);
            bufferedWriter.flush();
        }
    }

    public static String getFileExtension(String filename) {
        String ext = null;
        int dotPos = filename.lastIndexOf(".");
        if (0 < dotPos && dotPos <= filename.length() - 2) {
            ext = filename.substring(dotPos + 1);
        }
        return ext;
    }

    public static boolean isCompleteHashedLine(String content) {
        int i;
        if (UpgradeUtil.isBlank(content)) {
            return false;
        }
        for (i = 0; i < content.length(); ++i) {
            if (content.charAt(i) == '#' && !Character.isWhitespace(content.charAt(i))) continue;
            return false;
        }
        return i >= 10;
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isFileAvailableAt(String dirPath, final String fileName) {
        File directory = new File(dirPath);
        if (directory.isDirectory()) {
            File[] children = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equalsIgnoreCase(fileName);
                }
            });
            return children.length > 0;
        }
        return false;
    }
}

