/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.correlation;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.correlation.AWSCorrelationTracer;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.DynamicParamsProcessor;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.WSFlexibleUtil;
import com.wily.util.properties.AttributeListing;
import java.util.ArrayList;
import java.util.HashMap;

public class WSClientFlexibleFinishCorrelationTracer
extends AWSCorrelationTracer {
    private static final String kReservedWSDMTransactionContext = "Reserved WSDM Transaction Context";
    private DynamicParamsProcessor paramsSchema;
    private String dynamicParamSyntax = null;
    private HashMap dynamicProperties = null;

    public WSClientFlexibleFinishCorrelationTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        WSMUtils.refreshLogLevels();
        WSMUtils.getLogger().debug(" WSClientFlexibleFinishCorrelationTracer ITracer_startTrace");
    }

    private void listHeaders(Object servletRequestImpl) throws Exception {
        ArrayList headerValuesArrayList = (ArrayList)WSMUtils.invokeMethodOnObject(servletRequestImpl, "getHeaderValuesArrayList");
        ArrayList headerNamesArrayList = (ArrayList)WSMUtils.invokeMethodOnObject(servletRequestImpl, "getHeaderNamesArrayList");
        WSMUtils.getLogger().debug("WSClientFlexibleFinishCorrelationTracer Headers as name/value pairs)");
        for (int i = 0; i < headerNamesArrayList.size(); ++i) {
            String value = new String((byte[])headerValuesArrayList.get(i));
            WSMUtils.getLogger().debug((String)headerNamesArrayList.get(i) + " " + value);
        }
    }

    private final void initialiseParams(String name, InvocationData data, String correlationString) throws Exception {
        if (this.dynamicParamSyntax == null) {
            String dynamicParamSyntax = WSFlexibleUtil.getDynamicParamsString(name);
            this.paramsSchema = DynamicParamsProcessor.getInstance(this.getAgent().IAgent_getModuleFeedback(), dynamicParamSyntax, correlationString);
            this.dynamicProperties = this.paramsSchema.processDynamicParams(data);
        }
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        try {
            WSMUtils.refreshLogLevels();
            String correlationString = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
            String formattedName = WSFlexibleUtil.processClientString(this.getNameParameter(), correlationString);
            this.initialiseParams(formattedName, data, correlationString);
            WSFlexibleUtil.setCorrelationId(this.dynamicProperties);
        }
        catch (Throwable t) {
            WSMUtils.getLogger().error("WSClientFlexibleFinishCorrelationTracer ITracer_finishTrace exception " + WSMUtils.dumpStackTrace(t));
        }
    }
}

