/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.axis2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.ANameFormatter;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class Axis2ClientAsyncNameFormatter
extends ANameFormatter {
    protected IModuleFeedbackChannel logger = null;

    public Axis2ClientAsyncNameFormatter(IAgent agent) {
        super(agent);
        this.logger = agent.IAgent_getModuleFeedback();
        WSMUtils.refreshLogLevels();
    }

    @Override
    public String getServiceName(InvocationData data) {
        String serviceURI = null;
        Object call = null;
        try {
            call = data.getInvocationObject();
            if (call != null && (call = WSMUtils.invokeMethodOnObject(call, "getOptions")) != null && (call = WSMUtils.invokeMethodOnObject(call, "getTo")) != null) {
                serviceURI = (String)WSMUtils.invokeMethodOnObject(call, "getAddress");
            }
        }
        catch (Throwable bomb) {
            String message = Thread.currentThread() + " Caught unexpected exception while resolving web service operation namespace URI from " + call.getClass() + " " + bomb;
            WSMUtils.handleError(this.getAgent(), message, bomb);
        }
        return serviceURI == null || serviceURI.equals("") ? "UnknownService" : serviceURI;
    }

    public Object getChild(InvocationData data) throws Exception {
        Object transportNonBlockingInvocationWorker = data.getInvocationObject();
        Object messageContext = WSMUtils.getField(transportNonBlockingInvocationWorker, "msgctx");
        Object soapEnvelope = WSMUtils.invokeMethodOnObject(messageContext, "getEnvelope");
        Object soapBody = WSMUtils.invokeMethodOnObject(soapEnvelope, "getBody");
        return WSMUtils.invokeMethodOnObject(soapBody, "getFirstOMChild");
    }

    @Override
    public String getNamespace(InvocationData data) {
        String namespaceURI = null;
        try {
            Object child = this.getChild(data);
            Object qName = WSMUtils.invokeMethodOnObject(child, "getQName");
            if (this.logger.isDebugEnabled()) {
                try {
                    int n = 1 / 0;
                }
                catch (Throwable bomb) {
                    String message = "Axis2ClientAsyncNameFormatter getNamespace stack trace:  " + bomb;
                    WSMUtils.handleException(this.getAgent(), message, bomb);
                }
            }
            this.logger.debug("Axis2ClientAsyncNameFormatter:: QName= " + qName);
            namespaceURI = (String)WSMUtils.invokeMethodOnObject(qName, "getNamespaceURI");
            this.logger.debug("Axis2ClientAsyncNameFormatter:: namespaceURI= " + namespaceURI);
        }
        catch (Throwable bomb) {
            try {
                String message = Thread.currentThread() + " Caught unexpected exception while resolving web service operation namespace URI from " + data.getInvocationObject().getClass() + " " + bomb;
                WSMUtils.handleError(this.getAgent(), message, bomb);
            }
            catch (Exception e) {
                WSMUtils.handleError(this.getAgent(), "Caught unexpected exception while resolving web service operation namespace URI", bomb);
            }
        }
        return namespaceURI == null || namespaceURI.equals("") ? "UnknownService" : namespaceURI;
    }

    @Override
    public String getOperationName(InvocationData data) {
        String operationName = null;
        try {
            operationName = (String)WSMUtils.invokeMethodOnObject(this.getChild(data), "getLocalName");
            this.logger.debug("Axis2ClientAsyncNameFormatter:: getOperationName operationName= " + operationName);
        }
        catch (Throwable bomb) {
            try {
                String message = " Caught unexpected exception while resolving web service operation namespace URI from " + data.getInvocationObject().getClass() + " " + bomb;
                WSMUtils.handleError(this.getAgent(), message, bomb);
            }
            catch (Exception e) {
                WSMUtils.handleError(this.getAgent(), "Caught unexpected exception while resolving web service operation name", bomb);
            }
        }
        return operationName == null || operationName.equals("") ? "UnknownOperationName" : operationName;
    }
}

